/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.cmp;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class Challenge
extends ASN1Object {
    private AlgorithmIdentifier a;
    private ASN1OctetString b;
    private ASN1OctetString c;

    private Challenge(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        if (aSN1Sequence.size() == 3) {
            this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
        this.b = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(n2++));
        this.c = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(n2));
    }

    public static Challenge getInstance(Object object) {
        if (object instanceof Challenge) {
            return (Challenge)object;
        }
        if (object != null) {
            return new Challenge(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public Challenge(byte[] byArray, byte[] byArray2) {
        this(null, byArray, byArray2);
    }

    public Challenge(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2) {
        this.a = algorithmIdentifier;
        this.b = new DEROctetString(byArray);
        this.c = new DEROctetString(byArray2);
    }

    public AlgorithmIdentifier getOwf() {
        return this.a;
    }

    public byte[] getWitness() {
        return this.b.getOctets();
    }

    public byte[] getChallenge() {
        return this.c.getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.a(aSN1EncodableVector, this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }

    private void a(ASN1EncodableVector aSN1EncodableVector, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(aSN1Encodable);
        }
    }
}

