/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.cmc;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.cmc.BodyPartID;

public class TaggedAttribute
extends ASN1Object {
    private final BodyPartID a;
    private final ASN1ObjectIdentifier b;
    private final ASN1Set c;

    public static TaggedAttribute getInstance(Object object) {
        if (object instanceof TaggedAttribute) {
            return (TaggedAttribute)object;
        }
        if (object != null) {
            return new TaggedAttribute(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private TaggedAttribute(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = BodyPartID.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = ASN1Set.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public TaggedAttribute(BodyPartID bodyPartID, ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Set aSN1Set) {
        this.a = bodyPartID;
        this.b = aSN1ObjectIdentifier;
        this.c = aSN1Set;
    }

    public BodyPartID getBodyPartID() {
        return this.a;
    }

    public ASN1ObjectIdentifier getAttrType() {
        return this.b;
    }

    public ASN1Set getAttrValues() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{this.a, this.b, this.c});
    }
}

