/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.cmc;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Boolean;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.cmc.BodyPartList;
import com.aspose.psd.internal.bouncycastle.asn1.cmc.BodyPartPath;
import com.aspose.psd.internal.bouncycastle.asn1.crmf.CertTemplate;

public class ModCertTemplate
extends ASN1Object {
    private final BodyPartPath a;
    private final BodyPartList b;
    private final boolean c;
    private final CertTemplate d;

    public ModCertTemplate(BodyPartPath bodyPartPath, BodyPartList bodyPartList, boolean bl2, CertTemplate certTemplate) {
        this.a = bodyPartPath;
        this.b = bodyPartList;
        this.c = bl2;
        this.d = certTemplate;
    }

    private ModCertTemplate(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 4 && aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = BodyPartPath.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = BodyPartList.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() == 4) {
            this.c = ASN1Boolean.getInstance(aSN1Sequence.getObjectAt(2)).isTrue();
            this.d = CertTemplate.getInstance(aSN1Sequence.getObjectAt(3));
        } else {
            this.c = true;
            this.d = CertTemplate.getInstance(aSN1Sequence.getObjectAt(2));
        }
    }

    public static ModCertTemplate getInstance(Object object) {
        if (object instanceof ModCertTemplate) {
            return (ModCertTemplate)object;
        }
        if (object != null) {
            return new ModCertTemplate(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public BodyPartPath getPkiDataReference() {
        return this.a;
    }

    public BodyPartList getCertReferences() {
        return this.b;
    }

    public boolean isReplacingFields() {
        return this.c;
    }

    public CertTemplate getCertTemplate() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (!this.c) {
            aSN1EncodableVector.add(ASN1Boolean.getInstance(this.c));
        }
        aSN1EncodableVector.add(this.d);
        return new DERSequence(aSN1EncodableVector);
    }
}

