/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ApplicationSpecific;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OutputStream;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ParsingException;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERApplicationSpecific
extends ASN1ApplicationSpecific {
    DERApplicationSpecific(boolean bl2, int n2, byte[] byArray) {
        super(bl2, n2, byArray);
    }

    public DERApplicationSpecific(int n2, byte[] byArray) {
        this(false, n2, byArray);
    }

    public DERApplicationSpecific(int n2, ASN1Encodable aSN1Encodable) throws IOException {
        this(true, n2, aSN1Encodable);
    }

    public DERApplicationSpecific(boolean bl2, int n2, ASN1Encodable aSN1Encodable) throws IOException {
        super(bl2 || aSN1Encodable.toASN1Primitive().isConstructed(), n2, DERApplicationSpecific.a(bl2, aSN1Encodable));
    }

    private static byte[] a(boolean bl2, ASN1Encodable aSN1Encodable) throws IOException {
        byte[] byArray = aSN1Encodable.toASN1Primitive().getEncoded("DER");
        if (bl2) {
            return byArray;
        }
        int n2 = DERApplicationSpecific.getLengthOfHeader(byArray);
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public DERApplicationSpecific(int n2, ASN1EncodableVector aSN1EncodableVector) {
        super(true, n2, DERApplicationSpecific.a(aSN1EncodableVector));
    }

    private static byte[] a(ASN1EncodableVector aSN1EncodableVector) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 != aSN1EncodableVector.size(); ++i2) {
            try {
                byteArrayOutputStream.write(((ASN1Object)aSN1EncodableVector.get(i2)).getEncoded("DER"));
                continue;
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("malformed object: " + iOException, iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        int n2 = 64;
        if (this.isConstructed) {
            n2 |= 0x20;
        }
        aSN1OutputStream.writeEncoded(n2, this.tag, this.octets);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.isConstructed()) {
            stringBuffer.append("CONSTRUCTED ");
        }
        stringBuffer.append("APPLICATION ");
        stringBuffer.append(Integer.toString(this.getApplicationTag()));
        stringBuffer.append("]");
        if (this.octets != null) {
            stringBuffer.append(" #");
            stringBuffer.append(Hex.toHexString(this.octets));
        } else {
            stringBuffer.append(" #null");
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }
}

