/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.imageoptions;

import com.aspose.psd.ImageOptionsBase;
import com.aspose.psd.coreexceptions.FrameworkException;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.xmp.XmpPacketWrapper;

public class PngOptions
extends ImageOptionsBase {
    public static final int DEFAULT_COMPRESSION_LEVEL = 6;
    private int a = 2;
    private boolean b;
    private int c = 0;
    private int d = 6;
    private byte e = (byte)8;

    public PngOptions() {
    }

    public PngOptions(PngOptions pngOptions) {
        super(pngOptions);
        this.d = pngOptions.d;
        this.a = pngOptions.a;
        this.c = pngOptions.c;
        this.b = pngOptions.b;
        this.setPalette(pngOptions.getPalette());
        this.e = pngOptions.e;
        this.xmpData = pngOptions.xmpData;
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.xmpData;
    }

    @Override
    protected Object b() {
        return new PngOptions(this);
    }

    @Override
    public void setXmpData(XmpPacketWrapper value) {
        this.xmpData = value;
    }

    public int getColorType() {
        return this.a;
    }

    public void setColorType(int value) {
        this.a = value;
    }

    public boolean getProgressive() {
        return this.b;
    }

    public void setProgressive(boolean value) {
        this.b = value;
    }

    public int getFilterType() {
        return this.c;
    }

    public void setFilterType(int value) {
        this.c = value;
    }

    public int getCompressionLevel() {
        return this.d;
    }

    public void setCompressionLevel(int value) {
        if (value > 9 || value < 0) {
            throw new ArgumentOutOfRangeException("value", "Compresion must be in 0-9 range.");
        }
        this.d = value;
    }

    public byte getBitDepth() {
        return this.e;
    }

    public void setBitDepth(byte value) {
        this.e = value;
    }

    public void c() {
        switch (this.a) {
            case 0: {
                if ((this.e & 0xFF) == 1 || (this.e & 0xFF) == 2 || (this.e & 0xFF) == 4 || (this.e & 0xFF) == 8) break;
                throw new FrameworkException("Bit depth of 1, 2, 4 or 8 bits are supported for grayscale images.");
            }
            case 2: {
                if ((this.e & 0xFF) == 8) break;
                throw new FrameworkException("Bit depth of 8 bits are supported for RGB images.");
            }
            case 3: {
                if ((this.e & 0xFF) == 1 || (this.e & 0xFF) == 2 || (this.e & 0xFF) == 4 || (this.e & 0xFF) == 8) break;
                throw new FrameworkException("Bit depth of 1, 2, 4 or 8 bits are supported for palette images.");
            }
            case 4: {
                if ((this.e & 0xFF) == 8) break;
                throw new FrameworkException("Bit depth of 8 bits are supported for grayscale images with alpha channel.");
            }
            case 6: {
                if ((this.e & 0xFF) == 8) break;
                throw new FrameworkException("Bit depth of 8 bits are supported for RGBA images.");
            }
            default: {
                throw new ArgumentOutOfRangeException();
            }
        }
    }
}

