/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd;

import com.aspose.psd.DisposableObject;
import com.aspose.psd.F;
import com.aspose.psd.G;
import com.aspose.psd.H;
import com.aspose.psd.I;
import com.aspose.psd.coreexceptions.FrameworkException;
import com.aspose.psd.internal.Exceptions.ArgumentException;
import com.aspose.psd.internal.Exceptions.ArgumentNullException;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.bG.aW;
import com.aspose.psd.internal.bG.av;
import com.aspose.psd.internal.bG.bD;
import com.aspose.psd.internal.bV.k;
import com.aspose.psd.internal.gJ.c;
import com.aspose.psd.internal.gK.d;
import com.aspose.psd.internal.gL.ce;
import com.aspose.psd.internal.gL.cf;
import com.aspose.psd.internal.kL.e;
import com.aspose.psd.system.io.FileStream;
import com.aspose.psd.system.io.MemoryStream;
import com.aspose.psd.system.io.Stream;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamContainer
extends DisposableObject
implements e {
    public static final int READ_WRITE_BYTES_COUNT = 4096;
    protected final long startPosition;
    private final Stream a;
    private boolean b;
    private final Object c;
    private boolean d = false;

    public StreamContainer(InputStream stream) {
        this(Stream.fromJava(stream));
    }

    public StreamContainer(Stream stream) {
        this(stream, false);
    }

    public StreamContainer(InputStream stream, boolean disposeStream) {
        this(Stream.fromJava(stream), disposeStream, false);
    }

    public StreamContainer(Stream stream, boolean disposeStream) {
        this(stream, disposeStream, false);
    }

    StreamContainer(Stream stream, boolean disposeStream, boolean disposeDuplicatedStreams) {
        Stream stream2;
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.b = disposeStream;
        this.startPosition = stream.getPosition();
        this.a = stream2 = stream instanceof e ? stream : cf.a().a(stream, disposeDuplicatedStreams, disposeStream);
        this.d = stream2 != stream;
        this.c = ce.a(stream2, stream);
    }

    StreamContainer(Stream stream, long startPosition, boolean disposeStream) {
        this(stream, startPosition, disposeStream, false);
    }

    public static StreamContainer a(Stream stream, long l2, boolean bl2) {
        return new StreamContainer(stream, l2, bl2);
    }

    StreamContainer(Stream stream, long startPosition, boolean disposeStream, boolean disposeDuplicatedStreams) {
        Stream stream2;
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        if (startPosition < 0L || startPosition != 0L && startPosition >= stream.getLength()) {
            throw new ArgumentOutOfRangeException("startPosition");
        }
        this.b = disposeStream;
        this.startPosition = startPosition;
        this.a = stream2 = stream instanceof e ? stream : cf.a().a(stream, disposeDuplicatedStreams, disposeStream);
        this.d = stream2 != stream;
        this.c = ce.a(stream2, stream);
    }

    public static Stream to_Stream(StreamContainer streamContainer) {
        Stream stream = null;
        if (streamContainer != null) {
            stream = streamContainer.a;
        }
        return stream;
    }

    @Override
    public Object getSyncRoot() {
        this.verifyNotDisposed();
        return ce.a(this.a(), this.c);
    }

    public long getPosition() {
        this.verifyNotDisposed();
        return this.a.getPosition() - this.startPosition;
    }

    public void setPosition(long value) {
        this.verifyNotDisposed();
        this.a.setPosition(value + this.startPosition);
    }

    public InputStream getStream() {
        return Stream.toJava(this.a());
    }

    public Stream a() {
        this.verifyNotDisposed();
        return this.a;
    }

    public static StreamContainer a(StreamContainer streamContainer) {
        if (streamContainer == null) {
            return null;
        }
        boolean bl2 = streamContainer.b;
        streamContainer.b();
        return new StreamContainer(streamContainer.a, bl2);
    }

    private void b() {
        this.b = false;
    }

    public boolean isStreamDisposedOnClose() {
        this.verifyNotDisposed();
        return this.b;
    }

    public long getLength() {
        this.verifyNotDisposed();
        return this.a.getLength() - this.startPosition;
    }

    public void setLength(long value) {
        this.verifyNotDisposed();
        this.a.setLength(value + this.startPosition);
    }

    public boolean canRead() {
        this.verifyNotDisposed();
        return this.a.canRead();
    }

    public boolean canSeek() {
        this.verifyNotDisposed();
        return this.a.canSeek();
    }

    public boolean canWrite() {
        this.verifyNotDisposed();
        return this.a.canWrite();
    }

    public void flush() {
        this.verifyNotDisposed();
        this.a.flush();
    }

    public void write(byte[] bytes) {
        this.verifyNotDisposed();
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.a.write(bytes, 0, bytes.length);
    }

    public void writeByte(byte value) {
        this.verifyNotDisposed();
        this.a.writeByte(value);
    }

    public int read(byte[] bytes) {
        this.verifyNotDisposed();
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        return this.a.read(bytes, 0, bytes.length);
    }

    public byte[] toBytes() {
        this.verifyNotDisposed();
        return this.toBytes(0L, this.getLength());
    }

    public byte[] toBytes(long position, long bytesCount) {
        this.verifyNotDisposed();
        if (position >= this.getLength() || position < 0L) {
            throw new ArgumentOutOfRangeException("position", "The starting position is out of stream bounds.");
        }
        if (bytesCount > this.getLength()) {
            throw new ArgumentOutOfRangeException("bytesCount", "The stream does not contain so many bytes.");
        }
        if (bytesCount + position > this.getLength() && bytesCount > 0L) {
            throw new ArgumentException("Reading so many bytes will cause passing the stream end.");
        }
        if (this.a.canSeek()) {
            this.setPosition(position);
        } else if (this.getPosition() != position) {
            throw new FrameworkException("Cannot seek to the desired position. The stream does not support seeking.");
        }
        byte[] byArray = new byte[(int)bytesCount];
        int n2 = 0;
        byte[] byArray2 = new byte[4096];
        while (bytesCount > 0L) {
            int n3 = (int)bD.d((long)byArray2.length, bytesCount);
            if (this.a.read(byArray2, 0, n3) != n3) {
                throw new FrameworkException(aW.a(new String[]{"Copy operation cannot complete. Cannot read ", av.b(n3), " bytes."}));
            }
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            n2 += n3;
            bytesCount -= (long)n3;
        }
        return byArray;
    }

    public int read(byte[] buffer, int offset, int count) {
        this.verifyNotDisposed();
        return this.a.read(buffer, offset, count);
    }

    public int readByte() {
        this.verifyNotDisposed();
        return this.a.readByte();
    }

    public long seek(long offset, int origin) {
        this.verifyNotDisposed();
        switch (origin) {
            case 0: {
                this.a.seek(offset + this.startPosition, 0);
                break;
            }
            case 1: {
                this.a.seek(offset, 1);
                break;
            }
            case 2: {
                this.a.seek(offset, 2);
            }
        }
        return this.getPosition();
    }

    public void seekBegin() {
        this.verifyNotDisposed();
        this.a.seek(this.startPosition, 0);
    }

    public void write(byte[] buffer, int offset, int count) {
        this.verifyNotDisposed();
        this.a.write(buffer, offset, count);
    }

    public void save(OutputStream destinationStream) {
        if (destinationStream instanceof com.aspose.psd.internal.fY.d) {
            this.saveInternal(((com.aspose.psd.internal.fY.d)destinationStream).a());
        } else {
            com.aspose.psd.internal.gJ.c.a(new F(this, destinationStream));
        }
    }

    void saveInternal(Stream destinationStream) {
        this.saveInternal(destinationStream, 4096, this.getLength());
    }

    public void save(OutputStream destinationStream, int bufferSize) {
        if (destinationStream instanceof com.aspose.psd.internal.fY.d) {
            this.saveInternal(((com.aspose.psd.internal.fY.d)destinationStream).a(), bufferSize);
        } else {
            com.aspose.psd.internal.gJ.c.a(new G(this, destinationStream, bufferSize));
        }
    }

    void saveInternal(Stream destinationStream, int bufferSize) {
        this.saveInternal(destinationStream, bufferSize, this.getLength());
    }

    public void save(OutputStream destinationStream, int bufferSize, long length) {
        if (destinationStream instanceof com.aspose.psd.internal.fY.d) {
            this.saveInternal(((com.aspose.psd.internal.fY.d)destinationStream).a(), bufferSize, length);
        } else {
            com.aspose.psd.internal.gJ.c.a(new H(this, destinationStream, bufferSize, length));
        }
    }

    void saveInternal(Stream destinationStream, int bufferSize, long length) {
        int n2;
        this.verifyNotDisposed();
        if (destinationStream == null) {
            throw new ArgumentNullException("destinationStream");
        }
        if (destinationStream == this.a) {
            throw new FrameworkException("Saving to the same stream is not allowed.");
        }
        if (bufferSize <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "The buffer must be positive.");
        }
        this.beforeSave(destinationStream.toOutputStream());
        byte[] byArray = new byte[(int)bD.d((long)bufferSize, length)];
        while (length > 0L && (n2 = this.a.read(byArray, 0, (int)bD.d((long)byArray.length, length))) > 0) {
            destinationStream.write(byArray, 0, n2);
            length -= (long)n2;
        }
    }

    public void save(String filePath) {
        this.save(filePath, 4096, this.getLength());
    }

    public void save(String filePath, int bufferSize) {
        this.save(filePath, bufferSize, this.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filePath, int bufferSize, long length) {
        this.verifyNotDisposed();
        if (filePath == null) {
            throw new ArgumentNullException("filePath");
        }
        this.a.setPosition(0L);
        FileStream fileStream = k.b(filePath);
        try {
            this.saveInternal(fileStream, bufferSize, length);
        }
        finally {
            fileStream.dispose();
        }
    }

    public void writeTo(StreamContainer streamContainer) {
        long l2 = this.getLength() - this.getPosition();
        this.writeTo(streamContainer, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(StreamContainer streamContainer, long length) {
        MemoryStream memoryStream = new MemoryStream(this.toBytes());
        try {
            byte[] byArray = new byte[4096];
            while (length > 0L) {
                int n2 = (int)bD.d((long)byArray.length, length);
                if (((Stream)memoryStream).read(byArray, 0, n2) != n2) {
                    throw new FrameworkException(aW.a(new String[]{"Copy operation cannot complete. Cannot read ", av.b(n2), " bytes."}));
                }
                length -= (long)n2;
                streamContainer.write(byArray, 0, n2);
            }
        }
        finally {
            memoryStream.dispose();
        }
    }

    protected void afterStreamDisposed() {
    }

    protected void beforeStreamDisposed() {
    }

    void beforeSaveInternal(Stream destinationStream) {
    }

    protected void beforeSave(OutputStream destinationStream) {
        if (destinationStream instanceof com.aspose.psd.internal.fY.d) {
            this.beforeSaveInternal(((com.aspose.psd.internal.fY.d)destinationStream).a());
        } else {
            com.aspose.psd.internal.gJ.c.a(new I(this, destinationStream));
        }
    }

    @Override
    protected void releaseManagedResources() {
        try {
            this.disposeStream();
        }
        finally {
            super.releaseManagedResources();
        }
    }

    protected void disposeStream() {
        if (this.b) {
            this.beforeStreamDisposed();
            try {
                ce ce2 = (ce)((Object)com.aspose.psd.internal.gK.d.a(this.a, ce.class));
                if (ce2 != null && ce2.c()) {
                    return;
                }
                this.a.dispose();
            }
            finally {
                this.afterStreamDisposed();
            }
        } else if (this.d) {
            ce[] ceArray = new ce[]{null};
            boolean bl2 = ce.a(this, ceArray);
            ce ce3 = ceArray[0];
            if (bl2) {
                cf.a().a(ce3);
            }
        }
    }
}

