/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd;

import com.aspose.psd.PointF;
import com.aspose.psd.Rectangle;
import com.aspose.psd.SizeF;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.bG.aW;
import com.aspose.psd.internal.bG.bD;
import com.aspose.psd.internal.bU.i;
import com.aspose.psd.system.SerializableAttribute;

@SerializableAttribute
public class RectangleF
extends com.aspose.psd.internal.gK.i<RectangleF> {
    private static final RectangleF a = new RectangleF();
    private float b;
    private float c;
    private float d;
    private float e;

    public RectangleF() {
        this.d = 0.0f;
        this.e = 0.0f;
        this.c = 0.0f;
        this.b = 0.0f;
    }

    public RectangleF(float x2, float y2, float width, float height) {
        this.d = x2;
        this.e = y2;
        this.c = width;
        this.b = height;
    }

    public RectangleF(PointF location, SizeF size) {
        this.d = location.getX();
        this.e = location.getY();
        this.c = size.getWidth();
        this.b = size.getHeight();
    }

    public static RectangleF getEmpty() {
        return a.Clone();
    }

    public PointF getLocation() {
        return new PointF(this.d, this.e);
    }

    public void setLocation(PointF value) {
        this.d = value.getX();
        this.e = value.getY();
    }

    public SizeF getSize() {
        return new SizeF(this.c, this.b);
    }

    public void setSize(SizeF value) {
        this.c = value.getWidth();
        this.b = value.getHeight();
    }

    public float getX() {
        return this.d;
    }

    public void setX(float value) {
        this.d = value;
    }

    public float getY() {
        return this.e;
    }

    public void setY(float value) {
        this.e = value;
    }

    public float getWidth() {
        return this.c;
    }

    public void setWidth(float value) {
        this.c = value;
    }

    public float getHeight() {
        return this.b;
    }

    public void setHeight(float value) {
        this.b = value;
    }

    public float getLeft() {
        return this.d;
    }

    public void setLeft(float value) {
        float f2 = value - this.d;
        this.d = value;
        this.c -= f2;
    }

    public float getTop() {
        return this.e;
    }

    public void setTop(float value) {
        float f2 = value - this.e;
        this.e = value;
        this.b -= f2;
    }

    public float getRight() {
        return this.d + this.c;
    }

    public void setRight(float value) {
        float f2 = value - this.getRight();
        this.c += f2;
    }

    public float getBottom() {
        return this.e + this.b;
    }

    public void setBottom(float value) {
        float f2 = value - this.getBottom();
        this.b += f2;
    }

    public boolean isEmpty() {
        if (this.c > 0.0f) {
            return this.b <= 0.0f;
        }
        return true;
    }

    public static RectangleF fromPoints(PointF point1, PointF point2) {
        float f2 = bD.b(point1.getX(), point2.getX());
        float f3 = bD.a(point1.getX(), point2.getX());
        float f4 = bD.b(point1.getY(), point2.getY());
        float f5 = bD.a(point1.getY(), point2.getY());
        return RectangleF.fromLeftTopRightBottom(f2, f4, f3, f5);
    }

    public static RectangleF inflate(RectangleF rect, float x2, float y2) {
        RectangleF rectangleF = rect.Clone();
        rectangleF.inflate(x2, y2);
        return rectangleF;
    }

    public static RectangleF intersect(RectangleF a2, RectangleF b2) {
        float f2 = bD.a(a2.d, b2.d);
        float f3 = bD.b(a2.d + a2.c, b2.d + b2.c);
        float f4 = bD.a(a2.e, b2.e);
        float f5 = bD.b(a2.e + a2.b, b2.e + b2.b);
        if (f3 >= f2 && f5 >= f4) {
            return new RectangleF(f2, f4, f3 - f2, f5 - f4);
        }
        return a.Clone();
    }

    public static RectangleF union(RectangleF a2, RectangleF b2) {
        float f2 = bD.b(a2.d, b2.d);
        float f3 = bD.a(a2.d + a2.c, b2.d + b2.c);
        float f4 = bD.b(a2.e, b2.e);
        float f5 = bD.a(a2.e + a2.b, b2.e + b2.b);
        return new RectangleF(f2, f4, f3 - f2, f5 - f4);
    }

    public static boolean op_Equality(RectangleF left, RectangleF right) {
        return left.d == right.d && left.e == right.e && left.c == right.c && left.b == right.b;
    }

    public static boolean op_Inequality(RectangleF left, RectangleF right) {
        return !RectangleF.op_Equality(left, right);
    }

    public static RectangleF op_Multiply(RectangleF rectangle, float multiplier) {
        return new RectangleF(rectangle.d * multiplier, rectangle.e * multiplier, rectangle.c * multiplier, rectangle.b * multiplier);
    }

    public static RectangleF op_Division(RectangleF rectangle, float divider) {
        if (divider == 0.0f) {
            throw new ArgumentOutOfRangeException("divider", "Division by zero is not allowed.");
        }
        return new RectangleF(rectangle.d / divider, rectangle.e / divider, rectangle.c / divider, rectangle.b / divider);
    }

    public static RectangleF to_RectangleF(Rectangle rect) {
        return new RectangleF(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static RectangleF fromLeftTopRightBottom(float left, float top, float right, float bottom) {
        return new RectangleF(left, top, right - left, bottom - top);
    }

    public void normalize() {
        if (this.c < 0.0f) {
            this.d += this.c;
            this.c = -this.c;
        }
        if (this.b < 0.0f) {
            this.e += this.b;
            this.b = -this.b;
        }
    }

    public boolean contains(float x2, float y2) {
        return this.d <= x2 && x2 < this.d + this.c && this.e <= y2 && y2 < this.e + this.b;
    }

    public boolean contains(PointF point) {
        return this.contains(point.getX(), point.getY());
    }

    public boolean contains(RectangleF rect) {
        return this.d <= rect.d && rect.d + rect.c <= this.d + this.c && this.e <= rect.e && rect.e + rect.b <= this.e + this.b;
    }

    public void inflate(float x2, float y2) {
        this.d -= x2;
        this.e -= y2;
        this.c += 2.0f * x2;
        this.b += 2.0f * y2;
    }

    public void inflate(SizeF size) {
        this.inflate(size.getWidth(), size.getHeight());
    }

    public void intersect(RectangleF rect) {
        RectangleF rectangleF = RectangleF.intersect(rect, this);
        this.d = rectangleF.d;
        this.e = rectangleF.e;
        this.c = rectangleF.c;
        this.b = rectangleF.b;
    }

    public boolean intersectsWith(RectangleF rect) {
        return rect.d < this.d + this.c && this.d < rect.d + rect.c && rect.e < this.e + this.b && this.e < rect.e + rect.b;
    }

    public void offset(PointF pos) {
        this.offset(pos.getX(), pos.getY());
    }

    public void offset(float x2, float y2) {
        this.d += x2;
        this.e += y2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RectangleF)) {
            return false;
        }
        RectangleF rectangleF = (RectangleF)obj;
        return rectangleF.d == this.d && rectangleF.e == this.e && rectangleF.c == this.c && rectangleF.b == this.b;
    }

    public int hashCode() {
        return (int)((long)this.d ^ ((long)this.e << 13 | (long)this.e >> 19) ^ ((long)this.c << 26 | (long)this.c >> 6) ^ ((long)this.b << 7 | (long)this.b >> 25));
    }

    public String toString() {
        return aW.a(i.h(), "{{X={0}, Y={1}, Width={2}, Height={3}}}", Float.valueOf(this.d), Float.valueOf(this.e), Float.valueOf(this.c), Float.valueOf(this.b));
    }

    @Override
    public void CloneTo(RectangleF that) {
        that.b = this.b;
        that.c = this.c;
        that.d = this.d;
        that.e = this.e;
    }

    @Override
    public RectangleF Clone() {
        RectangleF rectangleF = new RectangleF();
        this.CloneTo(rectangleF);
        return rectangleF;
    }

    public static boolean isEquals(RectangleF obj1, RectangleF obj2) {
        return obj1.equals(obj2);
    }
}

