/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd;

import com.aspose.psd.Color;
import com.aspose.psd.DataStreamSupporter;
import com.aspose.psd.DisposableObject;
import com.aspose.psd.FileStreamContainer;
import com.aspose.psd.IColorPalette;
import com.aspose.psd.IImageCreator;
import com.aspose.psd.IImageLoader;
import com.aspose.psd.IImageLoaderDescriptor;
import com.aspose.psd.IObjectWithBounds;
import com.aspose.psd.ImageCreatorsRegistry;
import com.aspose.psd.ImageExportersRegistry;
import com.aspose.psd.ImageLoadersRegistry;
import com.aspose.psd.ImageOptionsBase;
import com.aspose.psd.ImageResizeSettings;
import com.aspose.psd.LoadOptions;
import com.aspose.psd.Point;
import com.aspose.psd.ProgressEventHandler;
import com.aspose.psd.Rectangle;
import com.aspose.psd.Size;
import com.aspose.psd.StreamContainer;
import com.aspose.psd.coreexceptions.FrameworkException;
import com.aspose.psd.coreexceptions.ImageCreateException;
import com.aspose.psd.coreexceptions.ImageException;
import com.aspose.psd.coreexceptions.ImageLoadException;
import com.aspose.psd.coreexceptions.ImageSaveException;
import com.aspose.psd.coreexceptions.OperationInterruptedException;
import com.aspose.psd.internal.Exceptions.ArgumentException;
import com.aspose.psd.internal.Exceptions.ArgumentNullException;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.aX.l;
import com.aspose.psd.internal.aZ.D;
import com.aspose.psd.internal.bG.aE;
import com.aspose.psd.internal.bG.aW;
import com.aspose.psd.internal.bG.bD;
import com.aspose.psd.internal.bV.k;
import com.aspose.psd.internal.bg.u;
import com.aspose.psd.internal.bg.w;
import com.aspose.psd.internal.fY.d;
import com.aspose.psd.internal.gL.be;
import com.aspose.psd.internal.gL.ce;
import com.aspose.psd.internal.gL.cf;
import com.aspose.psd.internal.gL.cz;
import com.aspose.psd.internal.le.e;
import com.aspose.psd.internal.le.g;
import com.aspose.psd.internal.le.i;
import com.aspose.psd.internal.lp.b;
import com.aspose.psd.internal.lp.c;
import com.aspose.psd.internal.lw.a;
import com.aspose.psd.multithreading.InterruptMonitor;
import com.aspose.psd.progressmanagement.EventType;
import com.aspose.psd.progressmanagement.ProgressEventHandlerInfo;
import com.aspose.psd.r;
import com.aspose.psd.sources.StreamSource;
import com.aspose.psd.system.Enum;
import com.aspose.psd.system.Event;
import com.aspose.psd.system.io.FileStream;
import com.aspose.psd.system.io.Stream;
import com.aspose.psd.t;
import com.aspose.psd.v;
import com.aspose.psd.x;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Image
extends DataStreamSupporter
implements IObjectWithBounds,
b,
c {
    private static com.aspose.psd.internal.gL.d a;
    public static final Event<com.aspose.psd.internal.gL.d> g;
    private static com.aspose.psd.internal.gL.b b;
    public static final Event<com.aspose.psd.internal.gL.b> h;
    private cz<Image> j = new cz();
    private IColorPalette k;
    private Object l;
    private boolean m = false;
    private boolean n;
    private InterruptMonitor o;
    private final AtomicReference<i> p = new AtomicReference<Object>(null);
    private ProgressEventHandlerInfo q;
    private u r;
    private boolean s = false;
    private final Color t = Color.getWhite();
    protected StreamContainer i;
    private StreamContainer u;
    private l v;
    private boolean w;

    protected Image() {
    }

    protected Image(IColorPalette colorPalette) {
        this.k = colorPalette;
    }

    public static boolean canLoad(String filePath) {
        return Image.canLoad(filePath, null);
    }

    public final l y() {
        if (this.v == null) {
            this.v = new l();
        }
        return this.v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canLoad(String filePath, LoadOptions loadOptions) {
        Object object = SyncOperation;
        synchronized (object) {
            boolean bl2;
            FileStream fileStream = com.aspose.psd.internal.bV.k.a(filePath, 3, 3, 3);
            try {
                bl2 = Image.a((Stream)fileStream, loadOptions);
            }
            catch (Throwable throwable) {
                fileStream.dispose();
                throw throwable;
            }
            fileStream.dispose();
            return bl2;
        }
    }

    public static boolean canLoad(InputStream stream) {
        return Image.d(Stream.fromJava(stream));
    }

    public static boolean d(Stream stream) {
        return Image.a(stream, null);
    }

    public static boolean canLoad(InputStream stream, LoadOptions loadOptions) {
        return Image.a(Stream.fromJava(stream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean a(Stream stream, LoadOptions loadOptions) {
        boolean bl2;
        ce ce2 = null;
        try {
            ce2 = cf.a().a(stream);
            bl2 = ImageLoadersRegistry.a(ce2, loadOptions) != null;
        }
        finally {
            cf.a().a(ce2);
        }
        return bl2;
    }

    public static Image create(ImageOptionsBase imageOptions, int width, int height) {
        if (imageOptions == null) {
            throw new ArgumentNullException("imageOptions");
        }
        if (imageOptions.getSource() == null) {
            throw new ArgumentNullException("imageOptions", "Please specify source for the image creation.");
        }
        if (width <= 0) {
            throw new ArgumentOutOfRangeException("width", "Expected positive width value.");
        }
        if (height <= 0) {
            throw new ArgumentOutOfRangeException("height", "Expected positive height value.");
        }
        return Image.a(imageOptions, width, height);
    }

    public static Image create(Image[] images) {
        return new be(images, false);
    }

    public static Image create(Image[] images, boolean disposeImages) {
        return new be(images, disposeImages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileFormat(String filePath) {
        FileStream fileStream = com.aspose.psd.internal.bV.k.a(filePath, 3, 1, 1);
        try {
            long l2 = Image.getFileFormat(fileStream.toInputStream());
            return l2;
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileFormat(Stream stream) {
        ce ce2 = cf.a().a(stream);
        Object object = ce2.getSyncRoot();
        synchronized (object) {
            long l2;
            try {
                l2 = Image.a((Stream)ce2, false);
                ce2.e();
            }
            catch (Throwable throwable) {
                ce2.e();
                throw throwable;
            }
            return l2;
        }
    }

    public static long getFileFormat(InputStream stream) {
        return Image.getFileFormat(Stream.fromJava(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long a(Stream stream, boolean bl2) {
        long l2 = 0L;
        long l3 = stream.getPosition();
        IImageLoaderDescriptor iImageLoaderDescriptor = ImageLoadersRegistry.getFirstSupportedDescriptor(stream.toInputStream(), null);
        if (iImageLoaderDescriptor != null) {
            l2 = iImageLoaderDescriptor.getSupportedFormat();
        } else if (!bl2) {
            stream.setPosition(l3);
            try {
                Stream stream2 = com.aspose.psd.internal.lQ.b.a(stream);
                if (stream2 == null) {
                    long l4 = l2;
                    return l4;
                }
                Stream stream3 = stream2;
                try {
                    long l5 = Image.a(stream3, true);
                    if (stream3 != null) {
                        stream3.dispose();
                    }
                    return l5;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream3 != null) {
                            stream3.dispose();
                        }
                        throw throwable;
                    }
                    catch (RuntimeException runtimeException) {
                        long l6 = 0L;
                        return l6;
                    }
                }
            }
            finally {
                stream.setPosition(l3);
            }
        }
        return l2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int width, int height) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle, new Rectangle(new Point(), new Size(bD.a(width), bD.a(height))));
        if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) {
            throw new ArgumentException("The rectangle has no common processing area. Cannot proceed.");
        }
        return rectangle2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int[] pixels, int width, int height) {
        if (pixels == null) {
            throw new ArgumentNullException("pixels");
        }
        Rectangle rectangle2 = Image.getFittingRectangle(rectangle, width, height);
        if (pixels.length < rectangle2.getWidth() * rectangle2.getHeight()) {
            String string = aW.a("The passed rectangle does not correspond to pixels array size. Expected: {0} pixels, passed: {1} pixels.", new Object[]{rectangle2.getWidth() * rectangle2.getHeight(), pixels.length});
            throw new ImageException(string);
        }
        return rectangle2;
    }

    public static Image load(String filePath, LoadOptions loadOptions) {
        return Image.a(FileStreamContainer.openFileStream(filePath, true), loadOptions);
    }

    public static Image load(String filePath) {
        return Image.a(FileStreamContainer.openFileStream(filePath, true), null);
    }

    public static Image load(RandomAccessFile file, LoadOptions loadOptions) {
        return Image.b(new a(file), loadOptions);
    }

    public static Image load(RandomAccessFile file) {
        return Image.b(new a(file), null);
    }

    public static Image load(InputStream stream, LoadOptions loadOptions) {
        return Image.b(Stream.fromJava(stream), loadOptions);
    }

    public static Image b(Stream stream, LoadOptions loadOptions) {
        StreamContainer streamContainer = new StreamContainer(stream, 0L, false);
        return Image.a(streamContainer, loadOptions);
    }

    public static Image load(InputStream stream) {
        return Image.e(Stream.fromJava(stream));
    }

    public static Image e(Stream stream) {
        return Image.b(stream, null);
    }

    public static Image a(Stream stream, long l2, LoadOptions loadOptions) {
        StreamContainer streamContainer = new StreamContainer(stream, l2, false);
        return Image.a(streamContainer, loadOptions);
    }

    public static Image a(Stream stream, long l2) {
        return Image.a(stream, l2, null);
    }

    public static Image f(Stream stream) {
        return Image.a(stream, 0L, null);
    }

    public static int getProportionalWidth(int width, int height, int newHeight) {
        double d2 = (double)newHeight / (double)height;
        return com.aspose.psd.internal.gK.d.e(d2 * (double)width + 0.5);
    }

    public static int getProportionalHeight(int width, int height, int newWidth) {
        double d2 = (double)newWidth / (double)width;
        return com.aspose.psd.internal.gK.d.e(d2 * (double)height + 0.5);
    }

    public abstract D a(ImageOptionsBase var1, int var2, Rectangle var3);

    protected static void doAfterLoad(long[] maximum, InputStream stream) {
        Image.a(maximum, Stream.fromJava(stream));
    }

    protected static void a(long[] lArray, Stream stream) {
        if (a != null) {
            a.a(lArray, stream);
        }
    }

    protected static void doAfterCreate(long[] maximum, long imageSize) {
        if (b != null) {
            b.a(maximum, imageSize);
        }
    }

    private static void a(ProgressEventHandlerInfo progressEventHandlerInfo, EventType eventType) {
        if (progressEventHandlerInfo != null) {
            progressEventHandlerInfo.a(eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static Image a(ImageOptionsBase imageOptionsBase, int n2, int n3) {
        Object object;
        StreamSource streamSource = (StreamSource)((Object)com.aspose.psd.internal.gK.d.a(imageOptionsBase.getSource(), StreamSource.class));
        Stream stream = streamSource != null ? streamSource.getStream() : null;
        Object object2 = object = ce.a(stream, stream == null ? new Object() : stream);
        synchronized (object2) {
            ProgressEventHandlerInfo progressEventHandlerInfo = null;
            if (imageOptionsBase.getProgressEventHandler() != null) {
                progressEventHandlerInfo = ProgressEventHandlerInfo.a(4);
                progressEventHandlerInfo.a(imageOptionsBase.getProgressEventHandler());
            }
            Image.a(progressEventHandlerInfo, EventType.Initialization);
            StreamContainer streamContainer = imageOptionsBase.getSource().getStreamContainer();
            boolean bl2 = true;
            try {
                Object object3;
                block17: {
                    IImageCreator iImageCreator = ImageCreatorsRegistry.createFirstSupportedCreator(imageOptionsBase);
                    if (iImageCreator == null) {
                        throw new ImageLoadException("Cannot create a new image. The image file format may be not supported at the moment.");
                    }
                    Image.a(progressEventHandlerInfo, EventType.PreProcessing);
                    Image image = iImageCreator.create(streamContainer, imageOptionsBase, n2, n3);
                    try {
                        image.q = progressEventHandlerInfo;
                        Image.a(progressEventHandlerInfo, EventType.Processing);
                        image.setDataStreamContainer(streamContainer);
                        image.a(com.aspose.psd.internal.le.g.a(imageOptionsBase), true);
                        Image.a(progressEventHandlerInfo, EventType.Finalization);
                        if (!imageOptionsBase.getIgnoreAfterCreate_internalized()) {
                            object3 = new long[]{image.f};
                            Image.doAfterCreate((long[])object3, (long)image.getWidth() * (long)image.getHeight());
                            image.f = (long)object3[0];
                        }
                        bl2 = false;
                        object3 = image;
                        if (!bl2) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bl2) {
                                image.close();
                            }
                            throw throwable;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new ImageCreateException("Image creation failed.", runtimeException);
                        }
                        catch (Error error) {
                            throw new ImageCreateException("Image creation failed.", error);
                        }
                    }
                    image.close();
                }
                return object3;
            }
            finally {
                if (bl2) {
                    streamContainer.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image a(StreamContainer streamContainer, LoadOptions loadOptions) {
        if (streamContainer.getLength() == 0L) {
            throw new ImageLoadException("Cannot open an image. The image size can not be 0!");
        }
        boolean bl2 = true;
        i i2 = null;
        try {
            Object object = streamContainer.getSyncRoot();
            synchronized (object) {
                Object object2;
                ProgressEventHandlerInfo progressEventHandlerInfo = null;
                if (loadOptions != null && loadOptions.getProgressEventHandler() != null) {
                    progressEventHandlerInfo = ProgressEventHandlerInfo.a(4);
                    progressEventHandlerInfo.a(loadOptions.getProgressEventHandler());
                }
                Image.a(progressEventHandlerInfo, EventType.Initialization);
                IImageLoader iImageLoader = ImageLoadersRegistry.createFirstSupportedLoader(streamContainer.a(), loadOptions, false);
                if (iImageLoader == null) {
                    Stream stream = com.aspose.psd.internal.lQ.b.a(streamContainer.a());
                    if (stream != null) {
                        if (streamContainer.getLength() == 0L) {
                            stream.dispose();
                            throw new ImageLoadException("Cannot open an image. The image size can not be 0!");
                        }
                        StreamContainer streamContainer2 = new StreamContainer(stream);
                        try {
                            Image image = Image.a(streamContainer2, loadOptions);
                            image.u = streamContainer;
                            return image;
                        }
                        catch (RuntimeException runtimeException) {
                            streamContainer2.dispose();
                            throw runtimeException;
                        }
                    }
                    throw new ImageLoadException("Cannot open an image. The image file format may be not supported at the moment.");
                }
                Image.a(progressEventHandlerInfo, EventType.PreProcessing);
                i2 = com.aspose.psd.internal.le.g.a(loadOptions);
                if (com.aspose.psd.internal.gK.d.b((Object)iImageLoader, e.class)) {
                    ((e)((Object)iImageLoader)).a(i2);
                }
                u u2 = null;
                if (loadOptions != null && loadOptions.a != null) {
                    u2 = new u();
                    object2 = u2;
                    loadOptions.a.forEach(new v((u)object2));
                }
                Image.a(progressEventHandlerInfo, EventType.Processing);
                Image image = iImageLoader.load(streamContainer, loadOptions);
                if (image.getDataStreamContainer() != streamContainer) {
                    object2 = image.getDataStreamContainer();
                    if (object2 != null && !((DisposableObject)object2).getDisposed()) {
                        ((DisposableObject)object2).dispose();
                    }
                    image.setDataStreamContainer(streamContainer);
                }
                image.a(i2, true);
                image.q = progressEventHandlerInfo;
                if (u2 != null) {
                    image.r = u2;
                }
                Image.a(progressEventHandlerInfo, EventType.Finalization);
                if (loadOptions == null || !loadOptions.b()) {
                    object2 = new long[]{image.f};
                    Image.a((long[])object2, streamContainer.a());
                    image.f = (long)object2[0];
                }
                image.m = false;
                bl2 = false;
                return image;
            }
        }
        catch (RuntimeException runtimeException) {
            cf cf2 = (cf)cf.a();
            cf.a(streamContainer);
            throw new ImageLoadException("Image loading failed.", runtimeException);
        }
    }

    public abstract int getBitsPerPixel();

    @Override
    public Rectangle getBounds() {
        this.verifyNotDisposed();
        return new Rectangle(Point.getEmpty(), this.getSize());
    }

    public Image getContainer() {
        return this.j.c();
    }

    private Image a() {
        return this.j.c();
    }

    private void b(Image image) {
        this.a(image);
    }

    @Override
    public abstract int getHeight();

    public IColorPalette getPalette() {
        return this.k;
    }

    public void setPalette(IColorPalette value) {
        if (this.k != value) {
            IColorPalette iColorPalette = this.k;
            this.onPaletteChanging(iColorPalette, value);
            this.k = value;
            this.onPaletteChanged(iColorPalette, value);
        }
    }

    public boolean isUsePalette() {
        return false;
    }

    @Override
    public Size getSize() {
        this.verifyNotDisposed();
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public abstract int getWidth();

    public InterruptMonitor getInterruptMonitor() {
        return this.o;
    }

    public void setInterruptMonitor(InterruptMonitor value) {
        this.o = value;
    }

    public final int getBufferSizeHint() {
        return this.v_().b();
    }

    public final void setBufferSizeHint(int value) {
        i i2 = this.v_();
        if (!aE.a(i2, com.aspose.psd.internal.le.i.a)) {
            i2.c(value);
        }
    }

    public boolean getAutoAdjustPalette() {
        return this.n;
    }

    public void setAutoAdjustPalette(boolean value) {
        this.n = value;
    }

    public boolean hasBackgroundColor() {
        return false;
    }

    public long getFileFormat() {
        return 0L;
    }

    public Color getBackgroundColor() {
        return this.t;
    }

    public void setBackgroundColor(boolean value) {
    }

    public void setBackgroundColor(Color value) {
        value.CloneTo(this.t);
    }

    public boolean w_() {
        return this.m;
    }

    public void f(boolean bl2) {
        this.m = bl2;
    }

    public i v_() {
        i i2 = this.p.get();
        return i2 != null ? i2 : com.aspose.psd.internal.le.i.a;
    }

    @Override
    public boolean v() {
        return this.v_().c();
    }

    @Override
    @com.aspose.psd.internal.gK.g
    public final ProgressEventHandler getProgressEventHandler() {
        if (this.q == null) {
            return null;
        }
        return this.q.a();
    }

    @Override
    @com.aspose.psd.internal.gK.g
    public final ProgressEventHandlerInfo getProgressEventHandlerInfo() {
        return this.q;
    }

    public boolean canSave(ImageOptionsBase options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        this.verifyNotDisposed();
        return ImageExportersRegistry.getFirstSupportedDescriptor(this, options) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int newWidth, int newHeight) {
        Object object = this.e;
        synchronized (object) {
            try {
                this.d(true);
                this.resize(newWidth, newHeight, 7);
            }
            finally {
                this.e(true);
            }
        }
    }

    public abstract void resize(int var1, int var2, int var3);

    public abstract void resize(int var1, int var2, ImageResizeSettings var3);

    public ImageOptionsBase getDefaultOptions(Object[] args) {
        return null;
    }

    public ImageOptionsBase getOriginalOptions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int newWidth) {
        Object object = this.e;
        synchronized (object) {
            boolean bl2 = this.doUseRecursion(1);
            try {
                this.d(bl2);
                this.resizeWidthProportionally(newWidth, 7);
            }
            finally {
                this.e(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int newHeight) {
        Object object = this.e;
        synchronized (object) {
            boolean bl2 = this.doUseRecursion(2);
            try {
                this.d(bl2);
                this.resizeHeightProportionally(newHeight, 1);
            }
            finally {
                this.e(bl2);
            }
        }
    }

    public void resizeWidthProportionally(int newWidth, int resizeType) {
        int n2 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), newWidth);
        this.resize(newWidth, n2, resizeType);
    }

    public void resizeHeightProportionally(int newHeight, int resizeType) {
        int n2 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), newHeight);
        this.resize(n2, newHeight, resizeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int newWidth, ImageResizeSettings settings) {
        Object object = this.e;
        synchronized (object) {
            try {
                this.d(true);
                int n2 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), newWidth);
                this.resize(newWidth, n2, settings);
            }
            finally {
                this.e(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int newHeight, ImageResizeSettings settings) {
        Object object = this.e;
        synchronized (object) {
            try {
                this.d(true);
                int n2 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), newHeight);
                this.resize(n2, newHeight, settings);
            }
            finally {
                this.e(true);
            }
        }
    }

    public abstract void rotateFlip(int var1);

    @Override
    public final void save() {
        if (this.j.b() && this.j.c() != null) {
            throw new FrameworkException("The result of this method is unpredictable since the current image has Container defined. Use the parent Container's Save() method instead.");
        }
        super.save();
        if (this.i != null) {
            this.i.setPosition(0L);
            Stream stream = this.getDataStreamContainer().a();
            stream.setPosition(0L);
            com.aspose.psd.internal.lQ.b.a(stream, this.i.a());
        }
    }

    public void save(String filePath, ImageOptionsBase options) {
        this.save(filePath, options, Rectangle.getEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filePath, ImageOptionsBase options, Rectangle boundsRectangle) {
        this.verifyNotDisposed();
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        try {
            FileStream fileStream = com.aspose.psd.internal.bV.k.b(filePath);
            try {
                this.a(fileStream, options, boundsRectangle);
                fileStream.flush();
            }
            finally {
                fileStream.dispose();
            }
        }
        catch (OperationInterruptedException operationInterruptedException) {
            throw operationInterruptedException;
        }
        catch (Error error) {
            throw new ImageLoadException("Image saving failed.", error);
        }
        catch (ImageSaveException imageSaveException) {
            throw imageSaveException;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image saving failed.", runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile file, ImageOptionsBase options) {
        a a2 = new a(file);
        try {
            this.a(a2, options, Rectangle.getEmpty());
        }
        finally {
            a2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile file, ImageOptionsBase optionsBase, Rectangle boundsRectangle) {
        a a2 = new a(file);
        try {
            this.a(a2, optionsBase, boundsRectangle);
        }
        finally {
            a2.dispose();
        }
    }

    public void save(OutputStream stream, ImageOptionsBase optionsBase) {
        if (stream instanceof d) {
            this.a(((d)stream).a(), optionsBase, Rectangle.getEmpty());
        } else {
            com.aspose.psd.internal.gJ.c.a(new com.aspose.psd.w(this, stream, optionsBase));
        }
    }

    public void save(OutputStream stream, ImageOptionsBase optionsBase, Rectangle boundsRectangle) {
        if (stream instanceof d) {
            this.a(((d)stream).a(), optionsBase, boundsRectangle);
        } else {
            com.aspose.psd.internal.gJ.c.a(new x(this, stream, optionsBase, boundsRectangle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Stream stream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("optionsBase");
        }
        if (!(rectangle == null || rectangle.isEmpty() || rectangle.getWidth() > 0 && rectangle.getHeight() > 0)) {
            throw new ArgumentOutOfRangeException("boundsRectangle", "Rectangle should have positive width and height");
        }
        boolean bl2 = false;
        try {
            Object object;
            Object object2 = this.e;
            synchronized (object2) {
                this.isRecursiveCall = bl2 = this.isSameSourceStream_internalized(stream);
                this.MutuallyExclusiveOperationIsNotRunningEvent_internalized.waitOne();
                if (imageOptionsBase != null && imageOptionsBase.getProgressEventHandler() != null) {
                    this.q = ProgressEventHandlerInfo.a(4);
                    this.q.a(imageOptionsBase.getProgressEventHandler());
                } else if (this.q != null) {
                    this.q.setMaxValue(this.q.getMaxValue() + 4);
                    if (imageOptionsBase != null) {
                        imageOptionsBase.setProgressEventHandler(this.q.a());
                    }
                }
                object = this.SyncNonExclusiveOperation_internalized;
                synchronized (object) {
                    if (this.NonExclusiveRunningOperationsCount_internalized.incrementAndGet() > 0) {
                        this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.reset();
                    }
                }
            }
            Image.a(this.q, EventType.Initialization);
            object2 = ImageExportersRegistry.createFirstSupportedExporter(this, imageOptionsBase);
            if (object2 == null) {
                object = this.getCanNotSaveMessage(imageOptionsBase);
                throw new ArgumentException((String)object, "optionsBase");
            }
            object = this.getImage2Export(imageOptionsBase, rectangle);
            ce ce2 = null;
            try {
                Image.a(this.q, EventType.PreProcessing);
                ce2 = cf.a().a(stream);
                Object object3 = ce2.getSyncRoot();
                synchronized (object3) {
                    ce2.setPosition(0L);
                    ((DataStreamSupporter)object).tryCacheImage(ce2);
                    Image.a(this.q, EventType.Processing);
                    object2.export((Image)object, ce2.toOutputStream(), imageOptionsBase, rectangle);
                    Image.a(this.q, EventType.Finalization);
                    this.b(ce2);
                }
                cf.a().a(ce2);
            }
            catch (Throwable throwable) {
                cf.a().a(ce2);
                throw throwable;
            }
        }
        catch (OperationInterruptedException operationInterruptedException) {
            throw operationInterruptedException;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image export failed.", runtimeException);
        }
        finally {
            Object object = this.SyncNonExclusiveOperation_internalized;
            synchronized (object) {
                if (bl2) {
                    this.isRecursiveCall = false;
                }
                if (this.NonExclusiveRunningOperationsCount_internalized.decrementAndGet() <= 0) {
                    this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.set();
                }
            }
        }
    }

    public abstract void setPalette(IColorPalette var1, boolean var2);

    public Object z() {
        return this.l;
    }

    public void a(Object object) {
        this.l = object;
    }

    public void a(Image image) {
        this.j = new cz<Image>(image);
        this.A();
    }

    public void A() {
    }

    public final void a(EventType eventType) {
        if (this.q != null) {
            this.q.b(this.q.getValue() + 1);
            this.q.a(eventType, this.q.getValue());
        }
    }

    public final void e(int n2) {
        if (this.q != null) {
            this.q.setMaxValue(this.q.getMaxValue() + n2);
        }
    }

    public void a(i i2, boolean bl2) {
        if (this.w) {
            i i3 = this.p.getAndSet(aE.a(i2, com.aspose.psd.internal.le.i.a) ? null : i2);
            if (i3 != null && !aE.a(i3, i2)) {
                i3.dispose();
            }
        } else {
            this.p.set(aE.a(i2, com.aspose.psd.internal.le.i.a) ? null : i2);
        }
        this.w = bl2;
    }

    protected boolean doUseRecursion(int operation) {
        return false;
    }

    protected String getCanNotSaveMessage(ImageOptionsBase optionsBase) {
        return "Cannot save to the specified format as it is not supported at the moment";
    }

    public Image a(ImageOptionsBase imageOptionsBase) {
        return this;
    }

    public boolean B() {
        Image image = this.getContainer();
        return this.getAutoAdjustPalette() || image != null && image.B();
    }

    private final boolean g() {
        return this.r != null;
    }

    protected Rectangle getFitRectangle(Rectangle rectangle) {
        return Image.getFittingRectangle(rectangle, this.getWidth(), this.getHeight());
    }

    protected Image getImage2Export(ImageOptionsBase optionsBase, Rectangle boundsRectangle) {
        return this;
    }

    protected Rectangle getFitRectangle(Rectangle rectangle, int[] pixels) {
        return Image.getFittingRectangle(rectangle, pixels, this.getWidth(), this.getHeight());
    }

    protected void onPaletteChanged(IColorPalette oldPalette, IColorPalette newPalette) {
    }

    protected void onPaletteChanging(IColorPalette oldPalette, IColorPalette newPalette) {
    }

    @Override
    protected void releaseManagedResources() {
        this.k = null;
        i i2 = this.p.getAndSet(null);
        if (i2 != null && this.w) {
            i2.dispose();
        }
        if (this.u != null) {
            try {
                ce ce2 = (ce)((Object)com.aspose.psd.internal.gK.d.a(this.u.getStream(), ce.class));
                if (ce2 != null) {
                    ce2.e();
                    if (ce2.b() <= 0) {
                        ce2.dispose();
                        this.u.dispose();
                    }
                } else {
                    this.u.a().dispose();
                    this.u.dispose();
                }
                if (com.aspose.psd.internal.gK.d.b((Object)this.getDataStreamContainer().getStream(), ce.class)) {
                    ce ce3 = (ce)((Object)com.aspose.psd.internal.gK.d.a(this.getDataStreamContainer().getStream(), ce.class));
                    String string = ((FileStream)ce3.a()).getName();
                    this.getDataStreamContainer().a().dispose();
                    this.getDataStreamContainer().dispose();
                    com.aspose.psd.internal.bV.k.d(string);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (this.v != null) {
            this.v.dispose();
        }
        if (this.r != null) {
            com.aspose.psd.internal.bg.w.b().b(this.r);
        }
        super.releaseManagedResources();
    }

    static /* synthetic */ com.aspose.psd.internal.gL.d access$002(com.aspose.psd.internal.gL.d x0) {
        a = x0;
        return a;
    }

    static /* synthetic */ com.aspose.psd.internal.gL.b access$202(com.aspose.psd.internal.gL.b x0) {
        b = x0;
        return b;
    }

    static {
        g = new r();
        h = new t();
        new com.aspose.psd.internal.ar.b().run();
    }

    protected static final class ImageOperation
    extends Enum {
        public static final int Resize = 0;
        public static final int ResizeWidthProportionally = 1;
        public static final int ResizeHeightProportionally = 2;
        public static final int Filter = 3;
        public static final int LoadPixels = 4;
        public static final int SavePixels = 5;
        public static final int Crop = 6;
        public static final int BinarizeFixed = 7;
        public static final int BinarizeOtsu = 8;
        public static final int BinarizeBradley = 9;
        public static final int Grayscale = 10;
        public static final int AdjustBrightness = 11;
        public static final int AdjustContrast = 12;
        public static final int AdjustGamma = 13;
        public static final int Rotate = 14;
        public static final int RotateFlip = 15;

        private ImageOperation() {
        }

        static {
            Enum.register(new a());
        }

        private static final class a
        extends Enum.SimpleEnum {
            a() {
                super(ImageOperation.class, Integer.class);
                this.addConstant("Resize", 0L);
                this.addConstant("ResizeWidthProportionally", 1L);
                this.addConstant("ResizeHeightProportionally", 2L);
                this.addConstant("Filter", 3L);
                this.addConstant("LoadPixels", 4L);
                this.addConstant("SavePixels", 5L);
                this.addConstant("Crop", 6L);
                this.addConstant("BinarizeFixed", 7L);
                this.addConstant("BinarizeOtsu", 8L);
                this.addConstant("BinarizeBradley", 9L);
                this.addConstant("Grayscale", 10L);
                this.addConstant("AdjustBrightness", 11L);
                this.addConstant("AdjustContrast", 12L);
                this.addConstant("AdjustGamma", 13L);
                this.addConstant("Rotate", 14L);
                this.addConstant("RotateFlip", 15L);
            }
        }
    }
}

