/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd;

import com.aspose.psd.Color;
import com.aspose.psd.internal.bG.I;
import com.aspose.psd.internal.bG.aW;
import com.aspose.psd.internal.bG.av;
import com.aspose.psd.internal.bG.y;

public final class ColorTranslator {
    private ColorTranslator() {
    }

    public static Color fromHtml(String htmlColor) {
        Color color = Color.getEmpty();
        if (htmlColor != null && htmlColor.length() != 0) {
            if (htmlColor.charAt(0) == '#' && (htmlColor.length() == 7 || htmlColor.length() == 4)) {
                if (htmlColor.length() == 7) {
                    Color.fromArgb(I.e(aW.b(htmlColor, 1, 2), 16), I.e(aW.b(htmlColor, 3, 2), 16), I.e(aW.b(htmlColor, 5, 2), 16)).CloneTo(color);
                } else {
                    String string = y.t(htmlColor.charAt(1));
                    String string2 = y.t(htmlColor.charAt(2));
                    String string3 = y.t(htmlColor.charAt(3));
                    Color.fromArgb(I.e(aW.a(new String[]{string, string}), 16), I.e(aW.a(new String[]{string2, string2}), 16), I.e(aW.a(new String[]{string3, string3}), 16)).CloneTo(color);
                }
            }
            if (color.isEmpty() && aW.d(htmlColor, "LightGray", (short)5)) {
                Color.getLightGray().CloneTo(color);
            }
        }
        return color.Clone();
    }

    public static Color fromOle(int oleColor) {
        return Color.fromArgb(oleColor & 0xFF, oleColor >> 8 & 0xFF, oleColor >> 16 & 0xFF);
    }

    public static Color fromWin32(int win32Color) {
        return ColorTranslator.fromOle(win32Color);
    }

    public static String toHtml(Color c2) {
        String string = aW.a;
        if (!c2.isEmpty()) {
            if (c2.isNamedColor()) {
                if (Color.op_Equality(c2, Color.getLightGray())) {
                    return "LightGray";
                }
                return c2.getName();
            }
            int n2 = c2.toArgb();
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            return aW.a("#", av.a(n3, "X2", null), av.a(n4, "X2", null), av.a(n5, "X2", null));
        }
        return string;
    }

    public static int toOle(Color c2) {
        return ColorTranslator.toWin32(c2);
    }

    public static int toWin32(Color c2) {
        int n2 = c2.toArgb();
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        return n3 | n4 << 8 | n5 << 16;
    }
}

