/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.ms.System.Security.Cryptography;

import com.aspose.pdf.internal.l77v.l0h;
import com.aspose.pdf.internal.l77v.l0n;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.SymmetricAlgorithm;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.l0y;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.l3if;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.l5k;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.lc;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l13v;
import com.aspose.pdf.internal.ms.System.l1u;
import com.aspose.pdf.internal.ms.System.l4v;
import com.aspose.pdf.internal.ms.System.l5p;
import com.aspose.pdf.internal.ms.System.l7n;
import com.aspose.pdf.internal.ms.System.l8l;
import com.aspose.pdf.internal.ms.System.lh;
import com.aspose.pdf.internal.ms.System.lk;
import com.aspose.pdf.internal.ms.System.lv;
import com.aspose.pdf.internal.ms.System.ly;

abstract class SymmetricTransform
implements l3if {
    protected SymmetricAlgorithm lc;
    protected boolean ly;
    private int lI;
    private byte[] lf;
    private byte[] lj;
    private byte[] lt;
    private byte[] lb;
    private int ld;
    private int lu;
    private boolean le = false;
    private boolean lh;
    private l5k lk;

    public SymmetricTransform(SymmetricAlgorithm symmAlgo, boolean encryption, byte[] rgbIV) {
        this.lc = symmAlgo;
        this.ly = encryption;
        this.lI = this.lc.getBlockSize() >> 3;
        rgbIV = rgbIV == null ? l0h.lf(this.lI) : (byte[])rgbIV.clone();
        if (rgbIV.length < this.lI) {
            String string = l0n.lI("IV is too small ({0} bytes), it should be {1} bytes long.", rgbIV.length, this.lI);
            throw new l0y(string);
        }
        this.lf = new byte[this.lI];
        l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)rgbIV), 0, com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lf), 0, Math.min(this.lI, rgbIV.length));
        this.lj = new byte[this.lI];
        this.ld = this.lc.getFeedbackSize() >> 3;
        if (this.ld != 0) {
            this.lu = this.lI / this.ld;
        }
        this.lt = new byte[this.lI];
        this.lb = new byte[this.lI];
    }

    @Override
    public void dispose() {
        this.lI(true);
        l5p.lI(this);
    }

    protected void lI(boolean bl) {
        if (!this.le) {
            if (bl) {
                l13v.lf(this.lf, 0, this.lI);
                this.lf = null;
                l13v.lf(this.lj, 0, this.lI);
                this.lj = null;
            }
            this.le = true;
        }
    }

    @Override
    public boolean canTransformMultipleBlocks() {
        return true;
    }

    @Override
    public boolean canReuseTransform() {
        return false;
    }

    @Override
    public int getInputBlockSize() {
        return this.lI;
    }

    @Override
    public int getOutputBlockSize() {
        return this.lI;
    }

    protected void lj(byte[] byArray, byte[] byArray2) {
        switch (this.lc.getMode()) {
            case 2: {
                this.lf(byArray, byArray2);
                break;
            }
            case 1: {
                this.lt(byArray, byArray2);
                break;
            }
            case 4: {
                this.lb(byArray, byArray2);
                break;
            }
            case 3: {
                this.ld(byArray, byArray2);
                break;
            }
            case 5: {
                this.lu(byArray, byArray2);
                break;
            }
            default: {
                throw new l7n("Unkown CipherMode" + l4v.getName(lc.class, this.lc.getMode()));
            }
        }
    }

    protected abstract void lf(byte[] var1, byte[] var2);

    protected void lt(byte[] byArray, byte[] byArray2) {
        if (this.ly) {
            for (int i = 0; i < this.lI; ++i) {
                int n = i;
                this.lf[n] = (byte)(this.lf[n] ^ byArray[i]);
            }
            this.lf(this.lf, byArray2);
            l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray2), 0, com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lf), 0, this.lI);
        } else {
            l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray), 0, com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lj), 0, this.lI);
            this.lf(byArray, byArray2);
            for (int i = 0; i < this.lI; ++i) {
                int n = i;
                byArray2[n] = (byte)(byArray2[n] ^ this.lf[i]);
            }
            l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lj), 0, com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lf), 0, this.lI);
        }
    }

    protected void lb(byte[] byArray, byte[] byArray2) {
        if (this.ly) {
            for (int i = 0; i < this.lu; ++i) {
                this.lf(this.lf, this.lj);
                for (int j = 0; j < this.ld; ++j) {
                    byArray2[j + i] = (byte)(this.lj[j] & 0xFF ^ byArray[j + i] & 0xFF);
                }
                l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lf), this.ld, com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lf), 0, this.lI - this.ld);
                l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray2), i, com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lf), this.lI - this.ld, this.ld);
            }
        } else {
            for (int i = 0; i < this.lu; ++i) {
                this.ly = true;
                this.lf(this.lf, this.lj);
                this.ly = false;
                l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lf), this.ld, com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lf), 0, this.lI - this.ld);
                l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray), i, com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lf), this.lI - this.ld, this.ld);
                for (int j = 0; j < this.ld; ++j) {
                    byArray2[j + i] = (byte)(this.lj[j] & 0xFF ^ byArray[j + i] & 0xFF);
                }
            }
        }
    }

    protected void ld(byte[] byArray, byte[] byArray2) {
        throw new l0y("OFB isn't supported by the framework");
    }

    protected void lu(byte[] byArray, byte[] byArray2) {
        throw new l0y("CTS isn't supported by the framework");
    }

    private void lI(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new lk("inputBuffer");
        }
        if (n < 0) {
            throw new lv("inputOffset", "< 0");
        }
        if (n2 < 0) {
            throw new lv("inputCount", "< 0");
        }
        if (n > byArray.length - n2) {
            throw new lh("inputBuffer\r\nParameter name: " + l0n.lI("Overflow"));
        }
    }

    @Override
    public int transformBlock(byte[] inputBuffer, int inputOffset, int inputCount, byte[] outputBuffer, int outputOffset) {
        if (this.le) {
            throw new l8l("Object is disposed");
        }
        this.lI(inputBuffer, inputOffset, inputCount);
        if (outputBuffer == null) {
            throw new lk("outputBuffer");
        }
        if (outputOffset < 0) {
            throw new lv("outputOffset", "< 0");
        }
        int n = outputBuffer.length - inputCount - outputOffset;
        if (!(this.ly || 0 <= n || this.lc.getPadding() != 1 && this.lc.getPadding() != 3)) {
            throw new l0y("outputBuffer", l0n.lI("Overflow"));
        }
        if (this.lI()) {
            if (0 > n + this.lI) {
                throw new l0y("outputBuffer", l0n.lI("Overflow"));
            }
        } else if (0 > n) {
            if (inputBuffer.length - inputOffset - outputBuffer.length == this.lI) {
                inputCount = outputBuffer.length - outputOffset;
            } else {
                throw new l0y("outputBuffer", l0n.lI("Overflow"));
            }
        }
        return this.lI(inputBuffer, inputOffset, inputCount, outputBuffer, outputOffset);
    }

    private boolean lI() {
        return !this.ly && this.lc.getPadding() != 1 && this.lc.getPadding() != 3;
    }

    private int lI(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5 = n;
        if (n2 != this.lI) {
            if (n2 % this.lI != 0) {
                throw new l0y("Invalid input block size.");
            }
            n4 = n2 / this.lI;
        } else {
            n4 = 1;
        }
        if (this.lI()) {
            --n4;
        }
        int n6 = 0;
        if (this.lh) {
            this.lj(this.lt, this.lb);
            l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lb), 0, com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray2), n3, this.lI);
            n3 += this.lI;
            n6 += this.lI;
            this.lh = false;
        }
        for (int i = 0; i < n4; ++i) {
            l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray), n5, com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lt), 0, this.lI);
            this.lj(this.lt, this.lb);
            l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lb), 0, com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray2), n3, this.lI);
            n5 += this.lI;
            n3 += this.lI;
            n6 += this.lI;
        }
        if (this.lI()) {
            l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray), n5, com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lt), 0, this.lI);
            this.lh = true;
        }
        return n6;
    }

    private void lf(byte[] byArray, int n, int n2) {
        if (this.lk == null) {
            this.lk = l5k.lI();
        }
        byte[] byArray2 = new byte[n2];
        this.lk.lI(byArray2);
        l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray2), 0, com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray), n, n2);
    }

    private void lI(int n, int n2, int n3) {
        String string = l10l.lI(l0n.lI("Bad {0} padding."), new Object[]{n});
        if (n2 >= 0) {
            string = l10l.lI(string, l10l.lI(l0n.lI(" Invalid length {0}."), new Object[]{n2}));
        }
        if (n3 >= 0) {
            string = l10l.lI(string, l10l.lI(l0n.lI(" Error found at position {0}."), new Object[]{n3}));
        }
        throw new l0y(string);
    }

    private byte[] lj(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        int n3 = n2 / this.lI * this.lI;
        int n4 = n2 - n3;
        int n5 = n3;
        switch (this.lc.getPadding()) {
            case 2: 
            case 4: 
            case 5: {
                n5 += this.lI;
                break;
            }
            default: {
                if (n2 == 0) {
                    return new byte[0];
                }
                if (n4 == 0) break;
                if (this.lc.getPadding() == 1) {
                    throw new l0y("invalid block length");
                }
                byArray2 = new byte[n3 + this.lI];
                l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray), n, com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray2), 0, n2);
                byArray = byArray2;
                n = 0;
                n5 = n2 = byArray2.length;
            }
        }
        byArray2 = new byte[n5];
        int n6 = 0;
        while (n5 > this.lI) {
            this.lI(byArray, n, this.lI, byArray2, n6);
            n += this.lI;
            n6 += this.lI;
            n5 -= this.lI;
        }
        byte by = (byte)(this.lI - n4);
        switch (this.lc.getPadding()) {
            case 4: {
                byArray2[byArray2.length - 1] = by;
                l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray), n, com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray2), n3, n4);
                this.lI(byArray2, n3, this.lI, byArray2, n3);
                break;
            }
            case 5: {
                this.lf(byArray2, byArray2.length - (by & 0xFF), (by & 0xFF) - 1);
                byArray2[byArray2.length - 1] = by;
                l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray), n, com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray2), n3, n4);
                this.lI(byArray2, n3, this.lI, byArray2, n3);
                break;
            }
            case 2: {
                int n7 = byArray2.length;
                while (--n7 >= byArray2.length - (by & 0xFF)) {
                    byArray2[n7] = by;
                }
                l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray), n, com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray2), n3, n4);
                this.lI(byArray2, n3, this.lI, byArray2, n3);
                break;
            }
            default: {
                this.lI(byArray, n, this.lI, byArray2, n6);
            }
        }
        return byArray2;
    }

    private byte[] lt(byte[] byArray, int n, int n2) {
        int n3;
        if (n2 % this.lI > 0) {
            throw new l0y("Invalid input block size.");
        }
        int n4 = n2;
        if (this.lh) {
            n4 += this.lI;
        }
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        while (n2 > 0) {
            n3 = this.lI(byArray, n, this.lI, byArray2, n5);
            n += this.lI;
            n5 += n3;
            n2 -= this.lI;
        }
        if (this.lh) {
            this.lj(this.lt, this.lb);
            l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)this.lb), 0, com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray2), n5, this.lI);
            n5 += this.lI;
            this.lh = false;
        }
        n3 = n4 > 0 ? byArray2[n4 - 1] & 0xFF : 0;
        switch (this.lc.getPadding()) {
            case 4: {
                int n6;
                if (n3 == 0 || (n3 & 0xFF) > this.lI) {
                    this.lI(this.lc.getPadding(), n3 & 0xFF, -1);
                }
                for (n6 = (n3 & 0xFF) - 1; n6 > 0; --n6) {
                    if (byArray2[n4 - 1 - n6] == 0) continue;
                    this.lI(this.lc.getPadding(), -1, n6);
                }
                n4 -= n3 & 0xFF;
                break;
            }
            case 5: {
                if (n3 == 0 || (n3 & 0xFF) > this.lI) {
                    this.lI(this.lc.getPadding(), n3 & 0xFF, -1);
                }
                n4 -= n3 & 0xFF;
                break;
            }
            case 2: {
                int n6;
                if (n3 == 0 || (n3 & 0xFF) > this.lI) {
                    this.lI(this.lc.getPadding(), n3 & 0xFF, -1);
                }
                for (n6 = (n3 & 0xFF) - 1; n6 > 0; --n6) {
                    if (byArray2[n4 - 1 - n6] == n3) continue;
                    this.lI(this.lc.getPadding(), -1, n6);
                }
                n4 -= n3 & 0xFF;
                break;
            }
        }
        if (n4 > 0) {
            byte[] byArray3 = new byte[n4];
            l1u.lI(com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray2), 0, com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray3), 0, n4);
            l13v.lf(byArray2, 0, byArray2.length);
            return byArray3;
        }
        return new byte[0];
    }

    @Override
    public byte[] transformFinalBlock(byte[] inputBuffer, int inputOffset, int inputCount) {
        if (this.le) {
            throw new l8l("Object is disposed");
        }
        this.lI(inputBuffer, inputOffset, inputCount);
        if (this.ly) {
            return this.lj(inputBuffer, inputOffset, inputCount);
        }
        return this.lt(inputBuffer, inputOffset, inputCount);
    }
}

