/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.ms.System.Security.Cryptography;

import com.aspose.pdf.internal.ms.System.Security.Cryptography.SHA512;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.SHAConstants;
import com.aspose.pdf.internal.ms.System.l11p;

public class SHA512Managed
extends SHA512 {
    private byte[] lI;
    private int lb;
    private l11p ld = l11p.lf;
    private l11p lu = new l11p("0");
    private l11p le = new l11p("0");
    private l11p lh;
    private l11p lk;
    private l11p lv;
    private l11p lc;
    private l11p ly;
    private l11p l0if;
    private l11p l0l;
    private l11p l0t;
    private l11p[] l0v;
    private int l0p;

    public SHA512Managed() {
        this.lI = new byte[8];
        this.l0v = new l11p[80];
        for (int i = 0; i < 80; ++i) {
            this.l0v[i] = new l11p("0");
        }
        this.lf(false);
    }

    private void lf(boolean bl) {
        this.lh = new l11p("0x6a09e667f3bcc908L");
        this.lk = new l11p("0xbb67ae8584caa73bL");
        this.lv = new l11p("0x3c6ef372fe94f82bL");
        this.lc = new l11p("0xa54ff53a5f1d36f1L");
        this.ly = new l11p("0x510e527fade682d1L");
        this.l0if = new l11p("0x9b05688c2b3e6c1fL");
        this.l0l = new l11p("0x1f83d9abfb41bd6bL");
        this.l0t = new l11p("0x5be0cd19137e2179L");
        if (bl) {
            int n;
            this.lu = new l11p("0");
            this.le = new l11p("0");
            this.lb = 0;
            for (n = 0; n < this.lI.length; ++n) {
                this.lI[n] = 0;
            }
            this.l0p = 0;
            for (n = 0; n != this.l0v.length; ++n) {
                this.l0v[n] = new l11p("0");
            }
        }
    }

    @Override
    public void initialize() {
        this.lf(true);
    }

    @Override
    protected void lI(byte[] byArray, int n, int n2) {
        while (this.lb != 0 && n2 > 0) {
            this.lI(byArray[n]);
            ++n;
            --n2;
        }
        while (n2 > this.lI.length) {
            this.lI(byArray, n);
            n += this.lI.length;
            n2 -= this.lI.length;
            this.lu = l11p.lt(this.lu, new l11p(String.valueOf(this.lI.length)));
        }
        while (n2 > 0) {
            this.lI(byArray[n]);
            ++n;
            --n2;
        }
    }

    @Override
    protected byte[] ag_() {
        this.lf();
        l11p l11p2 = l11p.lf(this.lu, 3);
        l11p l11p3 = this.le;
        this.lI((byte)-128);
        while (this.lb != 0) {
            this.lI((byte)0);
        }
        this.lI(l11p2, l11p3);
        this.lj();
        byte[] byArray = new byte[64];
        this.lI(this.lh, byArray, 0);
        this.lI(this.lk, byArray, 8);
        this.lI(this.lv, byArray, 16);
        this.lI(this.lc, byArray, 24);
        this.lI(this.ly, byArray, 32);
        this.lI(this.l0if, byArray, 40);
        this.lI(this.l0l, byArray, 48);
        this.lI(this.l0t, byArray, 56);
        this.initialize();
        return byArray;
    }

    private void lI(byte by) {
        this.lI[this.lb++] = by;
        if (this.lb == this.lI.length) {
            this.lI(this.lI, 0);
            this.lb = 0;
        }
        this.lu = l11p.lt(this.lu);
    }

    private void lI(byte[] byArray, int n) {
        this.l0v[this.l0p++] = l11p.lf(l11p.lf(l11p.lf(l11p.lI(l11p.lf(new l11p(String.valueOf(byArray[n] & 0xFF)), 56), this.ld), l11p.lI(l11p.lf(new l11p(String.valueOf(byArray[n + 1] & 0xFF)), 48), this.ld)), l11p.lf(l11p.lI(l11p.lf(new l11p(String.valueOf(byArray[n + 2] & 0xFF)), 40), this.ld), l11p.lI(l11p.lf(new l11p(String.valueOf(byArray[n + 3] & 0xFF)), 32), this.ld))), l11p.lf(l11p.lf(l11p.lI(l11p.lf(new l11p(String.valueOf(byArray[n + 4] & 0xFF)), 24), this.ld), l11p.lI(l11p.lf(new l11p(String.valueOf(byArray[n + 5] & 0xFF)), 16), this.ld)), l11p.lf(l11p.lI(l11p.lf(new l11p(String.valueOf(byArray[n + 6] & 0xFF)), 8), this.ld), l11p.lI(new l11p(String.valueOf(byArray[n + 7] & 0xFF)), this.ld))));
        if (this.l0p == 16) {
            this.lj();
        }
    }

    private void lI(l11p l11p2, byte[] byArray, int n) {
        byArray[n] = l11p.lI(l11p2, 56).byteValue();
        byArray[n + 1] = l11p.lI(l11p2, 48).byteValue();
        byArray[n + 2] = l11p.lI(l11p2, 40).byteValue();
        byArray[n + 3] = l11p.lI(l11p2, 32).byteValue();
        byArray[n + 4] = l11p.lI(l11p2, 24).byteValue();
        byArray[n + 5] = l11p.lI(l11p2, 16).byteValue();
        byArray[n + 6] = l11p.lI(l11p2, 8).byteValue();
        byArray[n + 7] = l11p2.byteValue();
    }

    private void lf() {
        if (l11p.lv(this.lu, new l11p("0x1fffffffffffffffL"))) {
            this.le = l11p.lt(this.le, l11p.lI(this.lu, 61));
            this.lu = l11p.lI(this.lu, new l11p("0x1fffffffffffffffL"));
        }
    }

    private void lI(l11p l11p2, l11p l11p3) {
        if (this.l0p > 14) {
            this.lj();
        }
        this.l0v[14] = l11p3;
        this.l0v[15] = l11p2;
    }

    private void lj() {
        int n;
        this.lf();
        for (int i = 16; i <= 79; ++i) {
            this.l0v[i] = l11p.lI(l11p.lt(l11p.lt(this.lt(this.l0v[i - 2]), this.l0v[i - 7]), l11p.lt(this.lj(this.l0v[i - 15]), this.l0v[i - 16])), this.ld);
        }
        l11p l11p2 = this.lh;
        l11p l11p3 = this.lk;
        l11p l11p4 = this.lv;
        l11p l11p5 = this.lc;
        l11p l11p6 = this.ly;
        l11p l11p7 = this.l0if;
        l11p l11p8 = this.l0l;
        l11p l11p9 = this.l0t;
        for (n = 0; n <= 79; ++n) {
            l11p l11p10 = l11p.lI(l11p.lt(l11p.lt(l11p.lt(l11p9, this.lf(l11p6)), l11p.lt(this.lI(l11p6, l11p7, l11p8), SHAConstants.d[n])), this.l0v[n]), this.ld);
            l11p l11p11 = l11p.lI(l11p.lt(this.lI(l11p2), this.lf(l11p2, l11p3, l11p4)), this.ld);
            l11p9 = l11p8;
            l11p8 = l11p7;
            l11p7 = l11p6;
            l11p6 = l11p.lI(l11p.lt(l11p5, l11p10), this.ld);
            l11p5 = l11p4;
            l11p4 = l11p3;
            l11p3 = l11p2;
            l11p2 = l11p.lI(l11p.lt(l11p10, l11p11), this.ld);
        }
        this.lh = l11p.lI(l11p.lt(this.lh, l11p2), this.ld);
        this.lk = l11p.lI(l11p.lt(this.lk, l11p3), this.ld);
        this.lv = l11p.lI(l11p.lt(this.lv, l11p4), this.ld);
        this.lc = l11p.lI(l11p.lt(this.lc, l11p5), this.ld);
        this.ly = l11p.lI(l11p.lt(this.ly, l11p6), this.ld);
        this.l0if = l11p.lI(l11p.lt(this.l0if, l11p7), this.ld);
        this.l0l = l11p.lI(l11p.lt(this.l0l, l11p8), this.ld);
        this.l0t = l11p.lI(l11p.lt(this.l0t, l11p9), this.ld);
        this.l0p = 0;
        for (n = 0; n != this.l0v.length; ++n) {
            this.l0v[n] = new l11p("0");
        }
    }

    private l11p lI(l11p l11p2, int n) {
        return l11p.lI(l11p.lf(l11p.lI(l11p2, n), l11p.lf(l11p2, 64 - n)), this.ld);
    }

    private l11p lI(l11p l11p2, l11p l11p3, l11p l11p4) {
        return l11p.lj(l11p.lI(l11p2, l11p3), l11p.lI(l11p.lj(l11p2, this.ld), l11p4));
    }

    private l11p lf(l11p l11p2, l11p l11p3, l11p l11p4) {
        return l11p.lj(l11p.lj(l11p.lI(l11p2, l11p3), l11p.lI(l11p2, l11p4)), l11p.lI(l11p3, l11p4));
    }

    private l11p lI(l11p l11p2) {
        return l11p.lj(l11p.lj(this.lI(l11p2, 28), this.lI(l11p2, 34)), this.lI(l11p2, 39));
    }

    private l11p lf(l11p l11p2) {
        return l11p.lj(l11p.lj(this.lI(l11p2, 14), this.lI(l11p2, 18)), this.lI(l11p2, 41));
    }

    private l11p lj(l11p l11p2) {
        return l11p.lj(l11p.lj(this.lI(l11p2, 1), this.lI(l11p2, 8)), l11p.lI(l11p2, 7));
    }

    private l11p lt(l11p l11p2) {
        return l11p.lj(l11p.lj(this.lI(l11p2, 19), this.lI(l11p2, 61)), l11p.lI(l11p2, 6));
    }
}

