/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l88y;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class lI
implements BufferedImageOp,
RasterOp {
    public static final int lI = 1;
    public static final int lf = 2;
    public static final int lj = 3;
    private int lt;
    private AffineTransform lb;
    private RenderingHints ld;

    public lI(AffineTransform affineTransform, RenderingHints renderingHints) {
        this(affineTransform, 1);
        this.ld = renderingHints;
        if (renderingHints != null) {
            Object object = renderingHints.get(RenderingHints.KEY_INTERPOLATION);
            if (object != null) {
                if (object == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                    this.lt = 2;
                } else if (object == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                    this.lt = 3;
                }
            } else {
                object = renderingHints.get(RenderingHints.KEY_RENDERING);
                if (object == RenderingHints.VALUE_RENDER_QUALITY) {
                    this.lt = 2;
                }
            }
        }
    }

    public lI(AffineTransform affineTransform, int n) {
        if (Math.abs(affineTransform.getDeterminant()) <= Double.MIN_VALUE) {
            throw new ImagingOpException("Unable to invert transform" + affineTransform);
        }
        this.lb = (AffineTransform)affineTransform.clone();
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Unknown interpolation type:" + n);
        }
        this.lt = n;
    }

    public final int lI() {
        return this.lt;
    }

    @Override
    public final RenderingHints getRenderingHints() {
        if (this.ld == null) {
            Object object = null;
            switch (this.lt) {
                case 1: {
                    object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    break;
                }
                case 2: {
                    object = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                    break;
                }
                case 3: {
                    object = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                    break;
                }
                default: {
                    object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                }
            }
            this.ld = new RenderingHints(RenderingHints.KEY_INTERPOLATION, object);
        }
        return this.ld;
    }

    public final AffineTransform lf() {
        return (AffineTransform)this.lb.clone();
    }

    @Override
    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return this.lb.transform(srcPt, dstPt);
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    @Override
    public final Rectangle2D getBounds2D(Raster src) {
        int n = src.getWidth();
        int n2 = src.getHeight();
        float[] fArray = new float[]{0.0f, 0.0f, n, 0.0f, n, n2, 0.0f, n2};
        this.lb.transform(fArray, 0, fArray, 0, 4);
        Rectangle2D.Float float_ = new Rectangle2D.Float(fArray[0], fArray[1], 0.0f, 0.0f);
        float_.add(fArray[2], fArray[3]);
        float_.add(fArray[4], fArray[5]);
        float_.add(fArray[6], fArray[7]);
        return float_;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        Rectangle2D rectangle2D = this.getBounds2D(src);
        double d = rectangle2D.getX() + rectangle2D.getWidth();
        double d2 = rectangle2D.getY() + rectangle2D.getHeight();
        if (d <= 0.0 || d2 <= 0.0) {
            throw new RasterFormatException(String.format("Transformed width (%d) and height (%d) should be greater than 0", d, d2));
        }
        if (destCM != null) {
            return new BufferedImage(destCM, destCM.createCompatibleWritableRaster((int)d, (int)d2), destCM.isAlphaPremultiplied(), null);
        }
        ColorModel colorModel = src.getColorModel();
        if (this.lt != 1 && colorModel instanceof IndexColorModel) {
            return new BufferedImage((int)d, (int)d2, 2);
        }
        return new BufferedImage(colorModel, src.getRaster().createCompatibleWritableRaster((int)d, (int)d2), colorModel.isAlphaPremultiplied(), null);
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        Rectangle2D rectangle2D = this.getBounds2D(src);
        return src.createCompatibleWritableRaster((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    @Override
    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src == dst) {
            throw new IllegalArgumentException("Source can't be same as the destination");
        }
        ColorModel colorModel = src.getColorModel();
        BufferedImage bufferedImage = null;
        if (colorModel instanceof IndexColorModel && (this.lt != 1 || colorModel.getPixelSize() % 8 != 0)) {
            src = ((IndexColorModel)colorModel).convertToIntDiscrete(src.getRaster(), true);
            colorModel = src.getColorModel();
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, colorModel);
        } else if (!colorModel.equals(dst.getColorModel()) && (src.getType() != 1 && src.getType() != 2 || dst.getType() != 1 && dst.getType() != 2)) {
            bufferedImage = dst;
            dst = this.createCompatibleDestImage(src, colorModel);
        }
        if (this.lI(src.getRaster(), dst.getRaster()) != 0) {
            throw new ImagingOpException("Unable to transform source");
        }
        if (bufferedImage != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage((Image)dst, 0, 0, null);
        } else {
            bufferedImage = dst;
        }
        return bufferedImage;
    }

    @Override
    public final WritableRaster filter(Raster src, WritableRaster dst) {
        if (src == dst) {
            throw new IllegalArgumentException("Source can't be same as the destination");
        }
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        } else if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("Different number of bands in source and destination");
        }
        if (this.lI(src, dst) != 0) {
            throw new ImagingOpException("Unable to transform source");
        }
        return dst;
    }

    private int lI(Raster raster, WritableRaster writableRaster) {
        Rectangle rectangle = raster.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        Rectangle rectangle3 = new Rectangle(0, 0, rectangle2.width, rectangle2.height);
        Rectangle rectangle4 = this.getBounds2D(raster).getBounds().intersection(rectangle3);
        AffineTransform affineTransform = null;
        try {
            affineTransform = this.lb.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return -1;
        }
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        int n5 = rectangle4.x + rectangle2.x;
        int n6 = rectangle4.y + rectangle2.y;
        int n7 = n5 + rectangle4.width;
        int n8 = n6 + rectangle4.height;
        int n9 = (int)(dArray[0] * 256.0);
        int n10 = (int)(dArray[1] * 256.0);
        int n11 = (int)(dArray[2] * 256.0);
        int n12 = (int)(dArray[3] * 256.0);
        int n13 = (int)(dArray[4] * 256.0) + n9 * rectangle4.x + n11 * rectangle4.y + rectangle.x * 256;
        int n14 = (int)(dArray[5] * 256.0) + n10 * rectangle4.x + n12 * rectangle4.y + rectangle.y * 256;
        n11 -= n9 * rectangle4.width;
        n12 -= n10 * rectangle4.width;
        if (raster.getTransferType() == writableRaster.getTransferType()) {
            for (int i = n6; i < n8; ++i) {
                for (int j = n5; j < n7; ++j) {
                    int n15 = n13 >> 8;
                    int n16 = n14 >> 8;
                    if (n15 >= n && n16 >= n2 && n15 < n3 && n16 < n4) {
                        Object object = raster.getDataElements(n15, n16, null);
                        writableRaster.setDataElements(j, i, object);
                    }
                    n13 += n9;
                    n14 += n10;
                }
                n13 += n11;
                n14 += n12;
            }
        } else {
            float[] fArray = null;
            for (int i = n6; i < n8; ++i) {
                for (int j = n5; j < n7; ++j) {
                    int n17 = n13 >> 8;
                    int n18 = n14 >> 8;
                    if (n17 >= n && n18 >= n2 && n17 < n3 && n18 < n4) {
                        fArray = raster.getPixel(n17, n18, fArray);
                        writableRaster.setPixel(j, i, fArray);
                    }
                    n13 += n9;
                    n14 += n10;
                }
                n13 += n11;
                n14 += n12;
            }
        }
        return 0;
    }
}

