/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l85k;

import com.aspose.pdf.internal.l85h.l0p;
import com.aspose.pdf.internal.l85h.l0t;
import com.aspose.pdf.internal.l85h.l0v;
import com.aspose.pdf.internal.l85k.l0f;
import com.aspose.pdf.internal.l85k.l1j;
import com.aspose.pdf.internal.l85k.l1v;
import com.aspose.pdf.internal.l85k.l4t;
import com.aspose.pdf.internal.l85k.lj;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class l4l
extends CertPathBuilderSpi {
    private final l0f lI;
    private lj lf;

    l4l(l0f l0f2) {
        this.lI = l0f2;
    }

    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        l0p l0p2 = null;
        if (certPathParameters instanceof l0p) {
            l0p2 = (l0p)certPathParameters;
        } else if (certPathParameters instanceof PKIXBuilderParameters) {
            l0p2 = new l0p.lI((PKIXBuilderParameters)certPathParameters).lI();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + l0p.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        l0v l0v2 = l0p2.lI().le();
        try {
            collection = l1v.lI(l0v2, l0p2.lI().lI());
            collection.addAll(l1v.lI(l0v2, l0p2.lI().l0t()));
        }
        catch (lj lj2) {
            throw new CertPathBuilderException("Error finding target certificate.", lj2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.lI(x509Certificate, l0p2, arrayList);
        }
        if (certPathBuilderResult == null && this.lf != null) {
            throw new CertPathBuilderException(this.lf.getMessage(), this.lf.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    protected CertPathBuilderResult lI(X509Certificate x509Certificate, l0p l0p2, List list) throws CertPathBuilderException {
        l4t l4t2;
        l1j l1j2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (l0p2.lf().contains(x509Certificate)) {
            return null;
        }
        if (l0p2.lj() != -1 && list.size() - 1 > l0p2.lj()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            l1j2 = new l1j(this.lI);
            l4t2 = new l4t(this.lI);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (l1v.lI(x509Certificate, l0p2.lI().lh(), l0p2.lI().lv()) != null) {
                CertPath certPath = null;
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
                try {
                    certPath = l1j2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new lj("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)l4t2.engineValidate(certPath, l0p2);
                }
                catch (Exception exception) {
                    throw new lj("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<l0t> arrayList = new ArrayList<l0t>();
            arrayList.addAll(l0p2.lI().lI());
            try {
                arrayList.addAll(l1v.lI(x509Certificate.getExtensionValue(com.aspose.pdf.internal.l81k.l0f.ld.lf()), l0p2.lI().lf()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new lj("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(l1v.lI(x509Certificate, l0p2.lI().l0t(), arrayList));
            }
            catch (lj lj2) {
                throw new lj("Cannot find issuer certificate for certificate in certification path.", lj2);
            }
            if (hashSet.isEmpty()) {
                throw new lj("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.lI(x509Certificate2, l0p2, list);
            }
        }
        catch (lj lj3) {
            this.lf = lj3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

