/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.rendering;

import com.aspose.pdf.internal.html.Configuration;
import com.aspose.pdf.internal.html.HTMLDocument;
import com.aspose.pdf.internal.html.HTMLTemplateElement;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.lf;
import com.aspose.pdf.internal.html.dom.svg.SVGDocument;
import com.aspose.pdf.internal.html.lj;
import com.aspose.pdf.internal.html.net.MessageHandler;
import com.aspose.pdf.internal.html.rendering.IDevice;
import com.aspose.pdf.internal.html.rendering.Renderer;
import com.aspose.pdf.internal.html.rendering.le;
import com.aspose.pdf.internal.html.services.INetworkService;
import com.aspose.pdf.internal.l35f.lb;
import com.aspose.pdf.internal.l37if.lf;
import com.aspose.pdf.internal.l38f.lI;
import com.aspose.pdf.internal.l38f.ld;
import com.aspose.pdf.internal.l38f.lt;
import com.aspose.pdf.internal.l90y.lh;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lk;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.l10j;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;

public class EpubRenderer
extends Renderer<Stream> {
    private static final lh gStringSwitchMap = new lh("application/xhtml+xml", "image/svg+xml");

    @Override
    public void render(IDevice device, l10j timeout, Stream[] documents) {
        this.render(device, new Configuration(), timeout.l0if(), documents);
    }

    @Override
    public void render(IDevice device, l10j timeout, Stream document) {
        Stream[] streamArray = new Stream[]{document};
        this.render(device, new Configuration(), timeout.l0if(), streamArray);
    }

    public void render(IDevice device, Stream document, Configuration configuration) {
        this.render(device, document, configuration, l10j.lj.l0if());
    }

    public void render(IDevice device, Stream document, Configuration configuration, l10j timeout) {
        Stream[] streamArray = new Stream[]{document};
        this.render(device, configuration, timeout.l0if(), streamArray);
    }

    public void render(IDevice device, Stream[] documents, Configuration configuration) {
        this.render(device, documents, configuration, l10j.lj.l0if());
    }

    public void render(IDevice device, Stream[] documents, Configuration configuration, l10j timeout) {
        Stream[] streamArray = new Stream[documents.length];
        System.arraycopy(documents, 0, streamArray, 0, documents.length);
        this.render(device, configuration, timeout.l0if(), streamArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void render(IDevice device, Configuration configuration, l10j timeout, Stream[] documents) {
        l5f l5f3;
        l5f l5f2;
        if (documents.length == 0) {
            return;
        }
        this.validatePageSetup(device.getOptions().getPageSetup());
        l0t<com.aspose.pdf.internal.l38f.lf> l0t2 = new l0t<com.aspose.pdf.internal.l38f.lf>();
        try {
            for (int i = 0; i < documents.length; ++i) {
                HTMLDocument hTMLDocument;
                l5f2 = documents[i];
                com.aspose.pdf.internal.l35f.lt lt2 = new com.aspose.pdf.internal.l35f.lt();
                le le2 = new le(lt2);
                configuration.getService(INetworkService.class).getMessageHandlers().addItem(le2);
                lt2.lI((Stream)l5f2);
                this.addDocumentSources(configuration, lt2, l0t2, le2, timeout.l0if());
                lb.lI lI2 = this.getNavElement(lt2);
                if (lI2 != null && (hTMLDocument = new HTMLDocument(lI2.lf(), configuration)).getDocumentElement() != null) {
                    Document document = l0t2.get_Item(l0t2.size() - 1).lI();
                    Element element = document.querySelector("head");
                    if (element == null) {
                        element = document.createElementNS(lf.lu.lI, "head");
                        document.getDocumentElement().appendChild(element);
                    }
                    HTMLTemplateElement hTMLTemplateElement = (HTMLTemplateElement)document.createElementNS(lf.lu.lI, "template");
                    hTMLTemplateElement.getContent().appendChild(hTMLDocument.getDocumentElement());
                    element.appendChild(hTMLTemplateElement);
                }
                configuration.getService(INetworkService.class).getMessageHandlers().removeItem(le2);
            }
            l5f3 = configuration.getService(com.aspose.pdf.internal.html.services.lf.class);
            l5f3.lI(this, l0t2.toArray(new com.aspose.pdf.internal.l38f.lf[0]), device, timeout.l0if());
            device.flush();
            l5f3 = l0t2.iterator();
        }
        catch (Throwable throwable) {
            device.flush();
            lk lk2 = l0t2.iterator();
            try {
                while (lk2.hasNext()) {
                    com.aspose.pdf.internal.l38f.lf lf2 = (com.aspose.pdf.internal.l38f.lf)lk2.next();
                    lf2.dispose();
                }
                throw throwable;
            }
            finally {
                if (com.aspose.pdf.internal.l90y.lb.lf((Object)lk2, l5f.class)) {
                    ((l5f)lk2).dispose();
                }
            }
        }
        try {
            while (l5f3.hasNext()) {
                l5f2 = (com.aspose.pdf.internal.l38f.lf)l5f3.next();
                ((com.aspose.pdf.internal.l38f.lf)l5f2).dispose();
            }
            return;
        }
        finally {
            if (com.aspose.pdf.internal.l90y.lb.lf((Object)l5f3, l5f.class)) {
                l5f3.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private lb.lI getNavElement(com.aspose.pdf.internal.l35f.lt ocfPackage) {
        lk lk2 = ocfPackage.lf().iterator();
        try {
            while (lk2.hasNext()) {
                lb lb2 = (lb)lk2.next();
                lb.lI lI2 = lb2.ld();
                if (lI2 == null) continue;
                lb.lI lI3 = lI2;
                return lI3;
            }
        }
        finally {
            if (com.aspose.pdf.internal.l90y.lb.lf((Object)lk2, l5f.class)) {
                ((l5f)lk2).dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocumentSources(Configuration configuration, com.aspose.pdf.internal.l35f.lt ocfPackage, l0t<com.aspose.pdf.internal.l38f.lf> documentSources, MessageHandler messageHandler, l10j timeout) {
        l0t<com.aspose.pdf.internal.l38f.lf> l0t2 = new l0t<com.aspose.pdf.internal.l38f.lf>();
        lk lk2 = ocfPackage.lf().iterator();
        try {
            while (lk2.hasNext()) {
                lb.lI[] lIArray;
                lb lb2 = (lb)lk2.next();
                block8: for (lb.lI lI2 : lIArray = lb2.lu()) {
                    String string = l10l.lI(lI2.lj(), com.aspose.pdf.internal.l69if.lh.lt());
                    switch (gStringSwitchMap.lI(string)) {
                        case 0: {
                            l0t2.addItem(this.convertXHTML(lI2, configuration, timeout.l0if()));
                            continue block8;
                        }
                        case 1: {
                            l0t2.addItem(this.convertSVG(lI2, configuration));
                        }
                    }
                }
            }
        }
        finally {
            if (com.aspose.pdf.internal.l90y.lb.lf((Object)lk2, l5f.class)) {
                ((l5f)lk2).dispose();
            }
        }
        if (l0t2.size() != 0) {
            l0t2.set_Item(0, new lI((com.aspose.pdf.internal.l38f.lf)l0t2.get_Item(0), messageHandler));
            l0t2.set_Item(l0t2.size() - 1, new com.aspose.pdf.internal.l38f.lb((com.aspose.pdf.internal.l38f.lf)l0t2.get_Item(l0t2.size() - 1), messageHandler));
        }
        documentSources.addRange(l0t2);
    }

    private com.aspose.pdf.internal.l38f.lf convertSVG(lb.lI item, Configuration configuration) {
        SVGDocument sVGDocument = new SVGDocument(item.lf(), configuration);
        lf.lI().lI(lf.lI().lf(this), sVGDocument);
        return new ld(sVGDocument);
    }

    private com.aspose.pdf.internal.l38f.lf convertXHTML(lb.lI item, Configuration configuration, l10j timeout) {
        HTMLDocument hTMLDocument = new HTMLDocument(item.lf(), configuration);
        hTMLDocument.getContext().addService(new com.aspose.pdf.internal.l44v.lI((lj)hTMLDocument.getContext()), com.aspose.pdf.internal.l44t.lI.class);
        return new lt(hTMLDocument, timeout.l0if());
    }
}

