/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.forms;

import com.aspose.pdf.internal.html.HTMLButtonElement;
import com.aspose.pdf.internal.html.HTMLDocument;
import com.aspose.pdf.internal.html.HTMLElement;
import com.aspose.pdf.internal.html.HTMLFormElement;
import com.aspose.pdf.internal.html.HTMLInputElement;
import com.aspose.pdf.internal.html.HTMLOptionElement;
import com.aspose.pdf.internal.html.HTMLSelectElement;
import com.aspose.pdf.internal.html.HTMLTextAreaElement;
import com.aspose.pdf.internal.html.collections.HTMLCollection;
import com.aspose.pdf.internal.html.dom.DOMException;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.lf;
import com.aspose.pdf.internal.html.forms.ButtonElement;
import com.aspose.pdf.internal.html.forms.InputElement;
import com.aspose.pdf.internal.html.forms.OptionElement;
import com.aspose.pdf.internal.html.forms.SelectElement;
import com.aspose.pdf.internal.html.forms.TextAreaElement;
import com.aspose.pdf.internal.html.forms.lf;
import com.aspose.pdf.internal.html.lc;
import com.aspose.pdf.internal.html.net.HttpMethod;
import com.aspose.pdf.internal.l90y.lb;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lh;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lk;
import com.aspose.pdf.internal.ms.System.Collections.Generic.ly;
import com.aspose.pdf.internal.ms.System.l10k;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l8t;

public class FormEditor
implements lh<com.aspose.pdf.internal.html.forms.lI>,
l5f {
    private static final com.aspose.pdf.internal.ms.System.Collections.Generic.lf<l10k, lc> TypeToTagMap = new com.aspose.pdf.internal.ms.System.Collections.Generic.lf();
    private HTMLFormElement _form;
    private com.aspose.pdf.internal.ms.System.Collections.Generic.lf<Element, com.aspose.pdf.internal.html.forms.lI> _fields = new com.aspose.pdf.internal.ms.System.Collections.Generic.lf();

    private FormEditor(HTMLFormElement form) {
        this._form = form;
    }

    public static FormEditor createNew(HTMLDocument document) {
        HTMLFormElement hTMLFormElement = (HTMLFormElement)document.createElement("form");
        return FormEditor.create(hTMLFormElement);
    }

    public static FormEditor create(HTMLFormElement form) {
        return new FormEditor(form);
    }

    public static FormEditor create(HTMLDocument document, int index) {
        HTMLCollection hTMLCollection = document.getForms();
        if (index < 0 || index >= hTMLCollection.getLength()) {
            throw com.aspose.pdf.internal.l31f.lI.ld();
        }
        return FormEditor.create((HTMLFormElement)hTMLCollection.get_Item(index));
    }

    public static FormEditor create(HTMLDocument document, String id) {
        Element element = document.getElementById(id);
        if (element == null) {
            throw com.aspose.pdf.internal.l31f.lI.lv();
        }
        HTMLFormElement hTMLFormElement = (HTMLFormElement)((Object)lb.lI(element, HTMLFormElement.class));
        if (hTMLFormElement == null) {
            throw com.aspose.pdf.internal.l31f.lI.l2if();
        }
        return FormEditor.create(hTMLFormElement);
    }

    public HTMLFormElement getForm() {
        return this._form;
    }

    public int getCount() {
        return this._form.getLength();
    }

    public HttpMethod getMethod() {
        return new HttpMethod(this._form.getMethod());
    }

    public void setMethod(HttpMethod value) {
        this._form.setMethod(value.getName());
    }

    public String getAction() {
        return this._form.getAction();
    }

    public void setAction(String value) {
        this._form.setAction(value);
    }

    public <T extends com.aspose.pdf.internal.html.forms.lI> T add(String name, Class<T> clazz) {
        l10k l10k2 = lb.lI(clazz);
        if (!TypeToTagMap.containsKey(l10k2)) {
            throw new com.aspose.pdf.internal.ms.System.lh(l10l.lI("'{0}' is not valid.", new Object[]{l10k2}));
        }
        Element element = this._form.getOwnerDocument().createElement(lc.lI(TypeToTagMap.get_Item(l10k2)));
        element.setAttribute("name", name);
        this._form.appendChild(element);
        return (T)this.getOrCreate((HTMLElement)element);
    }

    public InputElement addInput(String name) {
        return this.addInput(name, 2);
    }

    public InputElement addInput(String name, int type) {
        InputElement inputElement = this.add(name, InputElement.class);
        inputElement.setType(type);
        return inputElement;
    }

    public com.aspose.pdf.internal.html.forms.lI get_Item(int index) {
        HTMLElement hTMLElement = (HTMLElement)((Object)lb.lI(this._form.getElements().get_Item(index), HTMLElement.class));
        if (hTMLElement == null) {
            throw com.aspose.pdf.internal.l31f.lI.ld();
        }
        return this.getOrCreate(hTMLElement);
    }

    public com.aspose.pdf.internal.html.forms.lI get_Item(String name) {
        HTMLElement hTMLElement = (HTMLElement)((Object)lb.lI(this._form.getElements().namedItem(name), HTMLElement.class));
        if (hTMLElement == null) {
            throw com.aspose.pdf.internal.l31f.lI.lv();
        }
        return this.getOrCreate(hTMLElement);
    }

    public <T extends com.aspose.pdf.internal.html.forms.lI> T getElement(Class<T> typeOfT, int index) {
        return (T)((com.aspose.pdf.internal.html.forms.lI)((Object)lb.lI(this.get_Item(index), typeOfT)));
    }

    public <T extends com.aspose.pdf.internal.html.forms.lI> T getElement(Class<T> typeOfT, String name) {
        return (T)((com.aspose.pdf.internal.html.forms.lI)((Object)lb.lI(this.get_Item(name), typeOfT)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(com.aspose.pdf.internal.ms.System.Collections.Generic.lf<String, String> values) {
        block8: {
            lk lk2 = values.iterator();
            block5: while (true) {
                while (lk2.hasNext()) {
                    ly ly2 = (ly)lk2.next();
                    try {
                        com.aspose.pdf.internal.html.forms.lI lI2 = this.get_Item((String)ly2.lI());
                        lI2.setValue((String)ly2.lf());
                        continue block5;
                    }
                    catch (DOMException dOMException) {
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                if (lb.lf((Object)lk2, l5f.class)) {
                    ((l5f)lk2).dispose();
                }
            }
        }
    }

    @Override
    public lk<com.aspose.pdf.internal.html.forms.lI> iterator() {
        return new lI(this);
    }

    @Override
    public void dispose() {
        this._fields.clear();
    }

    private com.aspose.pdf.internal.html.forms.lI getOrCreate(HTMLElement element) {
        if (!this._fields.containsKey(element)) {
            lc lc2 = element._Tag;
            if (l8t.lf(lc2, lf.le.l6j)) {
                this._fields.addItem(element, new InputElement((HTMLInputElement)element));
            } else if (l8t.lf(lc2, lf.le.l6y)) {
                this._fields.addItem(element, new SelectElement((HTMLSelectElement)element));
            } else if (l8t.lf(lc2, lf.le.l6f)) {
                this._fields.addItem(element, new OptionElement((HTMLOptionElement)element));
            } else if (l8t.lf(lc2, lf.le.l7if)) {
                this._fields.addItem(element, new TextAreaElement((HTMLTextAreaElement)element));
            } else if (l8t.lf(lc2, lf.le.l6h)) {
                this._fields.addItem(element, new ButtonElement((HTMLButtonElement)element));
            } else {
                this._fields.addItem(element, new lf(element));
            }
        }
        return this._fields.get_Item(element);
    }

    static {
        TypeToTagMap.addItem(lb.lI(InputElement.class), lf.le.l6j);
        TypeToTagMap.addItem(lb.lI(SelectElement.class), lf.le.l6y);
        TypeToTagMap.addItem(lb.lI(OptionElement.class), lf.le.l6f);
        TypeToTagMap.addItem(lb.lI(TextAreaElement.class), lf.le.l7if);
        TypeToTagMap.addItem(lb.lI(ButtonElement.class), lf.le.l6h);
    }

    private static class lI
    implements lk<com.aspose.pdf.internal.html.forms.lI> {
        private FormEditor lI;
        private lk<Element> lf;

        public lI(FormEditor formEditor) {
            this.lI = formEditor;
            this.lf = formEditor.getForm().getElements().iterator();
        }

        @Override
        public void dispose() {
            this.lf.dispose();
        }

        @Override
        public boolean hasNext() {
            return this.lf.hasNext();
        }

        @Override
        public void lI() {
            this.lf.lI();
        }

        public com.aspose.pdf.internal.html.forms.lI lf() {
            return this.lI.getOrCreate((HTMLElement)this.lf.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.lf();
        }
    }
}

