/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.dom.svg;

import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Node;
import com.aspose.pdf.internal.html.dom.Text;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.le;
import com.aspose.pdf.internal.html.dom.svg.SVGElement;
import com.aspose.pdf.internal.html.dom.svg.SVGGraphicsElement;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGAnimatedEnumeration;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGAnimatedLength;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGPoint;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGRect;
import com.aspose.pdf.internal.l32n.lu;
import com.aspose.pdf.internal.l32y.l0if;
import com.aspose.pdf.internal.l68if.l0t;
import com.aspose.pdf.internal.l90y.lb;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l7n;

@DOMObjectAttribute
@DOMNameAttribute(name="SVGTextContentElement")
public class SVGTextContentElement
extends SVGGraphicsElement {
    @DOMNameAttribute(name="LENGTHADJUST_UNKNOWN")
    public static final int LENGTHADJUST_UNKNOWN = 0;
    @DOMNameAttribute(name="LENGTHADJUST_SPACING")
    public static final int LENGTHADJUST_SPACING = 1;
    @DOMNameAttribute(name="LENGTHADJUST_SPACINGANDGLYPHS")
    public static final int LENGTHADJUST_SPACINGANDGLYPHS = 2;
    private final lu textLength = new lu(this, "textLength");
    private final l0if lengthAdjust = new l0if(this);

    public SVGTextContentElement(le name, Document doc) {
        super(name, doc);
    }

    @DOMNameAttribute(name="textLength")
    public SVGAnimatedLength getTextLength() {
        return (SVGAnimatedLength)this.textLength.lv();
    }

    @DOMNameAttribute(name="lengthAdjust")
    public SVGAnimatedEnumeration getLengthAdjust() {
        return (SVGAnimatedEnumeration)this.lengthAdjust.lv();
    }

    @DOMNameAttribute(name="getNumberOfChars")
    public long getNumberOfChars() {
        return this.calculateNumberOfChars(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long calculateNumberOfChars(Node root) {
        switch (root.getNodeType()) {
            case 3: {
                return ((Text)root).getData().length();
            }
            case 1: {
                SVGElement sVGElement = (SVGElement)((Object)lb.lI(root, SVGElement.class));
                if (sVGElement == null || !sVGElement.isRendered()) return 0L;
                long l = 0L;
                l0t l0t2 = root.getChildNodes().iterator();
                try {
                    while (l0t2.hasNext()) {
                        Node node = (Node)l0t2.next();
                        l += this.calculateNumberOfChars(node);
                    }
                    return l;
                }
                finally {
                    if (lb.lf((Object)l0t2, l5f.class)) {
                        ((l5f)((Object)l0t2)).dispose();
                    }
                }
            }
        }
        return 0L;
    }

    @DOMNameAttribute(name="getComputedTextLength")
    public float getComputedTextLength() {
        return this.getSubStringLength(lb.le(0, 9), lb.le(this.getNumberOfChars(), 11));
    }

    @DOMNameAttribute(name="getSubStringLength")
    public float getSubStringLength(long charnum, long nchars) {
        throw new l7n();
    }

    @DOMNameAttribute(name="getStartPositionOfChar")
    public SVGPoint getStartPositionOfChar(long charnum) {
        throw new l7n();
    }

    @DOMNameAttribute(name="getEndPositionOfChar")
    public SVGPoint getEndPositionOfChar(long charnum) {
        throw new l7n();
    }

    @DOMNameAttribute(name="getExtentOfChar")
    public SVGRect getExtentOfChar(long charnum) {
        throw new l7n();
    }

    @DOMNameAttribute(name="getRotationOfChar")
    public float getRotationOfChar(long charnum) {
        throw new l7n();
    }

    @DOMNameAttribute(name="getCharNumAtPosition")
    public long getCharNumAtPosition(SVGPoint point) {
        throw new l7n();
    }

    @DOMNameAttribute(name="selectSubString")
    public void selectSubString(long charnum, long nchars) {
        throw new l7n();
    }
}

