/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.dom.svg;

import com.aspose.pdf.internal.html.Configuration;
import com.aspose.pdf.internal.html.Url;
import com.aspose.pdf.internal.html.collections.HTMLCollection;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.css.ICSSStyleDeclaration;
import com.aspose.pdf.internal.html.dom.css.IDocumentCSS;
import com.aspose.pdf.internal.html.dom.events.IDocumentEvent;
import com.aspose.pdf.internal.html.dom.events.lb;
import com.aspose.pdf.internal.html.dom.svg.SVGElement;
import com.aspose.pdf.internal.html.dom.svg.SVGSVGElement;
import com.aspose.pdf.internal.html.dom.svg.saving.SVGSaveOptions;
import com.aspose.pdf.internal.html.lj;
import com.aspose.pdf.internal.html.net.RequestMessage;
import com.aspose.pdf.internal.html.rendering.IDevice;
import com.aspose.pdf.internal.html.rendering.SvgRenderer;
import com.aspose.pdf.internal.l32h.lk;
import com.aspose.pdf.internal.l37f.lI;
import com.aspose.pdf.internal.l46v.lf;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l1y;
import com.aspose.pdf.internal.ms.System.IO.lt;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;

@DOMObjectAttribute
@DOMNameAttribute(name="SVGDocument")
public class SVGDocument
extends Document
implements IDocumentCSS,
IDocumentEvent {
    private static final String EmptyDocument = "<svg xmlns=\"http://www.w3.org/2000/svg\"/>";
    private String auto_Referrer;
    private String auto_Domain;
    private String auto_URL;

    public SVGDocument() {
        this(EmptyDocument, "about:blank");
    }

    public SVGDocument(Configuration configuration) {
        this(EmptyDocument, "about:blank", configuration);
    }

    public SVGDocument(String address) {
        this(new Url(address, l10l.lI(new Object[]{lt.lf(), Character.valueOf(l1y.lj)})));
    }

    public SVGDocument(Url url) {
        this(url, new Configuration());
    }

    public SVGDocument(String address, Configuration configuration) {
        this(new Url(address, l10l.lI(new Object[]{lt.lf(), Character.valueOf(l1y.lj)})), configuration);
    }

    public SVGDocument(Url url, Configuration configuration) {
        this(lI.lf(url), configuration, 3);
    }

    public SVGDocument(Stream content, String baseUri) {
        this(content, baseUri, new Configuration());
    }

    public SVGDocument(Stream content, String baseUri, Configuration configuration) {
        this(lI.lf(content, baseUri), configuration, 3);
    }

    public SVGDocument(String content, String baseUri) {
        this(content, baseUri, new Configuration());
    }

    public SVGDocument(String content, String baseUri, Configuration configuration) {
        this(lI.lf(content, baseUri), configuration, 3);
    }

    public SVGDocument(RequestMessage request) {
        this(request, new Configuration());
    }

    public SVGDocument(RequestMessage request, Configuration configuration) {
        this(request, configuration, 1);
    }

    private SVGDocument(final RequestMessage request, Configuration configuration, final byte flags) {
        super(new lj(configuration), new Document.lI(){
            {
                this.lI(lb.lt);
                this.lI(request);
                this.lI(flags);
            }
        });
    }

    public SVGDocument(lj context) {
        super(context);
    }

    @DOMNameAttribute(name="title")
    public String getTitle() {
        HTMLCollection hTMLCollection = this.getRootElement().getElementsByTagName("title");
        if (hTMLCollection.getLength() == 0) {
            return l10l.lI;
        }
        String string = hTMLCollection.get_Item(0).getTextContent();
        if (string == null) {
            string = l10l.lI;
        }
        return string;
    }

    @DOMNameAttribute(name="referrer")
    public String getReferrer() {
        return this.auto_Referrer;
    }

    @DOMNameAttribute(name="referrer")
    private void setReferrer(String value) {
        this.auto_Referrer = value;
    }

    @DOMNameAttribute(name="domain")
    public String getDomain() {
        return this.auto_Domain;
    }

    @DOMNameAttribute(name="domain")
    private void setDomain(String value) {
        this.auto_Domain = value;
    }

    @DOMNameAttribute(name="URL")
    public String getURL() {
        return this.auto_URL;
    }

    @DOMNameAttribute(name="URL")
    private void setURL(String value) {
        this.auto_URL = value;
    }

    @DOMNameAttribute(name="rootElement")
    public SVGSVGElement getRootElement() {
        return (SVGSVGElement)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocumentElement(), SVGSVGElement.class));
    }

    public void save(Url url) {
        this.save(url, 0);
    }

    public void save(String path) {
        this.save(new Url(path, l10l.lI(new Object[]{lt.lf(), Character.valueOf(l1y.lj)})));
    }

    public void save(String path, int saveFormat) {
        this.save(new Url(path, l10l.lI(new Object[]{lt.lf(), Character.valueOf(l1y.lj)})), saveFormat);
    }

    public void save(String path, SVGSaveOptions saveOptions) {
        this.save(new Url(path, l10l.lI(new Object[]{lt.lf(), Character.valueOf(l1y.lj)})), saveOptions);
    }

    public void save(Url url, int saveFormat) {
        switch (saveFormat) {
            case 0: {
                this.save(url, new SVGSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, SVGSaveOptions saveOptions) {
        lf lf2 = this.getContext().getService(com.aspose.pdf.internal.html.services.lk.class).lI(this.getBrowsingContext());
        l5f l5f2 = lf2.lI((Url)this.getLocation(), saveOptions);
        try {
            lf2.lI().lf(url);
            lf2.lI(this);
        }
        finally {
            if (l5f2 != null) {
                l5f2.dispose();
            }
        }
    }

    @Override
    public void renderTo(IDevice device) {
        SvgRenderer svgRenderer = new SvgRenderer();
        try {
            svgRenderer.render(device, this);
        }
        finally {
            if (svgRenderer != null) {
                svgRenderer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        ICSSStyleDeclaration iCSSStyleDeclaration = this.getBrowsingContext().lt().lI(elt, pseudoElt);
        SVGElement sVGElement = (SVGElement)((Object)com.aspose.pdf.internal.l90y.lb.lI(elt, SVGElement.class));
        if (sVGElement != null) {
            com.aspose.pdf.internal.ms.System.Collections.Generic.lk<lk> lk2 = sVGElement.getSVGAttributeBindings().iterator();
            try {
                while (lk2.hasNext()) {
                    lk lk3 = (lk)lk2.next();
                    if ((lk3.bl_() & 1) != 1) continue;
                    iCSSStyleDeclaration.setProperty(lk3.lI(), lk3.lc(), null);
                }
            }
            finally {
                if (com.aspose.pdf.internal.l90y.lb.lf(lk2, l5f.class)) {
                    ((l5f)lk2).dispose();
                }
            }
        }
        return iCSSStyleDeclaration;
    }
}

