/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.dom.events;

import com.aspose.pdf.internal.html.dom.DOMObject;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.EventTarget;
import com.aspose.pdf.internal.html.dom.Node;
import com.aspose.pdf.internal.html.dom.attributes.DOMConstructorAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNullableAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMTimeStampAttribute;
import com.aspose.pdf.internal.html.dom.events.CustomEvent;
import com.aspose.pdf.internal.html.dom.events.ErrorEvent;
import com.aspose.pdf.internal.html.dom.events.KeyboardEvent;
import com.aspose.pdf.internal.html.dom.events.MouseEvent;
import com.aspose.pdf.internal.html.dom.events.UIEvent;
import com.aspose.pdf.internal.html.dom.events.lj;
import com.aspose.pdf.internal.l26h.l2v;
import com.aspose.pdf.internal.l90y.lb;
import com.aspose.pdf.internal.l90y.lh;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0if;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0l;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lk;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l2j;
import com.aspose.pdf.internal.ms.System.l3t;
import com.aspose.pdf.internal.ms.System.l5f;
import java.util.concurrent.atomic.AtomicReference;

@DOMObjectAttribute
@DOMNameAttribute(name="Event")
public class Event
extends DOMObject {
    @DOMNameAttribute(name="NONE")
    public static final int NONE_PHASE = 0;
    @DOMNameAttribute(name="CAPTURING_PHASE")
    public static final int CAPTURING_PHASE = 1;
    @DOMNameAttribute(name="AT_TARGET")
    public static final int AT_TARGET_PHASE = 2;
    @DOMNameAttribute(name="BUBBLING_PHASE")
    public static final int BUBBLING_PHASE = 3;
    private static final lh gStringSwitchMap = new lh("CUSTOMEVENT", "EVENT", "EVENTS", "HTMLEVENTS", "KEYBOARDEVENT", "KEYEVENTS", "MOUSEEVENT", "MOUSEEVENTS", "UIEVENT", "UIEVENTS");
    private lf flags = new lf();
    private boolean auto_Bubbles;
    private boolean auto_Cancelable;
    private EventTarget auto_CurrentTarget;
    private int auto_EventPhase;
    private EventTarget auto_Target;
    private long auto_TimeStamp;
    private String auto_Type;
    private boolean auto_IsTrusted;

    @DOMConstructorAttribute
    public Event(String type) {
        this(type, new lI());
    }

    @DOMConstructorAttribute
    public Event(String type, lI eventInitDict) {
        this.setEventPhase(0);
        this.flags.lj(lf.ld);
        this.setType(type);
        this.setBubbles(eventInitDict.ld());
        this.setCancelable(eventInitDict.lu());
        this.setTrusted(eventInitDict.le());
        this.setTimeStamp(l2j.ly(l3t.l0l().l0p()));
    }

    public static Event createDOMContentLoadedEvent(lI eventInit) {
        return Event.createEvent("DOMContentLoaded", eventInit);
    }

    public static Event createEvent(String type) {
        return Event.createEvent(type, new lI());
    }

    public static Event createEvent(String type, lI eventInit) {
        eventInit.lj(true);
        return new Event(type, eventInit);
    }

    public static Event createError(Exception exception) {
        return new ErrorEvent(exception, new ErrorEvent.lI());
    }

    public static Event createEventByType(String eventType) {
        Event event;
        switch (gStringSwitchMap.lI(l10l.l0if(eventType))) {
            case 0: {
                event = new CustomEvent(l10l.lI);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                event = new Event(l10l.lI);
                break;
            }
            case 4: 
            case 5: {
                event = new KeyboardEvent(l10l.lI);
                break;
            }
            case 6: 
            case 7: {
                event = new MouseEvent(l10l.lI);
                break;
            }
            case 8: 
            case 9: {
                event = new UIEvent(l10l.lI);
                break;
            }
            default: {
                throw com.aspose.pdf.internal.l31f.lI.lc();
            }
        }
        event.flags.lt(lf.ld);
        return event;
    }

    @DOMNameAttribute(name="bubbles")
    public boolean getBubbles() {
        return this.auto_Bubbles;
    }

    @DOMNameAttribute(name="bubbles")
    private void setBubbles(boolean value) {
        this.auto_Bubbles = value;
    }

    @DOMNameAttribute(name="cancelable")
    public boolean getCancelable() {
        return this.auto_Cancelable;
    }

    @DOMNameAttribute(name="cancelable")
    private void setCancelable(boolean value) {
        this.auto_Cancelable = value;
    }

    @DOMNameAttribute(name="currentTarget")
    @DOMNullableAttribute
    public EventTarget getCurrentTarget() {
        return this.auto_CurrentTarget;
    }

    @DOMNameAttribute(name="currentTarget")
    @DOMNullableAttribute
    public void setCurrentTarget(EventTarget value) {
        this.auto_CurrentTarget = value;
    }

    @DOMNameAttribute(name="eventPhase")
    public int getEventPhase() {
        return this.auto_EventPhase;
    }

    @DOMNameAttribute(name="eventPhase")
    public void setEventPhase(int value) {
        this.auto_EventPhase = value;
    }

    @DOMNameAttribute(name="target")
    @DOMNullableAttribute
    public EventTarget getTarget() {
        return this.auto_Target;
    }

    @DOMNameAttribute(name="target")
    @DOMNullableAttribute
    public void setTarget(EventTarget value) {
        this.auto_Target = value;
    }

    @DOMNameAttribute(name="timeStamp")
    @DOMTimeStampAttribute
    public long getTimeStamp() {
        return this.auto_TimeStamp;
    }

    @DOMNameAttribute(name="timeStamp")
    @DOMTimeStampAttribute
    private void setTimeStamp(long value) {
        this.auto_TimeStamp = value;
    }

    @DOMNameAttribute(name="type")
    public String getType() {
        return this.auto_Type;
    }

    @DOMNameAttribute(name="type")
    private void setType(String value) {
        this.auto_Type = value;
    }

    @DOMNameAttribute(name="defaultPrevented")
    public boolean getDefaultPrevented() {
        return this.flags.lf(lf.lj);
    }

    @DOMNameAttribute(name="isTrusted")
    public boolean isTrusted() {
        return this.auto_IsTrusted;
    }

    @DOMNameAttribute(name="isTrusted")
    private void setTrusted(boolean value) {
        this.auto_IsTrusted = value;
    }

    @DOMNameAttribute(name="initEvent")
    public void initEvent(String type, boolean bubbles, boolean cancelable) {
        if (this.flags.lf(lf.lu)) {
            return;
        }
        this.flags.lj(lf.ld);
        this.flags.lt(lf.lI);
        this.flags.lt(lf.lf);
        this.flags.lt(lf.lj);
        this.setTrusted(false);
        this.setTarget(null);
        this.setType(type);
        this.setBubbles(bubbles);
        this.setCancelable(cancelable);
        this.setTimeStamp(l2j.ly(l3t.l0l().l0p()));
    }

    @DOMNameAttribute(name="preventDefault")
    public void preventDefault() {
        if (this.getCancelable() && !this.flags.lf(lf.lt)) {
            this.flags.lj(lf.lj);
        }
    }

    @DOMNameAttribute(name="stopPropagation")
    public void stopPropagation() {
        this.flags.lj(lf.lI);
    }

    @DOMNameAttribute(name="stopImmediatePropagation")
    public void stopImmediatePropagation() {
        this.flags.lj(lf.lI);
        this.flags.lj(lf.lf);
    }

    public boolean dispatch(EventTarget targetOverride) {
        l0l<EventTarget> l0l2;
        if (this.flags.lf(lf.lu) || !this.flags.lf(lf.ld)) {
            throw com.aspose.pdf.internal.l31f.lI.l0if();
        }
        this.flags.lj(lf.lu);
        this.setTarget(targetOverride);
        l0if<EventTarget> l0if2 = this.getPath(this.getTarget());
        this.setEventPhase(1);
        for (l0l2 = l0if2.lu(); l0l2 != null && !this.flags.lf(lf.lI); l0l2 = l0l2.lj()) {
            this.invoke(l0l2.lb());
        }
        this.setEventPhase(2);
        if (!this.flags.lf(lf.lI)) {
            this.invoke(this.getTarget());
        }
        if (this.getBubbles()) {
            this.setEventPhase(3);
            for (l0l2 = l0if2.le(); l0l2 != null && !this.flags.lf(lf.lI); l0l2 = l0l2.lt()) {
                this.invoke(l0l2.lb());
            }
        }
        this.flags.lt(lf.lu);
        this.setEventPhase(0);
        this.setCurrentTarget(null);
        return !this.flags.lf(lf.lj);
    }

    private l0if<EventTarget> getPath(EventTarget target) {
        Node node;
        l0if<EventTarget> l0if2 = new l0if<EventTarget>();
        while (target != null && (node = (Node)((Object)lb.lI(target, Node.class))) != null) {
            target = (node.getNodeType() & 0xFFFF) != 9 ? node.getParentNode() : (EventTarget)((Object)lb.lI(((Document)node).getContext().getWindow(), EventTarget.class));
            if (target == null) continue;
            l0if2.lI(target);
        }
        return l0if2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(EventTarget target) {
        l0t<lj.lf> l0t2 = new l0t<lj.lf>(target.EventMap.lf(this.getType()));
        this.setCurrentTarget(target);
        lk lk2 = l0t2.iterator();
        try {
            while (lk2.hasNext()) {
                lj.lf lf2 = (lj.lf)lk2.next();
                if (this.flags.lf(lf.lI)) {
                    return;
                }
                if (this.getEventPhase() == 1 && !lf2.lj() || this.getEventPhase() == 3 && lf2.lj()) continue;
                try {
                    lf2.lf().handleEvent(this);
                }
                catch (Exception exception) {
                    Node node = (Node)((Object)lb.lI(target, Node.class));
                    Document document = node != null ? node.nodeDocument : ((com.aspose.pdf.internal.html.window.l0if)target).lj().getActiveDocument();
                    document.dispatchEvent(new ErrorEvent(exception));
                }
            }
        }
        finally {
            if (lb.lf((Object)lk2, l5f.class)) {
                ((l5f)lk2).dispose();
            }
        }
    }

    public static class lI
    extends com.aspose.pdf.internal.ms.System.Collections.Generic.lf<String, Object> {
        private boolean lI;

        public boolean ld() {
            return com.aspose.pdf.internal.l26f.lI.lI(String.class, Object.class, Boolean.class, this, "bubbles", false);
        }

        public void lI(boolean bl) {
            this.set_Item("bubbles", bl);
        }

        public boolean lu() {
            return com.aspose.pdf.internal.l26f.lI.lI(String.class, Object.class, Boolean.class, this, "cancelable", false);
        }

        public void lf(boolean bl) {
            this.set_Item("cancelable", bl);
        }

        public boolean le() {
            return this.lI;
        }

        public void lj(boolean bl) {
            this.lI = bl;
        }
    }

    private static class lf
    extends l2v {
        public static final int lI;
        public static final int lf;
        public static final int lj;
        public static final int lt;
        public static final int lb;
        public static final int ld;
        public static final int lu;
        private static AtomicReference<l2v.lI> le;

        public lf() {
            super(le.get());
        }

        static {
            le = new AtomicReference<Object>(null);
            l2v.lI lI2 = new l2v.lI();
            lI = lI2.lI("STOP_PROPAGATION");
            lf = lI2.lI("STOP_IMMEDIATE_PROPAGATION");
            lj = lI2.lI("CANCELED");
            lt = lI2.lI("IN_PASSIVE_LISTENER");
            lb = lI2.lI("COMPOSED");
            ld = lI2.lI("INITIALIZED");
            lu = lI2.lI("DISPATCH");
            le.set(lI2);
        }
    }
}

