/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.DocMDPSignature;
import com.aspose.pdf.Document;
import com.aspose.pdf.Field;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.InternalHelper;
import com.aspose.pdf.PKCS1;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.Signature;
import com.aspose.pdf.SignatureField;
import com.aspose.pdf.WidgetAnnotation;
import com.aspose.pdf.exceptions.PdfException;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.l0f.lf;
import com.aspose.pdf.internal.l12l.ld;
import com.aspose.pdf.internal.l5n.l0if;
import com.aspose.pdf.internal.l90y.lb;
import com.aspose.pdf.internal.ms.System.Collections.Generic.ly;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l0u;
import com.aspose.pdf.internal.ms.System.IO.l1j;
import com.aspose.pdf.internal.ms.System.IO.l1t;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.lh;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfFileSignature
extends SaveableFacade {
    private static final Logger lI = Logger.getLogger(PdfFileSignature.class.getName());
    private String lf;
    private String lj;
    private InputStream lt;
    private Signature lb;
    private int ld;
    private String lu;
    private boolean le;
    private Rectangle lh;
    private String lk;
    private String lc;
    private int ly;

    private void lj(String string) {
        this.lt();
        if (!(this.getDocument().getForm().get_Item(string) instanceof SignatureField) || ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature() == null) {
            throw new lh(l10l.lI("The name '{0}' doesn't represent valid signature field or signature field is empty.", new Object[]{string}));
        }
    }

    private void lt(String string) {
        this.lt();
        if (!(this.getDocument().getForm().get_Item(string) instanceof SignatureField) || ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature() != null) {
            throw new lh(l10l.lI("The name '{0}' doesn't represent valid signature field or signature field is not empty.", new Object[]{string}));
        }
    }

    private void lI() {
        if (this.lb != null) {
            throw new PdfException("Several signatures can't be placed at once. Please, after each Sign invoke Save.");
        }
        if (InternalHelper.lI(this.getDocument())) {
            throw new PdfException("You cannot change this document because it is certified.");
        }
    }

    private String lf() {
        int n = 1;
        String string = "Signature";
        do {
            string = l10l.lI("Signature{0}", new Object[]{com.aspose.pdf.internal.l90y.lb.lI(n)});
            ++n;
        } while (this.getDocument().getForm().get(string) != null);
        return string;
    }

    public String getSignatureAppearance() {
        return this.lj;
    }

    public void setSignatureAppearance(String value) {
        this.lj = value;
        if (value != null) {
            this.lt = null;
        }
    }

    public PdfFileSignature() {
    }

    @Deprecated
    public PdfFileSignature(String inputFile) {
        this.bindPdf(inputFile);
    }

    @Deprecated
    public PdfFileSignature(String inputFile, String outputFile) {
        this.bindPdf(inputFile);
        this.lf = outputFile;
    }

    @Override
    public void bindPdf(String inputFile) {
        this.ly = (int)new l0u(inputFile).lj();
        super.bindPdf(inputFile);
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        this.lu(Stream.fromJava(inputStream));
    }

    @Override
    void lu(Stream stream) {
        this.ly = (int)stream.getLength();
        super.lu(stream);
    }

    @Override
    public void save(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.save(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream outputStream) {
        this.lt();
        String string = null;
        if (this.getDocument().getEngineDoc().lI() != null && this.getDocument().getEngineDoc().lI().lI() != null && !l10l.lf(this.getDocument().getEngineDoc().lI().lI().l5f())) {
            string = this.getDocument().getEngineDoc().lI().lI().l5f();
        }
        this.lI(this.getDocument().getEngineDoc().lc(), l1j2, string);
        try (l1j l1j2 = new l1j();){
            if (((Stream)l1j2).canSeek()) {
                ((Stream)l1j2).seek(0L, 0);
            }
            byte[] byArray = new byte[l1j2.toInputStream().available()];
            l1j2.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
    }

    private void lI(Stream stream, Stream stream2, String string) {
        if (this.lb != null) {
            Object object;
            Document document;
            int n;
            if (stream.canSeek()) {
                stream.seek(0L, 0);
            }
            byte[] byArray = new byte[1024];
            while ((n = stream.read(byArray, 0, com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray).le())) == com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray).le()) {
                stream2.write(byArray, 0, com.aspose.pdf.internal.ms.System.ly.lj((Object)byArray).le());
            }
            stream2.write(byArray, 0, n);
            if (stream2.canSeek()) {
                stream2.seek(0L, 0);
            }
            if (string != null) {
                document = InternalHelper.lI(stream2, string, false);
                document.decrypt();
            } else {
                document = new Document(stream2);
            }
            for (int i = 0; i < document.getEngineDoc().lf().l5k().lh().length; ++i) {
                object = document.getEngineDoc().lf().l5k();
                lf lf2 = object.lh()[i];
                l0if l0if2 = object.lI(lf2);
                object.lI(l0if2, false);
            }
            if (this.lj != null) {
                this.lb.setImageInternal(new l1t(this.lj, 3, 1, 1));
            } else if (this.lt != null) {
                this.lb.setImage(this.lt);
            }
            if (this.lu != null) {
                SignatureField signatureField = (SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(document.getForm().get_Item(this.lu), SignatureField.class));
                if (signatureField != null) {
                    if (!this.le) {
                        signatureField.setRect(Rectangle.getTrivial());
                    } else if (this.lh != null) {
                        signatureField.setRect(this.lh);
                    }
                    signatureField.sign(this.lb);
                }
            } else {
                SignatureField signatureField;
                if (!this.le) {
                    signatureField = new SignatureField(document.getPages().get_Item(this.ld), Rectangle.getTrivial());
                } else {
                    object = this.lh == null ? new Rectangle(10.0, 10.0, 110.0, 110.0) : this.lh;
                    signatureField = new SignatureField(document.getPages().get_Item(this.ld), (Rectangle)object);
                }
                object = this.lf();
                signatureField.setPartialName((String)object);
                document.getForm().add(signatureField, this.ld);
                document.getEngineDoc().lI(false);
                document.save();
                signatureField = (SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(document.getForm().get_Item((String)object), SignatureField.class));
                signatureField.sign(this.lb);
            }
        } else {
            this.getDocument().save(stream2.toOutputStream());
        }
        if (this.lb != null && this.lb.getImageInternal() != null) {
            this.lb.getImageInternal().dispose();
        }
        this.lb = null;
    }

    public void sign(int page, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect) {
        if (this.lk == null) {
            throw new IllegalStateException("Certificate file and password was not set. Please call SetCertificate.");
        }
        this.sign(page, SigReason, SigContact, SigLocation, visible, annotRect, new PKCS1(this.lk, this.lc));
    }

    public void sign(int page, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect, Signature sig) {
        this.lI();
        this.ld = page;
        this.lb = sig;
        this.lb.setReason(SigReason);
        this.lb.setContactInfo(SigContact);
        this.lb.setLocation(SigLocation);
        this.le = visible;
        this.lh = new Rectangle(annotRect.getX(), annotRect.getY() + annotRect.getHeight(), annotRect.getX() + annotRect.getWidth(), annotRect.getY());
    }

    public void sign(int page, boolean visible, java.awt.Rectangle annotRect, Signature sig) {
        this.sign(page, sig.getReason(), sig.getContactInfo(), sig.getLocation(), visible, annotRect, sig);
    }

    public void sign(String SigName, String SigReason, String SigContact, String SigLocation, Signature sig) {
        this.lI();
        this.lt(SigName);
        this.lu = SigName;
        this.lb = sig;
        this.lb.setReason(SigReason);
        this.lb.setContactInfo(SigContact);
        this.lb.setLocation(SigLocation);
        this.le = true;
    }

    public void sign(int page, String SigName, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect, Signature sig) {
        this.lI();
        this.ld = page;
        this.lb = sig;
        this.lu = SigName;
        this.lb.setReason(SigReason);
        this.lb.setContactInfo(SigContact);
        this.lb.setLocation(SigLocation);
        this.le = visible;
        this.lh = new Rectangle(annotRect.getX(), annotRect.getY(), annotRect.getX() + annotRect.getWidth(), annotRect.getY() - annotRect.getHeight());
    }

    public void sign(String SigName, Signature sig) {
        this.sign(SigName, sig.getReason(), sig.getContactInfo(), sig.getLocation(), sig);
    }

    public boolean isCertified() {
        this.lt();
        return InternalHelper.lI(this.getDocument());
    }

    public int getAccessPermissions() {
        this.lt();
        for (WidgetAnnotation widgetAnnotation : this.getDocument().getForm()) {
            Field field;
            SignatureField signatureField;
            if (!(widgetAnnotation instanceof Field) || (signatureField = (SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(field = (Field)widgetAnnotation, SignatureField.class))) == null || signatureField.getSignature() == null || signatureField.getSignature().getSignatureReferences() == null) continue;
            for (ld ld2 : signatureField.getSignature().getSignatureReferences()) {
                com.aspose.pdf.internal.l12l.lf lf2;
                if (!l10l.lb(ld2.lf().toString(), "DocMDP") || (lf2 = (com.aspose.pdf.internal.l12l.lf)((Object)com.aspose.pdf.internal.l90y.lb.lI(ld2.lj(), com.aspose.pdf.internal.l12l.lf.class))) == null) continue;
                return lf2.lf().lf();
            }
        }
        throw new PdfException("The document is not certified.");
    }

    public void certify(int page, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect, DocMDPSignature docMdpSignature) {
        Signature signature = docMdpSignature.getSignature();
        signature.setReason(SigReason);
        signature.setContactInfo(SigContact);
        signature.setLocation(SigLocation);
        this.sign(page, signature.getReason(), signature.getContactInfo(), signature.getLocation(), visible, annotRect, signature);
    }

    public List<String> getSignNames() {
        this.lt();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WidgetAnnotation widgetAnnotation : this.getDocument().getForm()) {
            Field field;
            if (!(widgetAnnotation instanceof Field) || !((field = (Field)widgetAnnotation) instanceof SignatureField) || ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(field, SignatureField.class))).getSignature() == null) continue;
            arrayList.add(field.getPartialName());
        }
        return arrayList;
    }

    public List<String> getBlankSignNames() {
        this.lt();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WidgetAnnotation widgetAnnotation : this.getDocument().getForm()) {
            Field field;
            if (!(widgetAnnotation instanceof Field) || !((field = (Field)widgetAnnotation) instanceof SignatureField) || ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(field, SignatureField.class))).getSignature() != null) continue;
            arrayList.add(field.getPartialName());
        }
        return arrayList;
    }

    @Deprecated
    public boolean isContainSignature() {
        return this.containsSignature();
    }

    public boolean containsSignature() {
        return this.getSignNames().size() > 0;
    }

    public boolean containsUsageRights() {
        for (Object object : this.getDocument().getForm()) {
            Field field;
            SignatureField signatureField;
            if (!(object instanceof Field) || (signatureField = (SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(field = (Field)object, SignatureField.class))) == null || signatureField.getSignature() == null) continue;
            for (ld ld2 : signatureField.getSignature().getSignatureReferences()) {
                if (!"UR3".equals(ld2.lf().toString())) continue;
                return true;
            }
        }
        if (this.getDocument().getEngineDoc().lf().l0v() != null) {
            for (Object object : this.getDocument().getEngineDoc().lf().l0v()) {
                if (!"UR3".equals(((ly)object).lI())) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public boolean isCoversWholeDocument(String signName) {
        return this.coversWholeDocument(signName);
    }

    public boolean coversWholeDocument(String signName) {
        this.lt();
        this.lj(signName);
        int n = ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[2] + ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[3];
        return n == this.ly;
    }

    public int getRevision(String signName) {
        this.lt();
        this.lj(signName);
        int[] nArray = new int[this.getTotalRevision()];
        int n = 0;
        for (String string : this.getSignNames()) {
            nArray[n++] = ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature().getByteRange()[2] + ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature().getByteRange()[3];
        }
        com.aspose.pdf.internal.ms.System.ly.lb(com.aspose.pdf.internal.ms.System.ly.lj((Object)nArray));
        int n2 = ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[2] + ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[3];
        return Arrays.binarySearch(nArray, n2) + 1;
    }

    public int getTotalRevision() {
        this.lt();
        return this.getSignNames().size();
    }

    public void removeUsageRights() {
        for (Object object : this.getDocument().getForm()) {
            Field field;
            SignatureField signatureField;
            if (!(object instanceof Field) || (signatureField = (SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(field = (Field)object, SignatureField.class))) == null || signatureField.getSignature() == null) continue;
            for (ld ld2 : signatureField.getSignature().getSignatureReferences()) {
                if (!"UR3".equals(ld2.lf().toString())) continue;
                signatureField.clear();
                return;
            }
        }
        if (this.getDocument().getEngineDoc().lf().l0v() != null) {
            for (Object object : this.getDocument().getEngineDoc().lf().l0v()) {
                if (!"UR3".equals(((ly)object).lI())) continue;
                this.getDocument().getEngineDoc().lf().l0v().lb("UR3");
                return;
            }
        }
    }

    public void removeSignature(String signName) {
        this.lt();
        if (InternalHelper.lI(this.getDocument())) {
            throw new PdfException("You cannot change this document because it is certified.");
        }
        if (!(this.getDocument().getForm().get_Item(signName) instanceof SignatureField)) {
            throw new lh(l10l.lI("The name '{0}' doesn't represent valid signature field.", new Object[]{signName}));
        }
        this.getDocument().getForm().delete(signName);
    }

    public void removeSignature(String signName, boolean removeField) {
        if (removeField) {
            this.removeSignature(signName);
        } else {
            SignatureField signatureField = (SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class));
            if (signatureField == null) {
                throw new lh(l10l.lI("The name '{0}' doesn't represent valid signature field.", new Object[]{signName}));
            }
            signatureField.clear();
        }
    }

    public boolean verifySigned(String signName) {
        return this.verifySignature(signName);
    }

    public String getSignerName(String signName) {
        this.lj(signName);
        return ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getAuthority();
    }

    public Date getDateTime(String signName) {
        this.lj(signName);
        return ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getDate();
    }

    public String getReason(String signName) {
        this.lj(signName);
        return ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getReason();
    }

    public String getLocation(String signName) {
        this.lj(signName);
        return ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getLocation();
    }

    public String getContactInfo(String signName) {
        this.lj(signName);
        return ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getContactInfo();
    }

    public boolean verifySignature(String signName) {
        this.lt();
        if (this.getDocument().getForm().get_Item(signName) instanceof SignatureField) {
            if (((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature() != null) {
                return ((SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().verify();
            }
            throw new lh(l10l.lI("Signature field '{0}' is empty.", new Object[]{signName}));
        }
        throw new lh(l10l.lI("The name '{0}' doesn't represent valid signature field.", new Object[]{signName}));
    }

    public InputStream extractImage(String signName) {
        Stream stream = this.lI(signName);
        if (stream.canSeek()) {
            stream.seek(0L, 0);
        }
        return Stream.toJava(stream);
    }

    Stream lI(String string) {
        this.lt();
        SignatureField signatureField = (SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(string), SignatureField.class));
        if (signatureField != null) {
            if (signatureField.getSignature() != null) {
                return Stream.fromJava(signatureField.extractImage());
            }
            throw new lh(l10l.lI("Signature field '{0}' is empty.", new Object[]{string}));
        }
        throw new lh(l10l.lI("The name '{0}' doesn't represent valid signature field.", new Object[]{string}));
    }

    Stream lf(String string) {
        this.lt();
        SignatureField signatureField = (SignatureField)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getDocument().getForm().get_Item(string), SignatureField.class));
        if (signatureField != null) {
            if (signatureField.getSignature() != null) {
                return Stream.fromJava(signatureField.extractCertificate());
            }
            throw new lh(l10l.lI("Signature field '{0}' is empty.", new Object[]{string}));
        }
        throw new lh(l10l.lI("The name '{0}' doesn't represent valid signature field.", new Object[]{string}));
    }

    public InputStream extractCertificate(String signName) {
        return Stream.toJava(this.lf(signName));
    }

    @Deprecated
    public void save() {
        if (this.lf == null) {
            throw new IllegalStateException("Output file is not defined. Please use proper PdfFileSignature constuctor to set output file.");
        }
        this.save(this.lf);
    }

    public PdfFileSignature(IDocument document) {
        super(document);
        if (document.getEngineDoc() != null && document.getEngineDoc().lc() != null && document.getEngineDoc().lc().canRead()) {
            this.ly = (int)document.getEngineDoc().lc().getLength();
        }
    }

    @Deprecated
    public PdfFileSignature(IDocument document, String outputFile) {
        super(document);
        this.lf = outputFile;
    }

    public void setCertificate(String pfx, String pass) {
        this.lk = pfx;
        this.lc = pass;
    }

    public InputStream getSignatureAppearanceStream() {
        return this.lt;
    }

    public void setSignatureAppearanceStream(InputStream value) {
        this.lt = value;
        if (value != null) {
            this.lj = null;
        }
    }

    @Override
    public void close() {
        super.close();
        this.lf = null;
        this.lj = null;
        if (this.lb != null && this.lb.getImageInternal() != null) {
            this.lb.getImageInternal().close();
        }
        if (this.lt != null) {
            try {
                this.lt.close();
            }
            catch (IOException iOException) {
                lI.log(Level.INFO, "Exception occur", iOException);
            }
        }
        this.lt = null;
        this.lb = null;
        this.ld = 0;
        this.lu = null;
        this.le = false;
        this.lh = null;
        this.lk = null;
        this.lc = null;
        this.ly = 0;
    }

    @Override
    public void dispose() {
        this.close();
    }

    static {
        lI.setUseParentHandlers(false);
    }
}

