/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Document;
import com.aspose.pdf.ExplicitDestination;
import com.aspose.pdf.ExplicitDestinationTypeConverter;
import com.aspose.pdf.ExtendedBoolean;
import com.aspose.pdf.FitHExplicitDestination;
import com.aspose.pdf.GoToAction;
import com.aspose.pdf.GoToRemoteAction;
import com.aspose.pdf.GoToURIAction;
import com.aspose.pdf.IAppointment;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.LaunchAction;
import com.aspose.pdf.NamedDestination;
import com.aspose.pdf.OutlineItemCollection;
import com.aspose.pdf.Page;
import com.aspose.pdf.facades.Bookmark;
import com.aspose.pdf.facades.Bookmarks;
import com.aspose.pdf.facades.PdfContentEditor;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.l71j.l45f;
import com.aspose.pdf.internal.l71j.l46v;
import com.aspose.pdf.internal.l71l.l0p;
import com.aspose.pdf.internal.l90y.lb;
import com.aspose.pdf.internal.l90y.lh;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l0if;
import com.aspose.pdf.internal.ms.System.IO.l1j;
import com.aspose.pdf.internal.ms.System.IO.l1y;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l1p;
import com.aspose.pdf.internal.ms.System.l4l;
import com.aspose.pdf.internal.ms.System.l4p;
import com.aspose.pdf.internal.ms.System.l5v;
import com.aspose.pdf.internal.ms.System.l6l;
import com.aspose.pdf.internal.ms.System.l6u;
import com.aspose.pdf.internal.ms.System.l7n;
import com.aspose.pdf.internal.ms.System.l9n;
import java.awt.Color;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfBookmarkEditor
extends SaveableFacade {
    private static final Logger lI = Logger.getLogger(PdfBookmarkEditor.class.getName());
    private static final lh lf;

    private static void lI(OutlineItemCollection outlineItemCollection, String string, String string2) {
        while (outlineItemCollection != null) {
            if (l10l.lb(l10l.lj(outlineItemCollection.getTitle()), l10l.lj(string))) {
                outlineItemCollection.setTitle(string2);
            }
            if (outlineItemCollection.getFirst() != null) {
                PdfBookmarkEditor.lI(outlineItemCollection.getFirst(), string, string2);
            }
            outlineItemCollection = outlineItemCollection.getNext();
        }
    }

    private static void lI(l46v l46v2, OutlineItemCollection outlineItemCollection, String string) {
        if (outlineItemCollection == null) {
            return;
        }
        l46v2.l0t("ul");
        while (outlineItemCollection != null) {
            Object object;
            l46v2.l0t("li");
            l46v2.lI(0);
            l46v2.l0t("a");
            if (outlineItemCollection.getDestination() != null) {
                PdfBookmarkEditor.lI(l46v2, outlineItemCollection.getDestination(), string);
            } else if (outlineItemCollection.getAction() instanceof GoToRemoteAction) {
                object = (GoToRemoteAction)((Object)lb.lI(outlineItemCollection.getAction(), GoToRemoteAction.class));
                String string2 = string;
                if (((GoToRemoteAction)object).getFile().getName() != null) {
                    string2 = ((GoToRemoteAction)object).getFile().getName();
                }
                PdfBookmarkEditor.lI(l46v2, ((GoToRemoteAction)object).getDestination(), string2);
            } else if (outlineItemCollection.getAction() instanceof GoToAction) {
                object = (GoToAction)((Object)lb.lI(outlineItemCollection.getAction(), GoToAction.class));
                PdfBookmarkEditor.lI(l46v2, ((GoToAction)object).getDestination(), string);
            } else if (outlineItemCollection.getAction() instanceof GoToURIAction) {
                l46v2.lj("href", ((GoToURIAction)outlineItemCollection.getAction()).getURI());
            } else if (outlineItemCollection.getAction() instanceof LaunchAction) {
                l46v2.lj("href", ((LaunchAction)outlineItemCollection.getAction()).getFile());
            }
            object = new StringBuilder();
            if (outlineItemCollection.getBold()) {
                ((StringBuilder)object).append("font-weight: bold;");
            }
            if (outlineItemCollection.getItalic()) {
                ((StringBuilder)object).append("font-style: italic;");
            }
            if (((StringBuilder)object).length() != 0) {
                l46v2.lj("style", ((StringBuilder)object).toString());
            }
            l46v2.lb(l10l.lj(outlineItemCollection.getTitle()));
            l46v2.lk();
            if (outlineItemCollection.getFirst() != null) {
                l46v2.lI(1);
                PdfBookmarkEditor.lI(l46v2, outlineItemCollection.getFirst(), string);
            }
            l46v2.lk();
            l46v2.lI(1);
            outlineItemCollection = outlineItemCollection.getNext();
        }
        l46v2.lk();
    }

    private static void lI(l46v l46v2, IAppointment iAppointment, String string) {
        if (iAppointment instanceof ExplicitDestination) {
            l46v2.lj("href", l10l.lI(new Object[]{string, "#page=", ((ExplicitDestination)iAppointment).getPage().getNumber()}));
        } else if (iAppointment instanceof NamedDestination) {
            l46v2.lj("href", l10l.lI(new String[]{string, "#nameddest=", ((NamedDestination)iAppointment).getName()}));
        }
    }

    private static void lI(l46v l46v2, OutlineItemCollection outlineItemCollection) {
        while (outlineItemCollection != null) {
            boolean bl;
            Object object;
            l46v2.l0t("Title");
            if (outlineItemCollection.getItalic() || outlineItemCollection.getBold()) {
                object = new StringBuilder();
                if (outlineItemCollection.getItalic() && !outlineItemCollection.getBold()) {
                    ((StringBuilder)object).append("italic");
                } else if (!outlineItemCollection.getItalic() && outlineItemCollection.getBold()) {
                    ((StringBuilder)object).append("bold");
                } else {
                    ((StringBuilder)object).append("italic bold");
                }
                l46v2.lj("Style", ((StringBuilder)object).toString());
            }
            if (outlineItemCollection.getColor() != null && (outlineItemCollection.getColor().getAlpha() & 0xFF) != 0) {
                object = outlineItemCollection.getColor();
                String string = l10l.lI(com.aspose.pdf.internal.l69if.lh.lt(), "{0} {1} {2}", Float.valueOf((float)(((Color)object).getRed() & 0xFF) / 255.0f), Float.valueOf((float)(((Color)object).getGreen() & 0xFF) / 255.0f), Float.valueOf((float)(((Color)object).getBlue() & 0xFF) / 255.0f));
                l46v2.lj("Color", string);
            }
            if (outlineItemCollection.getDestination() != null) {
                PdfBookmarkEditor.lI(l46v2, outlineItemCollection.getDestination());
                l46v2.lj("Action", "GoTo");
            } else if (outlineItemCollection.getAction() instanceof GoToRemoteAction) {
                object = (GoToRemoteAction)((Object)lb.lI(outlineItemCollection.getAction(), GoToRemoteAction.class));
                l46v2.lj("NewWindow", l4p.lI(ExtendedBoolean.class, ((GoToRemoteAction)object).getNewWindow()));
                l46v2.lj("File", ((GoToRemoteAction)object).getFile().getName());
                PdfBookmarkEditor.lI(l46v2, ((GoToRemoteAction)object).getDestination());
                l46v2.lj("Action", "GoToR");
            } else if (outlineItemCollection.getAction() instanceof GoToAction) {
                object = (GoToAction)((Object)lb.lI(outlineItemCollection.getAction(), GoToAction.class));
                PdfBookmarkEditor.lI(l46v2, ((GoToAction)object).getDestination());
                l46v2.lj("Action", "GoTo");
            } else if (outlineItemCollection.getAction() instanceof GoToURIAction) {
                l46v2.lj("URI", ((GoToURIAction)((Object)lb.lI(outlineItemCollection.getAction(), GoToURIAction.class))).getURI());
                l46v2.lj("Action", "URI");
            } else if (outlineItemCollection.getAction() instanceof LaunchAction) {
                l46v2.lj("File", ((LaunchAction)((Object)lb.lI(outlineItemCollection.getAction(), LaunchAction.class))).getFile());
                l46v2.lj("Action", "Launch");
            }
            boolean bl2 = bl = outlineItemCollection.getFirst() != null;
            if (bl) {
                l46v2.lj("Open", l1p.lf(outlineItemCollection.getOpen()));
            }
            PdfBookmarkEditor.lI(l46v2, l10l.lj(outlineItemCollection.getTitle()));
            if (bl) {
                PdfBookmarkEditor.lI(l46v2, outlineItemCollection.getFirst());
            }
            l46v2.lk();
            outlineItemCollection = outlineItemCollection.getNext();
        }
    }

    private static void lI(l46v l46v2, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '\u007f') {
                l46v2.ld(l10l.lI(new Object[]{"&#", (int)c, Character.valueOf(';')}));
                continue;
            }
            l46v2.lb(com.aspose.pdf.internal.ms.System.l1y.l0j(c));
        }
    }

    private static void lI(l46v l46v2, IAppointment iAppointment) {
        if (iAppointment instanceof ExplicitDestination) {
            l46v2.lj("Page", iAppointment.toString());
        } else if (iAppointment instanceof NamedDestination) {
            l46v2.lj("Named", iAppointment.toString());
        }
    }

    private static void lI(l45f l45f2, IDocument iDocument, OutlineItemCollection outlineItemCollection) {
        do {
            if (!"Title".equals(l45f2.l0n())) continue;
            if (l45f2.l1if() == 1) {
                String[] stringArray;
                String string;
                OutlineItemCollection outlineItemCollection2 = new OutlineItemCollection(iDocument.getOutlines());
                String string2 = l45f2.lj("Style");
                if (string2 != null) {
                    switch (lf.lI(string2)) {
                        case 0: {
                            outlineItemCollection2.setItalic(true);
                            break;
                        }
                        case 1: {
                            outlineItemCollection2.setBold(true);
                            break;
                        }
                        case 2: 
                        case 3: {
                            outlineItemCollection2.setItalic(true);
                            outlineItemCollection2.setBold(true);
                            break;
                        }
                    }
                }
                if ((string = l45f2.lj("Color")) != null && (stringArray = l10l.ld(string, ' ')).length == 3) {
                    int n = (int)((double)(l9n.lI(stringArray[0], (l6l)com.aspose.pdf.internal.l69if.lh.lt()) * 255.0f) + 0.5);
                    int n2 = (int)((double)(l9n.lI(stringArray[1], (l6l)com.aspose.pdf.internal.l69if.lh.lt()) * 255.0f) + 0.5);
                    int n3 = (int)((double)(l9n.lI(stringArray[2], (l6l)com.aspose.pdf.internal.l69if.lh.lt()) * 255.0f) + 0.5);
                    outlineItemCollection2.setColor(new Color(n, n2, n3));
                }
                if (l45f2.lt("Action")) {
                    stringArray = l45f2.lj("Action");
                    switch (lf.lI((String)stringArray)) {
                        case 4: {
                            outlineItemCollection2.setDestination(PdfBookmarkEditor.lI(l45f2, iDocument));
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 6: {
                            throw new l7n();
                        }
                        case 7: {
                            throw new l7n();
                        }
                    }
                }
                if (l45f2.lt("Open")) {
                    outlineItemCollection2.setOpen(l1p.lI(l45f2.lj("Open")));
                }
                if (l45f2.l0h()) {
                    if (outlineItemCollection == null) {
                        iDocument.getOutlines().add(outlineItemCollection2);
                        continue;
                    }
                    outlineItemCollection.add(outlineItemCollection2);
                    continue;
                }
                l45f2.le();
                if (l45f2.l1if() != 3) continue;
                outlineItemCollection2.setTitle(l45f2.l1j());
                if (outlineItemCollection == null) {
                    iDocument.getOutlines().add(outlineItemCollection2);
                } else {
                    outlineItemCollection.add(outlineItemCollection2);
                }
                l45f2.le();
                if (!"Title".equals(l45f2.l0n()) || l45f2.l1if() != 1) continue;
                PdfBookmarkEditor.lI(l45f2, iDocument, outlineItemCollection2);
                continue;
            }
            if (l45f2.l1if() != 15) continue;
            return;
        } while (l45f2.le());
    }

    private static IAppointment lI(l45f l45f2, IDocument iDocument) {
        if (l45f2.lt("Page")) {
            int n;
            String[] stringArray = l10l.lI(l45f2.lj("Page"), ' ');
            int n2 = stringArray.length > 1 ? ExplicitDestinationTypeConverter.toEnum(stringArray[1]) : 1;
            double[] dArray = null;
            try {
                n = l6u.lI(stringArray[0], (l6l)com.aspose.pdf.internal.l69if.lh.lt());
                if (stringArray.length > 2) {
                    dArray = new double[stringArray.length - 2];
                    for (int i = 2; i < stringArray.length; ++i) {
                        dArray[i - 2] = l4l.lI(stringArray[i], (l6l)com.aspose.pdf.internal.l69if.lh.lt());
                    }
                }
            }
            catch (l5v l5v2) {
                lI.log(Level.INFO, "Exception occur", l5v2);
                n = 1;
            }
            return ExplicitDestination.createDestination(iDocument.getPages().get_Item(n < 1 ? 1 : n), n2, dArray);
        }
        if (l45f2.lt("Named")) {
            throw new l7n();
        }
        return null;
    }

    private static void lI(Bookmarks bookmarks, Bookmarks bookmarks2) {
        for (Bookmark bookmark : bookmarks2) {
            bookmarks.addItem(bookmark);
            if (bookmark.getChildItem().size() == 0) continue;
            PdfBookmarkEditor.lI(bookmarks, bookmark.getChildItem());
        }
    }

    public void createBookmarks() {
        this.createBookmarks(Color.BLACK, false, false);
    }

    public void createBookmarkOfPage(String bookmarkName, int pageNumber) {
        this.lt();
        OutlineItemCollection outlineItemCollection = new OutlineItemCollection(this.getDocument().getOutlines());
        outlineItemCollection.setTitle(bookmarkName);
        Page page = this.getDocument().getPages().get_Item(1);
        if (pageNumber <= this.getDocument().getPages().size()) {
            page = this.getDocument().getPages().get_Item(pageNumber);
        }
        outlineItemCollection.setDestination(new FitHExplicitDestination(page, page.getRect().getHeight()));
        this.getDocument().getOutlines().add(outlineItemCollection);
    }

    public void createBookmarks(Bookmark bookmark) {
        this.lt();
        this.getDocument().getOutlines().add(bookmark.toOutlineItemCollection(this.getDocument()));
    }

    public void createBookmarks(Color color, boolean boldFlag, boolean italicFlag) {
        this.lt();
        PdfContentEditor pdfContentEditor = new PdfContentEditor();
        pdfContentEditor.bindPdf(this.getDocument());
        for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
            pdfContentEditor.createBookmarksAction(l10l.lI("Page{0}", new Object[]{i}), color, boldFlag, italicFlag, null, "GoTo", l6u.lf(i));
        }
    }

    public void createBookmarkOfPage(String[] bookmarkName, int[] pageNumber) {
        this.lt();
        if (bookmarkName.length != pageNumber.length) {
            throw new com.aspose.pdf.internal.ms.System.lh("Each bookmark must have name, but bookmarkName.Length != pageNumber.Length");
        }
        for (int i = 0; i < bookmarkName.length; ++i) {
            this.createBookmarkOfPage(bookmarkName[i], pageNumber[i]);
        }
    }

    public void deleteBookmarks() {
        this.lt();
        this.getDocument().getOutlines().delete();
    }

    public void deleteBookmarks(String title) {
        this.lt();
        this.getDocument().getOutlines().delete(title);
    }

    public void modifyBookmarks(String sTitle, String dTitle) {
        this.lt();
        if (this.getDocument().getOutlines().size() > 0) {
            PdfBookmarkEditor.lI(this.getDocument().getOutlines().getFirst(), sTitle, dTitle);
        }
    }

    public Bookmarks extractBookmarks() {
        return this.extractBookmarks(false);
    }

    public Bookmarks extractBookmarks(boolean upperLevel) {
        Bookmarks bookmarks = new Bookmarks();
        for (OutlineItemCollection outlineItemCollection : this.getDocument().getOutlines()) {
            System.out.println(outlineItemCollection.getTitle());
            Bookmark bookmark = Bookmark.lI(outlineItemCollection);
            bookmarks.addItem(bookmark);
            if (upperLevel || bookmark.getChildItem().size() == 0) continue;
            PdfBookmarkEditor.lI(bookmarks, bookmark.getChildItem());
        }
        return bookmarks;
    }

    public Bookmarks extractBookmarks(String title) {
        Bookmarks bookmarks = new Bookmarks();
        for (Bookmark bookmark : this.extractBookmarks()) {
            if (!l10l.lb(l10l.lj(bookmark.getTitle()), l10l.lj(title))) continue;
            bookmarks.addItem(bookmark);
        }
        return bookmarks;
    }

    public Bookmarks extractBookmarks(Bookmark bookmark) {
        Bookmarks bookmarks = this.extractBookmarks();
        for (Bookmark bookmark2 : bookmarks) {
            if (!l10l.lb(l10l.lj(bookmark2.getTitle()), l10l.lj(bookmark.getTitle()))) continue;
            return bookmark2.getChildItem();
        }
        return new Bookmarks();
    }

    @Deprecated
    public void extractBookmarksToHTML(String pdfFile, String cssFile) {
        String string = l1y.lf(l1y.ld(pdfFile), l1y.lf(pdfFile));
        PdfBookmarkEditor.exportBookmarksToHtml(pdfFile, l10l.lI(new String[]{string, "-index.html"}));
    }

    public void exportBookmarksToXML(String xmlFile) {
        l46v l46v2 = new l46v(xmlFile, l0p.lt("iso_8859_1"));
        l46v2.lI(1);
        l46v2.ld("<?xml version=\"1.0\" encoding=\"iso_8859_1\"?>");
        l46v2.l0t("Bookmark");
        PdfBookmarkEditor.lI(l46v2, this.getDocument().getOutlines().getFirst());
        l46v2.lk();
        l46v2.ld();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportBookmarksToXML(OutputStream output) {
        this.lf(l1j2);
        try (l1j l1j2 = new l1j();){
            if (((Stream)l1j2).canSeek()) {
                ((Stream)l1j2).seek(0L, 0);
            }
            byte[] byArray = new byte[l1j2.toInputStream().available()];
            l1j2.toInputStream().read(byArray);
            output.write(byArray);
        }
    }

    void lf(Stream stream) {
        l46v l46v2 = new l46v(stream, l0p.lt("iso-8859-1"));
        l46v2.lI(1);
        l46v2.ld("<?xml version=\"1.0\" encoding=\"ISO8859-1\"?>");
        l46v2.l0t("Bookmark");
        PdfBookmarkEditor.lI(l46v2, this.getDocument().getOutlines().getFirst());
        l46v2.lk();
        l46v2.lu();
    }

    public void importBookmarksWithXML(String xmlFile) {
        l45f l45f2 = new l45f(l0if.ld(xmlFile));
        l45f2.ld(true);
        l45f2.lu(2);
        PdfBookmarkEditor.lI(l45f2, this.getDocument(), null);
        l45f2.lt();
    }

    void lj(Stream stream) {
        l45f l45f2 = new l45f(stream);
        l45f2.ld(true);
        l45f2.lu(2);
        PdfBookmarkEditor.lI(l45f2, this.getDocument(), null);
        l45f2.lt();
    }

    public void importBookmarksWithXML(InputStream stream) {
        this.lj(Stream.fromJava(stream));
    }

    public PdfBookmarkEditor() {
    }

    public PdfBookmarkEditor(IDocument document) {
        super(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportBookmarksToHtml(String inPdfFile, String outHtmlFile) {
        Document document = new Document(inPdfFile);
        try {
            l0p l0p2 = l0p.l0k();
            l46v l46v2 = new l46v(outHtmlFile, l0p2);
            l46v2.lI(1);
            l46v2.lI("html", null, null, null);
            l46v2.l0t("html");
            l46v2.l0t("head");
            l46v2.l0t("title");
            l46v2.lb(l1y.lf(outHtmlFile));
            l46v2.lk();
            l46v2.l0t("meta");
            l46v2.lj("charset", l0p2.l0p());
            l46v2.lk();
            l46v2.l0t("style");
            l46v2.lj("type", "text/css");
            l46v2.lb("ul { list-style-type: none; }");
            l46v2.lk();
            l46v2.lk();
            l46v2.l0t("body");
            if (document.getOutlines().size() != 0) {
                PdfBookmarkEditor.lI(l46v2, document.getOutlines().getFirst(), l1y.lI(inPdfFile));
            } else {
                l46v2.lb("This document has no bookmarks.");
            }
            l46v2.lk();
            l46v2.lk();
            l46v2.ld();
        }
        finally {
            if (document != null) {
                document.dispose();
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    static {
        lI.setUseParentHandlers(false);
        lf = new lh("italic", "bold", "italic bold", "bold italic", "GoTo", "GoToR", "URI", "Launch");
    }
}

