/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.devices;

import com.aspose.pdf.IDocument;
import com.aspose.pdf.IIndexBitmapConverter;
import com.aspose.pdf.Page;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.RenderingOptions;
import com.aspose.pdf.devices.DocumentDevice;
import com.aspose.pdf.devices.Resolution;
import com.aspose.pdf.devices.TiffSettings;
import com.aspose.pdf.devices.lI;
import com.aspose.pdf.exceptions.IndexOutOfRangeException;
import com.aspose.pdf.internal.l10if.lu;
import com.aspose.pdf.internal.l10j.lh;
import com.aspose.pdf.internal.l10j.lt;
import com.aspose.pdf.internal.l10v.le;
import com.aspose.pdf.internal.l2u.ld;
import com.aspose.pdf.internal.l68j.lf;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l1j;
import com.aspose.pdf.internal.ms.System.l13p;
import com.aspose.pdf.internal.ms.System.l7f;
import com.aspose.pdf.internal.ms.System.lv;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TiffDevice
extends DocumentDevice {
    private static final Logger lI = Logger.getLogger(TiffDevice.class.getName());
    private Resolution lf;
    private TiffSettings lj = new TiffSettings();
    private IIndexBitmapConverter lt;
    private int lb = 0;
    private int ld = 0;
    private int lu = 0;
    private boolean le = false;
    private RenderingOptions lh = new RenderingOptions();
    private Rectangle lk = null;

    boolean lf() {
        return this.le;
    }

    void lI(boolean bl) {
        this.le = bl;
    }

    public RenderingOptions getRenderingOptions() {
        return this.lh;
    }

    public void setRenderingOptions(RenderingOptions value) {
        this.lh = value;
    }

    public int getFormPresentationMode() {
        return this.lu;
    }

    public void setFormPresentationMode(int value) {
        this.lu = value;
    }

    public TiffSettings getSettings() {
        return this.lj;
    }

    public Resolution getResolution() {
        return this.lf;
    }

    public TiffDevice(Resolution resolution) {
        this.lf = resolution;
        this.lj = new TiffSettings();
    }

    public TiffDevice(Resolution resolution, TiffSettings settings) {
        this.lf = resolution;
        this.lj = settings;
    }

    public TiffDevice(Resolution resolution, TiffSettings settings, IIndexBitmapConverter converter) {
        this.lf = resolution;
        this.lj = settings;
        this.lt = converter;
    }

    public TiffDevice(TiffSettings settings) {
        this.lf = new Resolution(150);
        this.lj = settings;
    }

    public TiffDevice(TiffSettings settings, IIndexBitmapConverter converter) {
        this.lf = new Resolution(150);
        this.lj = settings;
        this.lt = converter;
    }

    public TiffDevice() {
        this.lf = new Resolution(150);
        this.lj = new TiffSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInternal(IDocument document, int fromPage, int toPage, Stream output) {
        int n;
        if (document == null) {
            throw new l7f("Document is null");
        }
        super.lI(document);
        switch (this.lj.getCompression()) {
            case 0: {
                n = 2;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            default: {
                throw new lv();
            }
        }
        lt lt2 = new lt(this.lj.getMargins().getLeft(), this.lj.getMargins().getRight(), this.lj.getMargins().getTop(), this.lj.getMargins().getBottom());
        int n2 = 0;
        switch (this.lj.getDepth()) {
            case 0: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 196865;
                break;
            }
            case 2: {
                n2 = 197634;
                break;
            }
            case 1: {
                n2 = 198659;
                break;
            }
        }
        int n3 = this.lj.getShape();
        lh lh2 = new lh(n, n2, lt2, this.lj.getIndexedConversionType(), this.lj.getSkipBlankPages(), n3);
        lh2.lI(this.lj.getBrightness());
        lu lu2 = null;
        com.aspose.pdf.internal.l10j.le le2 = new com.aspose.pdf.internal.l10j.le(output, lh2, this.lf.getX(), this.lf.getY(), this.lt);
        try {
            try {
                for (int i = fromPage; i <= toPage; ++i) {
                    lf lf2 = null;
                    Page page = document.getPages().get_Item(i);
                    if (page == null) continue;
                    lI lI2 = new lI(page, new Point(0.0, 0.0), this.lb, this.ld, new Resolution(this.lf.getX(), this.lf.getY()), this.getFormPresentationMode(), this.getRenderingOptions(), this.lj.getCoordinateType());
                    ld ld2 = null;
                    ld[] ldArray = new ld[]{ld2};
                    if (this.lk != null) {
                        if (this.lk.getHeight() <= 0.0 || this.lk.getHeight() > document.getPages().get_Item(i).getMediaBox().getHeight() || this.lk.getWidth() <= 0.0 || this.lk.getWidth() > document.getPages().get_Item(i).getMediaBox().getWidth()) {
                            throw new IndexOutOfRangeException("Rectangle has falls parametrs");
                        }
                        le le3 = (le)lI2.lI();
                        le3.lI(this.lk);
                        lu2 = le3;
                    } else {
                        lu2 = lI2.lI(ldArray);
                    }
                    ld2 = ldArray[0];
                    try {
                        lf2 = (lf)lu2.lf().lk();
                        if (this.lj.getSkipBlankPages() && ld2.lf().lI(1.0E-5, lf2)) continue;
                        le2.lI(lf2);
                        continue;
                    }
                    finally {
                        if (lu2 != null) {
                            lu2.dispose();
                        }
                    }
                }
            }
            finally {
                le2.lI();
            }
        }
        finally {
            if (le2 != null) {
                le2.dispose();
            }
        }
    }

    @Override
    public void process(IDocument document, int fromPage, int toPage, OutputStream output) {
        l1j l1j2 = new l1j();
        this.processInternal(document, fromPage, toPage, l1j2);
        try {
            if (l1j2 != null) {
                output.write(l1j2.lt());
            }
            l1j2.close();
        }
        catch (IOException iOException) {
            lI.log(Level.INFO, "Exception occur", iOException);
        }
    }

    public TiffDevice(int width, int height, Resolution resolution, TiffSettings settings) {
        this.lb = width;
        this.ld = height;
        this.lf = resolution;
        this.lj = settings;
    }

    public TiffDevice(int width, int height, Resolution resolution, TiffSettings settings, IIndexBitmapConverter converter) {
        this.lb = width;
        this.ld = height;
        this.lf = resolution;
        this.lj = settings;
        this.lt = converter;
    }

    public TiffDevice(PageSize pageSize, Resolution resolution, TiffSettings settings) {
        float f = pageSize.getWidth();
        float f2 = pageSize.getHeight();
        this.lb = (int)l13p.lt((float)resolution.getX() * f / 72.0f);
        this.ld = (int)l13p.lt((float)resolution.getY() * f2 / 72.0f);
        this.lf = resolution;
        this.lj = settings;
    }

    public TiffDevice(PageSize pageSize, Resolution resolution, TiffSettings settings, IIndexBitmapConverter converter) {
        float f = pageSize.getWidth();
        float f2 = pageSize.getHeight();
        this.lb = (int)l13p.lt((float)resolution.getX() * f / 72.0f);
        this.ld = (int)l13p.lt((float)resolution.getY() * f2 / 72.0f);
        this.lf = resolution;
        this.lj = settings;
        this.lt = converter;
    }

    public TiffDevice(int width, int height, Resolution resolution) {
        this(width, height, resolution, new TiffSettings());
    }

    public TiffDevice(PageSize pageSize, Resolution resolution) {
        this(pageSize, resolution, new TiffSettings());
    }

    public TiffDevice(int width, int height, TiffSettings settings) {
        this(width, height, new Resolution(150), settings);
    }

    public TiffDevice(int width, int height, TiffSettings settings, IIndexBitmapConverter converter) {
        this(width, height, new Resolution(150), settings, converter);
    }

    public TiffDevice(PageSize pageSize, TiffSettings settings, IIndexBitmapConverter converter) {
        this(pageSize, new Resolution(150), settings, converter);
    }

    public TiffDevice(PageSize pageSize, TiffSettings settings) {
        this(pageSize, new Resolution(150), settings);
    }

    public TiffDevice(int width, int height) {
        this(width, height, new Resolution(150), new TiffSettings());
    }

    public TiffDevice(PageSize pageSize) {
        this(pageSize, new Resolution(150), new TiffSettings());
    }

    public int getWidth() {
        return this.lb;
    }

    public int getHeight() {
        return this.ld;
    }

    public Rectangle getCropRectangle() {
        return this.lk;
    }

    public void setCropRectangle(Rectangle cropRectangle) {
        this.lk = cropRectangle;
    }

    static {
        lI.setUseParentHandlers(false);
    }
}

