/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationSelector;
import com.aspose.pdf.Color;
import com.aspose.pdf.Document;
import com.aspose.pdf.Font;
import com.aspose.pdf.FontRepository;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.Redaction;
import com.aspose.pdf.XForm;
import com.aspose.pdf.internal.l5n.l0h;
import com.aspose.pdf.internal.l5n.l0if;
import com.aspose.pdf.internal.l5n.l0k;
import com.aspose.pdf.internal.l5n.l0n;
import com.aspose.pdf.internal.l5n.l1u;
import com.aspose.pdf.internal.l5n.l1v;
import com.aspose.pdf.internal.l5n.l2if;
import com.aspose.pdf.internal.l5n.lb;
import com.aspose.pdf.internal.l5n.lh;
import com.aspose.pdf.internal.l68j.ld;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.operators.BT;
import com.aspose.pdf.operators.ClosePathFillStroke;
import com.aspose.pdf.operators.ClosePathStroke;
import com.aspose.pdf.operators.ET;
import com.aspose.pdf.operators.GRestore;
import com.aspose.pdf.operators.GSave;
import com.aspose.pdf.operators.MoveTextPosition;
import com.aspose.pdf.operators.Re;
import com.aspose.pdf.operators.SelectFont;
import com.aspose.pdf.operators.SetLineWidth;
import com.aspose.pdf.operators.SetRGBColor;
import com.aspose.pdf.operators.SetRGBColorStroke;
import com.aspose.pdf.operators.ShowText;
import java.util.List;

public final class RedactionAnnotation
extends Annotation {
    RedactionAnnotation(l0if engineAnnot, IDocument document) {
        super(engineAnnot, document);
    }

    @Override
    public void accept(AnnotationSelector visitor) {
        visitor.visit(this);
    }

    public RedactionAnnotation(IDocument document) {
        super(document);
        this.getEngineDict().lf("Subtype", (com.aspose.pdf.internal.l5n.l0t)new l1v("Redact"));
    }

    public Point[] getQuadPoint() {
        if (this.getEngineDict().lt("QuadPoints")) {
            lb lb2 = this.getEngineDict().lj("QuadPoints").l5t();
            int n = lb2.lv() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(lb2.lI(2 * i).l5h().lu(), lb2.lI(2 * i + 1).l5h().lu());
            }
            return pointArray;
        }
        return null;
    }

    public void setQuadPoint(Point[] value) {
        l0n l0n2 = new l0n(this.getEngineDict());
        for (Point point : value) {
            l0n2.lI((com.aspose.pdf.internal.l5n.l0t)new l1u(point.getX()));
            l0n2.lI((com.aspose.pdf.internal.l5n.l0t)new l1u(point.getY()));
        }
        this.getEngineDict().lI("QuadPoints", (com.aspose.pdf.internal.l5n.l0t)l0n2);
        this.updateAppearances();
    }

    public RedactionAnnotation(Page page, Rectangle rect) {
        super(page, rect);
        this.getEngineDict().lf("Subtype", (com.aspose.pdf.internal.l5n.l0t)new l1v("Redact"));
        this.updateAppearances();
    }

    public Color getFillColor() {
        Color color = Color.getBlack();
        if (this.getEngineDict().lt("IC")) {
            com.aspose.pdf.internal.l5n.l0t l0t2 = this.getEngineDict().lf("IC");
            if (l0t2.l5t() == null) {
                return color;
            }
            if (l0t2.l5t().lv() < 3) {
                return color;
            }
            color = new Color(new double[]{l0t2.l5t().lI(0).l5h().lu(), l0t2.l5t().lI(1).l5h().lu(), l0t2.l5t().lI(2).l5h().lu()});
        }
        return color;
    }

    public void setFillColor(Color value) {
        this.getEngineDict().lI("IC", (com.aspose.pdf.internal.l5n.l0t)new l0n((l0h)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getEngineDict(), l0h.class)), new l1u[]{new l1u(com.aspose.pdf.internal.l90y.lb.lk(value.lf().l0if(), 6) / 255.0), new l1u(com.aspose.pdf.internal.l90y.lb.lk(value.lf().l0l(), 6) / 255.0), new l1u(com.aspose.pdf.internal.l90y.lb.lk(value.lf().l0t(), 6) / 255.0)}));
    }

    public Color getBorderColor() {
        Color color = Color.getBlack();
        if (this.getEngineDict().lt("OC")) {
            com.aspose.pdf.internal.l5n.l0t l0t2 = this.getEngineDict().lf("OC");
            if (l0t2.l5t() == null) {
                return color;
            }
            if (l0t2.l5t().lv() < 3) {
                return color;
            }
            color = new Color(new double[]{l0t2.l5t().lI(0).l5h().lu() / 255.0, l0t2.l5t().lI(1).l5h().lu() / 255.0, l0t2.l5t().lI(2).l5h().lu() / 255.0});
        }
        return color;
    }

    public void setBorderColor(Color value) {
        this.getEngineDict().lI("OC", (com.aspose.pdf.internal.l5n.l0t)new l0n((l0h)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getEngineDict(), l0h.class)), new l1u[]{new l1u(com.aspose.pdf.internal.l90y.lb.lk(value.lf().l0if(), 6)), new l1u(com.aspose.pdf.internal.l90y.lb.lk(value.lf().l0l(), 6)), new l1u(com.aspose.pdf.internal.l90y.lb.lk(value.lf().l0t(), 6))}));
    }

    public String getOverlayText() {
        com.aspose.pdf.internal.l5n.l0t l0t2;
        if (this.getEngineDict().lt("OverlayText") && (l0t2 = this.getEngineDict().lf("OverlayText")).l4f() != null) {
            return l0t2.l4f().lu();
        }
        return null;
    }

    public void setOverlayText(String value) {
        l2if l2if2 = new l2if((l0h)((Object)com.aspose.pdf.internal.l90y.lb.lI(this.getEngineDict(), l0h.class)), value);
        this.getEngineDict().lI("OverlayText", (com.aspose.pdf.internal.l5n.l0t)l2if2);
        this.updateAppearances();
    }

    public boolean isRepeat() {
        if (this.getEngineDict().lt("Repeat") && this.getEngineDict().lf("Repeat").l5p() != null) {
            return this.getEngineDict().lf("Repeat").l5p().lf();
        }
        return false;
    }

    public void setRepeat(boolean value) {
        this.getEngineDict().lI("Repeat", (com.aspose.pdf.internal.l5n.l0t)new l0k(value));
        this.updateAppearances();
    }

    public int getTextAlignment() {
        int n = 1;
        if (this.getEngineDict().lt("Q") && this.getEngineDict().lf("Q").l5h() != null) {
            switch (this.getEngineDict().lf("Q").l5h().lf()) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
            }
        }
        return n;
    }

    public void setTextAlignment(int value) {
        int n = 0;
        switch (value) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
        }
        this.getEngineDict().lI("Q", (com.aspose.pdf.internal.l5n.l0t)new l1u(n));
    }

    @Override
    boolean le() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void lI(Annotation annotation) {
        if (this._disableUpdateAppearance) {
            return;
        }
        XForm xForm = this.lI("N", annotation);
        XForm xForm2 = this.lI("R", annotation);
        xForm2.getResources().getFonts().add("Helv", "Helvetica");
        Document.startOperation();
        try {
            xForm.getContents().add(this.lj(new Annotation.lI("N"), annotation));
            xForm2.getContents().add(this.lj(new Annotation.lI("R"), annotation));
        }
        finally {
            Document.endOperation();
        }
    }

    l0t<Operator> lj(Annotation.lI lI2, Annotation annotation) {
        l0t<Operator> l0t2 = new l0t<Operator>();
        l0t2.addItem(new GSave());
        if ("R".equals(lI2.lI)) {
            l0t2.addItem(new SetRGBColor(this.getFillColor().toRgb()));
            l0t2.addItem(new SetRGBColorStroke(this.getFillColor().toRgb()));
            l0t2.addItem(new Re(0.0, 0.0, this.getRect().getWidth(), this.getRect().getHeight()));
            l0t2.addItem(new ClosePathFillStroke());
            if (this.getOverlayText() != null) {
                l0t2.addItem(new BT());
                l0t2.addItem(new SetRGBColor(this.getColor().toRgb()));
                l0t2.addItem(new SetRGBColorStroke(this.getColor().toRgb()));
                double d = 10.0;
                double d2 = this.getRect().getHeight();
                double d3 = 0.0;
                Font font = FontRepository.findFont("Helvetica");
                switch (this.getTextAlignment()) {
                    case 1: {
                        d3 = 0.0;
                        break;
                    }
                    case 2: {
                        d3 = (this.getWidth() - font.lf().lI(this.getOverlayText(), d)) / 2.0;
                        break;
                    }
                    case 3: {
                        d3 = this.getWidth() - font.lf().lI(this.getOverlayText(), d);
                        break;
                    }
                }
                l0t2.addItem(new SelectFont("Helv", d));
                l0t2.addItem(new MoveTextPosition(d3, d2));
                do {
                    l0t2.addItem(new MoveTextPosition(0.0, -d));
                    l0t2.addItem(new ShowText(this.getOverlayText()));
                } while (this.isRepeat() && (d2 -= d) > 0.0);
                l0t2.addItem(new ET());
            }
        } else if ("N".equals(lI2.lI)) {
            l0t2.addItem(new SetRGBColor(this.getBorderColor().toRgb()));
            l0t2.addItem(new SetRGBColorStroke(this.getBorderColor().toRgb()));
            l0t2.addItem(new SetLineWidth(5.0));
            l0t2.addItem(new Re(0.0, 0.0, this.getRect().getWidth(), this.getRect().getHeight()));
            l0t2.addItem(new ClosePathStroke());
        }
        l0t2.addItem(new GRestore());
        return l0t2;
    }

    @Override
    public void flatten() {
        lh lh2 = this.getEngineDict().lf("AP").l5l();
        lh2.lI("N", lh2.lf("R"));
        super.flatten();
    }

    public void redact() {
        Redaction.redactText(this.getPage(), this.getRect());
        Redaction.lI(this.getPage(), this.getRect(), ld.l0f().l12if(), false);
        Redaction.redactAnnotations(this.getPage(), this.getRect());
        this.flatten();
    }

    public void redactExact() {
        Redaction.redactText(this.getPage(), this.getRect());
        Redaction.lI(this.getPage(), this.getRect(), this.getFillColor().lf().l12if(), true);
        this.flatten();
    }

    @Override
    public int getAnnotationType() {
        return 23;
    }

    /* synthetic */ List lf(Annotation.lI lI2, Annotation annotation) {
        return this.lj(lI2, annotation);
    }
}

