/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.drawing.PatternColorSpace;
import com.aspose.pdf.internal.l0k.ld;
import com.aspose.pdf.internal.l8f.l0l;
import com.aspose.pdf.internal.l90y.lb;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l6u;
import com.aspose.pdf.internal.ms.System.l8t;
import com.aspose.pdf.internal.ms.System.ly;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Color {
    private static final Logger lI = Logger.getLogger(Color.class.getName());
    private double[] lf;
    private boolean lj = false;
    private double lt = 1.0;
    public static final Color Empty;
    private PatternColorSpace lb;

    public double getA() {
        return this.lt;
    }

    public double[] getData() {
        return this.lf;
    }

    public int getColorSpace() {
        if (this.getData() != null) {
            switch (this.getData().length) {
                case 1: {
                    return 2;
                }
                case 4: {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    public Color() {
    }

    public Color(double[] vector) {
        for (double d : vector) {
            if (!(d > 1.0)) continue;
            throw new IllegalStateException("Invalid input data: color element is out of range [0..1]");
        }
        this.lf = vector;
    }

    private Color(double[] vector, boolean isEmpty, double alpha) {
        for (double d : vector) {
            if (!(d > 1.0)) continue;
            throw new IllegalStateException("Invalid input data: color element is out of range [0..1]");
        }
        this.lf = vector;
        this.lj = isEmpty;
        this.lt = alpha;
    }

    public Color deepClone() {
        double[] dArray = new double[this.lf.length];
        System.arraycopy(this.lf, 0, dArray, 0, this.lf.length);
        return new Color(dArray, this.lI(), this.lt);
    }

    boolean lI() {
        return this.lj;
    }

    public static Color parse(String value) {
        try {
            String string = l10l.lb(value, 1);
            double[] dArray = new double[string.length() / 2];
            for (int i = 0; i < string.length(); i += 2) {
                dArray[i / 2] = (double)l6u.lI(l10l.lf(string, i, 2), 515) / 255.0;
            }
            return new Color(dArray, false, 1.0);
        }
        catch (RuntimeException runtimeException) {
            lI.log(Level.INFO, "Exception occur", runtimeException);
            return Color.lI(com.aspose.pdf.internal.l68j.ld.lI(value).l12if());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#");
        for (double d : this.lf) {
            stringBuilder.append(l10l.lI("{0:X2}", new Object[]{(int)(d * 255.0 + 0.5)}));
        }
        return stringBuilder.toString();
    }

    public java.awt.Color toRgb() {
        return this.lf().lI();
    }

    com.aspose.pdf.internal.l68j.ld lf() {
        Color color = this.lj();
        return com.aspose.pdf.internal.l68j.ld.lI((int)(255.0 * color.getData()[0] + 0.5), (int)(255.0 * color.getData()[1] + 0.5), (int)(255.0 * color.getData()[2] + 0.5));
    }

    static Color lI(com.aspose.pdf.internal.l68j.ld ld2) {
        return new Color(new double[]{(double)(ld2.l0if() & 0xFF) / 255.0, (double)(ld2.l0l() & 0xFF) / 255.0, (double)(ld2.l0t() & 0xFF) / 255.0}, ld2.lc() || com.aspose.pdf.internal.l90y.lb.lb((Object)ld2.ly(), 6) == 0, com.aspose.pdf.internal.l90y.lb.lk(ld2.ly(), 6) / 255.0);
    }

    public static Color fromRgb(java.awt.Color color) {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.lI(color));
    }

    Color lj() {
        if (ly.lj((Object)this.lf).le() == 1) {
            return Color.fromRgb(this.lf[0], this.lf[0], this.lf[0]);
        }
        if (ly.lj((Object)this.lf).le() == 4) {
            double d;
            double d2;
            double d3 = this.lf[0];
            double d4 = this.lf[1];
            double d5 = this.lf[2];
            double d6 = this.lf[3];
            double d7 = 1.0 - d3;
            double d8 = 1.0 - d4;
            double d9 = 1.0 - d5;
            double d10 = 1.0 - d6;
            double d11 = d2 = (d = d7 * d8 * d9 * d10);
            double d12 = d2;
            d = d7 * d8 * d9 * d6;
            d12 += 0.1373 * d;
            d11 += 0.1216 * d;
            d2 += 0.1255 * d;
            d = d7 * d8 * d5 * d10;
            d12 += d;
            d11 += 0.949 * d;
            d = d7 * d8 * d5 * d6;
            d12 += 0.1098 * d;
            d11 += 0.102 * d;
            d = d7 * d4 * d9 * d10;
            d12 += 0.9255 * d;
            d2 += 0.549 * d;
            d = d7 * d4 * d9 * d6;
            d12 += 0.1412 * d;
            d = d7 * d4 * d5 * d10;
            d12 += 0.9294 * d;
            d11 += 0.1098 * d;
            d2 += 0.1412 * d;
            d = d7 * d4 * d5 * d6;
            d12 += 0.1333 * d;
            d = d3 * d8 * d9 * d10;
            d11 += 0.6784 * d;
            d2 += 0.9373 * d;
            d = d3 * d8 * d9 * d6;
            d11 += 0.0588 * d;
            d2 += 0.1412 * d;
            d = d3 * d8 * d5 * d10;
            d11 += 0.651 * d;
            d2 += 0.3137 * d;
            d = d3 * d8 * d5 * d6;
            d11 += 0.0745 * d;
            d = d3 * d4 * d9 * d10;
            d12 += 0.1804 * d;
            d11 += 0.1922 * d;
            d2 += 0.5725 * d;
            d = d3 * d4 * d9 * d6;
            d2 += 0.0078 * d;
            d = d3 * d4 * d5 * d10;
            return Color.fromRgb(l0l.lI(d12 += 0.2118 * d), l0l.lI(d11 += 0.2119 * d), l0l.lI(d2 += 0.2235 * d));
        }
        return new Color(this.lf);
    }

    Color lt() {
        if (ly.lj((Object)this.lf).le() == 3) {
            if (ld.lI(this.lf[0], this.lf[1]) && ld.lI(this.lf[1], this.lf[2])) {
                return new Color(new double[]{this.lf[0]});
            }
            return new Color(new double[]{l0l.lI(0.299 * this.lf[0] + 0.587 * this.lf[1] + 0.114 * this.lf[2])});
        }
        if (ly.lj((Object)this.lf).le() == 4) {
            return this.lj().lt();
        }
        return new Color(this.lf);
    }

    Color lb() {
        if (ly.lj((Object)this.lf).le() == 1) {
            return new Color(new double[]{0.0, 0.0, 0.0, 1.0 - this.lf[0]});
        }
        if (ly.lj((Object)this.lf).le() == 3) {
            double[] dArray = new double[4];
            double d = l0l.lI(1.0 - this.lf[0]);
            double d2 = l0l.lI(1.0 - this.lf[1]);
            double d3 = l0l.lI(1.0 - this.lf[2]);
            double d4 = d;
            if (d2 < d4) {
                d4 = d2;
            }
            if (d3 < d4) {
                d4 = d3;
            }
            dArray[0] = l0l.lI(d - d4);
            dArray[1] = l0l.lI(d2 - d4);
            dArray[2] = l0l.lI(d3 - d4);
            dArray[3] = l0l.lI(d4);
            return new Color(dArray);
        }
        return new Color(this.lf);
    }

    public static Color fromArgb(int r, int g, int b) {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.lI(r, g, b).l12if());
    }

    public static Color fromArgb(int a, int r, int g, int b) {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.lI(a, r, g, b).l12if());
    }

    public static Color fromRgb(double r, double g, double b) {
        return new Color(new double[]{r, g, b});
    }

    public static Color fromGray(double g) {
        return new Color(new double[]{g});
    }

    public static Color fromCmyk(double c, double m, double y, double k) {
        return new Color(new double[]{c, m, y, k});
    }

    public int hashCode() {
        return super.hashCode();
    }

    boolean lI(Color color) {
        boolean bl = true;
        for (int i = 0; i < color.getData().length; ++i) {
            bl &= ld.lI(color.getData()[i], this.getData()[i]);
        }
        return bl;
    }

    public boolean equals(Object obj) {
        Color color;
        if (obj == null) {
            return false;
        }
        if (com.aspose.pdf.internal.l90y.lb.lf(obj, Color.class)) {
            color = (Color)obj;
        } else {
            int n = 0;
            int[] nArray = new int[]{0};
            boolean bl = l6u.lI(obj.toString(), nArray);
            n = nArray[0];
            if (bl) {
                color = Color.fromArgb(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
            } else {
                return false;
            }
        }
        if (this.lj != color.lj || this.getData() == null || color.getData().length != this.getData().length) {
            return false;
        }
        return this.lI(color);
    }

    public static boolean op_Equality(Color x, Color y) {
        if (l8t.lf(x, y)) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public static boolean op_Inequality(Color x, Color y) {
        return !Color.op_Equality(x, y);
    }

    public PatternColorSpace getPatternColorSpace() {
        return this.lb;
    }

    public void setPatternColorSpace(PatternColorSpace value) {
        this.lb = value;
    }

    public static Color getTransparent() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l0v().l12if());
    }

    public static Color getAliceBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l0p().l12if());
    }

    public static Color getAntiqueWhite() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l0u().l12if());
    }

    public static Color getAqua() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l0j().l12if());
    }

    public static Color getAquamarine() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l0h().l12if());
    }

    public static Color getAzure() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l0y().l12if());
    }

    public static Color getBeige() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l0n().l12if());
    }

    public static Color getBisque() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l0k().l12if());
    }

    public static Color getBlack() {
        return Color.fromRgb(com.aspose.pdf.internal.l68j.ld.l0f().l12if().lI());
    }

    public static Color getBlanchedAlmond() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1if().l12if());
    }

    public static Color getBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1l().l12if());
    }

    public static Color getBlueViolet() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1t().l12if());
    }

    public static Color getBrown() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1v().l12if());
    }

    public static Color getBurlyWood() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1p().l12if());
    }

    public static Color getCadetBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1u().l12if());
    }

    public static Color getChartreuse() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1j().l12if());
    }

    public static Color getChocolate() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1h().l12if());
    }

    public static Color getCoral() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1y().l12if());
    }

    public static Color getCornflowerBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1n().l12if());
    }

    public static Color getCornsilk() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1k().l12if());
    }

    public static Color getCrimson() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l1f().l12if());
    }

    public static Color getCyan() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2if().l12if());
    }

    public static Color getDarkBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2l().l12if());
    }

    public static Color getDarkCyan() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2t().l12if());
    }

    public static Color getDarkGoldenrod() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2v().l12if());
    }

    public static Color getDarkGray() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2p().l12if());
    }

    public static Color getDarkGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2u().l12if());
    }

    public static Color getDarkKhaki() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2j().l12if());
    }

    public static Color getDarkMagenta() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2h().l12if());
    }

    public static Color getDarkOliveGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2y().l12if());
    }

    public static Color getDarkOrange() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2n().l12if());
    }

    public static Color getDarkOrchid() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2k().l12if());
    }

    public static Color getDarkRed() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l2f().l12if());
    }

    public static Color getDarkSalmon() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3if().l12if());
    }

    public static Color getDarkSeaGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3l().l12if());
    }

    public static Color getDarkSlateBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3t().l12if());
    }

    public static Color getDarkSlateGray() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3v().l12if());
    }

    public static Color getDarkTurquoise() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3p().l12if());
    }

    public static Color getDarkViolet() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3u().l12if());
    }

    public static Color getDeepPink() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3j().l12if());
    }

    public static Color getDeepSkyBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3h().l12if());
    }

    public static Color getDimGray() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3y().l12if());
    }

    public static Color getDodgerBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3n().l12if());
    }

    public static Color getFirebrick() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3k().l12if());
    }

    public static Color getFloralWhite() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l3f().l12if());
    }

    public static Color getForestGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4if().l12if());
    }

    public static Color getFuchsia() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4l().l12if());
    }

    public static Color getGainsboro() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4t().l12if());
    }

    public static Color getGhostWhite() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4v().l12if());
    }

    public static Color getGold() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4p().l12if());
    }

    public static Color getGoldenrod() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4u().l12if());
    }

    public static Color getGray() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4j().l12if());
    }

    public static Color getGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4h().l12if());
    }

    public static Color getGreenYellow() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4y().l12if());
    }

    public static Color getHoneydew() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4n().l12if());
    }

    public static Color getHotPink() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4k().l12if());
    }

    public static Color getIndianRed() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l4f().l12if());
    }

    public static Color getIndigo() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5if().l12if());
    }

    public static Color getIvory() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5l().l12if());
    }

    public static Color getKhaki() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5t().l12if());
    }

    public static Color getLavender() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5v().l12if());
    }

    public static Color getLavenderBlush() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5p().l12if());
    }

    public static Color getLawnGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5u().l12if());
    }

    public static Color getLemonChiffon() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5j().l12if());
    }

    public static Color getLightBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5h().l12if());
    }

    public static Color getLightCoral() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5y().l12if());
    }

    public static Color getLightCyan() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5n().l12if());
    }

    public static Color getLightGoldenrodYellow() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5k().l12if());
    }

    public static Color getLightGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l5f().l12if());
    }

    public static Color getLightGray() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6if().l12if());
    }

    public static Color getLightPink() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6l().l12if());
    }

    public static Color getLightSalmon() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6t().l12if());
    }

    public static Color getLightSeaGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6v().l12if());
    }

    public static Color getLightSkyBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6p().l12if());
    }

    public static Color getLightSlateGray() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6u().l12if());
    }

    public static Color getLightSteelBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6j().l12if());
    }

    public static Color getLightYellow() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6h().l12if());
    }

    public static Color getLime() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6y().l12if());
    }

    public static Color getLimeGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6n().l12if());
    }

    public static Color getLinen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6k().l12if());
    }

    public static Color getMagenta() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l6f().l12if());
    }

    public static Color getMaroon() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7if().l12if());
    }

    public static Color getMediumAquamarine() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7l().l12if());
    }

    public static Color getMediumBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7t().l12if());
    }

    public static Color getMediumOrchid() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7v().l12if());
    }

    public static Color getMediumPurple() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7p().l12if());
    }

    public static Color getMediumSeaGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7u().l12if());
    }

    public static Color getMediumSlateBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7j().l12if());
    }

    public static Color getMediumSpringGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7h().l12if());
    }

    public static Color getMediumTurquoise() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7y().l12if());
    }

    public static Color getMediumVioletRed() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7n().l12if());
    }

    public static Color getMidnightBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7k().l12if());
    }

    public static Color getMintCream() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l7f().l12if());
    }

    public static Color getMistyRose() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8if().l12if());
    }

    public static Color getMoccasin() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8l().l12if());
    }

    public static Color getNavajoWhite() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8t().l12if());
    }

    public static Color getNavy() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8v().l12if());
    }

    public static Color getOldLace() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8p().l12if());
    }

    public static Color getOlive() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8u().l12if());
    }

    public static Color getOliveDrab() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8j().l12if());
    }

    public static Color getOrange() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8h().l12if());
    }

    public static Color getOrangeRed() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8y().l12if());
    }

    public static Color getOrchid() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8n().l12if());
    }

    public static Color getPaleGoldenrod() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8k().l12if());
    }

    public static Color getPaleGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l8f().l12if());
    }

    public static Color getPaleTurquoise() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9if().l12if());
    }

    public static Color getPaleVioletRed() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9l().l12if());
    }

    public static Color getPapayaWhip() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9t().l12if());
    }

    public static Color getPeachPuff() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9v().l12if());
    }

    public static Color getPeru() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9p().l12if());
    }

    public static Color getPink() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9u().l12if());
    }

    public static Color getPlum() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9j().l12if());
    }

    public static Color getPowderBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9h().l12if());
    }

    public static Color getPurple() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9y().l12if());
    }

    public static Color getRed() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9n().l12if());
    }

    public static Color getRosyBrown() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9k().l12if());
    }

    public static Color getRoyalBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l9f().l12if());
    }

    public static Color getSaddleBrown() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10if().l12if());
    }

    public static Color getSalmon() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10l().l12if());
    }

    public static Color getSandyBrown() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10t().l12if());
    }

    public static Color getSeaGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10v().l12if());
    }

    public static Color getSeaShell() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10p().l12if());
    }

    public static Color getSienna() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10u().l12if());
    }

    public static Color getSilver() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10j().l12if());
    }

    public static Color getSkyBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10h().l12if());
    }

    public static Color getSlateBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10y().l12if());
    }

    public static Color getSlateGray() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10n().l12if());
    }

    public static Color getSnow() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10k().l12if());
    }

    public static Color getSpringGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l10f().l12if());
    }

    public static Color getSteelBlue() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11if().l12if());
    }

    public static Color getTan() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11l().l12if());
    }

    public static Color getTeal() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11t().l12if());
    }

    public static Color getThistle() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11v().l12if());
    }

    public static Color getTomato() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11p().l12if());
    }

    public static Color getTurquoise() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11u().l12if());
    }

    public static Color getViolet() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11j().l12if());
    }

    public static Color getWheat() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11h().l12if());
    }

    public static Color getWhite() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11y().l12if());
    }

    public static Color getWhiteSmoke() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11n().l12if());
    }

    public static Color getYellow() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11k().l12if());
    }

    public static Color getYellowGreen() {
        return Color.lI(com.aspose.pdf.internal.l68j.ld.l11f().l12if());
    }

    static {
        lI.setUseParentHandlers(false);
        Empty = new Color(new double[]{0.0, 0.0, 0.0}, true, 1.0);
    }
}

