/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z172;
import com.aspose.pdf.internal.ms.System.z9;
import com.aspose.pdf.internal.p71.z16;
import com.aspose.pdf.internal.p71.z21;
import com.aspose.pdf.internal.p71.z23;
import com.aspose.pdf.internal.p71.z30;
import com.aspose.pdf.internal.p881.z5;

public final class Matrix {
    private double[] m1;

    public double getA() {
        return this.m1[0];
    }

    public void setA(double value) {
        this.m1[0] = value;
    }

    public double getB() {
        return this.m1[1];
    }

    public void setB(double value) {
        this.m1[1] = value;
    }

    public double getC() {
        return this.m1[2];
    }

    public void setC(double value) {
        this.m1[2] = value;
    }

    public double getD() {
        return this.m1[3];
    }

    public void setD(double value) {
        this.m1[3] = value;
    }

    public double getE() {
        return this.m1[4];
    }

    public void setE(double value) {
        this.m1[4] = value;
    }

    public double getF() {
        return this.m1[5];
    }

    public void setF(double value) {
        this.m1[5] = value;
    }

    public Matrix() {
        this.m1 = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    }

    public Matrix(double[] matrixArray) {
        if (matrixArray.length != 6) {
            throw new z9();
        }
        this.m1 = matrixArray;
    }

    public Matrix(float[] matrixArray) {
        if (matrixArray.length != 6) {
            throw new z9();
        }
        this.m1 = new double[6];
        for (int i = 0; i < 6; ++i) {
            this.m1[i] = matrixArray[i];
        }
    }

    public Matrix(Matrix matrix) {
        this.m1 = matrix.m1;
    }

    public float[] getElements() {
        return new float[]{(float)this.m1[0], (float)this.m1[1], (float)this.m1[2], (float)this.m1[3], (float)this.m1[4], (float)this.m1[5]};
    }

    public String toString() {
        return z133.m1("[ {0}, {1}, {2}, {3}, {4}, {5} ]", this.getA(), this.getB(), this.getC(), this.getD(), this.getE(), this.getF());
    }

    public boolean equals(Object obj) {
        Matrix matrix = (Matrix)((Object)z5.m1(obj, Matrix.class));
        if (matrix != null) {
            return Double.compare(matrix.getA(), this.getA()) == 0 && Double.compare(matrix.getB(), this.getB()) == 0 && Double.compare(matrix.getC(), this.getC()) == 0 && Double.compare(matrix.getD(), this.getD()) == 0 && Double.compare(matrix.getE(), this.getE()) == 0 && Double.compare(matrix.getF(), this.getF()) == 0;
        }
        return super.equals(obj);
    }

    public com.aspose.pdf.internal.p71.z5 getMatrix(z21 trailer) {
        z23 z2310 = new z23(trailer);
        z2310.m1((z16)new z30(this.getA()));
        z2310.m1((z16)new z30(this.getB()));
        z2310.m1((z16)new z30(this.getC()));
        z2310.m1((z16)new z30(this.getD()));
        z2310.m1((z16)new z30(this.getE()));
        z2310.m1((z16)new z30(this.getF()));
        return z2310;
    }

    public static Matrix rotation(double alpha) {
        return new Matrix(new double[]{z172.m8(alpha), z172.m7(alpha), -z172.m7(alpha), z172.m8(alpha), 0.0, 0.0});
    }

    public static Matrix skew(double alpha, double beta) {
        return new Matrix(new double[]{1.0, z172.m9(alpha), z172.m9(alpha), 1.0, 0.0, 0.0});
    }

    public static Matrix scale(double x, double y) {
        return new Matrix(new double[]{x, 0.0, 0.0, y, 0.0, 0.0});
    }

    public static double getAngle(int rotation) {
        double d = 0.0;
        switch (rotation) {
            case 1: {
                d = 1.5707963267948966;
                break;
            }
            case 2: {
                d = Math.PI;
                break;
            }
            case 3: {
                d = 4.71238898038469;
            }
        }
        return d;
    }

    private double[] m1() {
        double[] dArray = new double[]{this.getA(), this.getB(), 0.0, this.getC(), this.getD(), 0.0, this.getE(), this.getF(), 1.0};
        return dArray;
    }

    public Matrix multiply(Matrix other) {
        double[] dArray = this.m1();
        double[] dArray2 = other.m1();
        double[] dArray3 = new double[9];
        int n = 3;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += dArray[i * n + k] * dArray2[k * n + j];
                }
                dArray3[i * n + j] = d;
            }
        }
        return new Matrix(new double[]{dArray3[0], dArray3[1], dArray3[3], dArray3[4], dArray3[6], dArray3[7]});
    }

    public Matrix add(Matrix other) {
        return new Matrix(this.getA() + other.getA(), this.getB() + other.getB(), this.getC() + other.getC(), this.getD() + other.getD(), this.getE() + other.getE(), this.getF() + other.getF());
    }

    public Point transform(Point p) {
        return new Point(p.getX() * this.getA() + p.getY() * this.getC() + this.getE(), p.getX() * this.getB() + p.getY() * this.getD() + this.getF());
    }

    public Rectangle transform(Rectangle rect) {
        Point[] pointArray = new Point[]{new Point(rect.getLLX(), rect.getLLY()), new Point(rect.getLLX(), rect.getURY()), new Point(rect.getURX(), rect.getLLY()), new Point(rect.getURX(), rect.getURY())};
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < pointArray.length; ++i) {
            Point point = this.transform(pointArray[i]);
            if (i == 0) {
                d = d2 = point.getX();
                d3 = d4 = point.getY();
                continue;
            }
            d = z172.m4(d, point.getX());
            d2 = z172.m3(d2, point.getX());
            d3 = z172.m4(d3, point.getY());
            d4 = z172.m3(d4, point.getY());
        }
        return new Rectangle(d, d3, d2, d4);
    }

    public Matrix(double a, double b, double c, double d, double e, double f) {
        this(new double[]{a, b, c, d, e, f});
    }

    public Matrix reverse() {
        double d = this.getA() * this.getD() - this.getC() * this.getB();
        return new Matrix(this.getD() / d, -this.getB() / d, -this.getC() / d, this.getA() / d, (this.getC() * this.getF() - this.getE() * this.getD()) / d, -(this.getA() * this.getF() - this.getE() * this.getB()) / d);
    }

    public int hashCode() {
        return super.hashCode();
    }

    com.aspose.pdf.internal.p71.z5 m1(z21 z2110) {
        z16[] z16Array = new z16[this.m1.length];
        for (int i = 0; i < this.m1.length; ++i) {
            z16Array[i] = new z30(this.m1[i]);
        }
        z23 z2310 = new z23(z2110, z16Array);
        return z2310;
    }

    Matrix(com.aspose.pdf.internal.p71.z5 data) {
        if (data.m10() != 6) {
            throw new z9("Matrix array must have 6 elements");
        }
        this.m1 = new double[6];
        for (int i = 1; i <= 6; ++i) {
            if (data.m1(i).m70() == null) {
                throw new z9("Matrix array must contain only numbers");
            }
            this.m1[i - 1] = data.m1(i).m70().m8();
        }
    }
}

