/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import com.aspose.ocr.DetectAreasMode;
import com.aspose.ocr.Format;
import com.aspose.ocr.Language;
import com.aspose.ocr.Logging;
import com.aspose.ocr.RecognitionSettings;
import com.aspose.ocr.SpellCheck.SpellCheckError;
import com.aspose.ocr.SpellCheck.SpellCheckLanguage;
import com.aspose.ocr.c;
import com.aspose.ocr.e0cd0c6d15;
import com.aspose.ocr.e0cd0c7d77;
import com.aspose.ocr.o;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RecognitionResult {
    public ArrayList<String> recognitionAreasText;
    public ArrayList<LinesResult> recognitionLinesResult;
    public String recognitionText = "";
    public ArrayList<Rectangle> recognitionAreasRectangles;
    public ArrayList<char[]> recognitionCharactersList;
    public double skew = 0.0;
    public ArrayList<String> warnings;
    BufferedImage f = null;
    DetectAreasMode c0ad = DetectAreasMode.DOCUMENT;

    public String GetJson() {
        e0cd0c7d77 e0cd0c7d772 = e0cd0c7d77.f();
        e0cd0c6d15.f(e0cd0c7d772, this);
        try {
            return e0cd0c7d772.c0ad();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String GetXml() {
        String string = "";
        try {
            StringWriter stringWriter = new StringWriter();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("totalResult");
            document.appendChild(element);
            e0cd0c6d15.f(document, element, this);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            string = stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            System.out.println("Error outputting document");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Error building document");
        }
        return string;
    }

    public void save(String string) {
        ArrayList<RecognitionResult> arrayList = new ArrayList<RecognitionResult>();
        arrayList.add(this);
        RecognitionResult.f(string, Format.Text, arrayList);
    }

    public void save(String string, Format format) {
        ArrayList<RecognitionResult> arrayList = new ArrayList<RecognitionResult>();
        arrayList.add(this);
        RecognitionResult.f(string, format, arrayList);
    }

    public void saveSpellCheckCorrectedText(String string, Format format, SpellCheckLanguage spellCheckLanguage) {
        ArrayList<RecognitionResult> arrayList = new ArrayList<RecognitionResult>();
        arrayList.add(this.f(spellCheckLanguage));
        RecognitionResult.f(string, format, arrayList);
    }

    public void saveSpellCheckCorrectedText(String string, Format format) {
        ArrayList<RecognitionResult> arrayList = new ArrayList<RecognitionResult>();
        arrayList.add(this.f());
        RecognitionResult.f(string, format, arrayList);
    }

    public String getSpellCheckCorrectedText(SpellCheckLanguage spellCheckLanguage) {
        return o.f(this.recognitionText, spellCheckLanguage);
    }

    public String getSpellCheckCorrectedText() {
        return o.c0ad(this.recognitionText);
    }

    public List<SpellCheckError> getSpellCheckErrorList(SpellCheckLanguage spellCheckLanguage) {
        return o.c0ad(this.recognitionText, spellCheckLanguage);
    }

    public List<SpellCheckError> getSpellCheckErrorList() {
        return o.edf(this.recognitionText);
    }

    public void useUserDictionary(String string) {
        o.f(string);
    }

    public RecognitionResult() {
        this.recognitionAreasText = new ArrayList();
        this.recognitionAreasRectangles = new ArrayList();
        this.warnings = new ArrayList();
        this.recognitionCharactersList = new ArrayList();
        this.recognitionLinesResult = new ArrayList();
    }

    RecognitionResult f(SpellCheckLanguage spellCheckLanguage) {
        RecognitionResult recognitionResult = this;
        for (int i2 = 0; i2 < recognitionResult.recognitionLinesResult.size(); ++i2) {
            String string = recognitionResult.recognitionLinesResult.get((int)i2).textInLine;
            recognitionResult.recognitionLinesResult.get((int)i2).textInLine = o.f(string, spellCheckLanguage);
        }
        return recognitionResult;
    }

    RecognitionResult f() {
        RecognitionResult recognitionResult = this;
        for (int i2 = 0; i2 < recognitionResult.recognitionLinesResult.size(); ++i2) {
            String string = recognitionResult.recognitionLinesResult.get((int)i2).textInLine;
            recognitionResult.recognitionLinesResult.get((int)i2).textInLine = o.c0ad(string);
        }
        return recognitionResult;
    }

    void f(RecognitionSettings recognitionSettings, boolean bl) {
        if (recognitionSettings == null) {
            return;
        }
        if (bl && recognitionSettings.f() != null && recognitionSettings.f().size() != 0 || recognitionSettings.e0cd0c6d17() || recognitionSettings.e0cd0c6d16() != 0.0) {
            Logging.f(c.e0cd0c6d11, "");
            this.warnings.add("Only DetectAreas and AutoSkew options will aplly");
        }
        if (recognitionSettings.f() != null && recognitionSettings.f().size() != 0 && (recognitionSettings.c0ad() || recognitionSettings.ac8a() || recognitionSettings.e0cd0c6d17() || recognitionSettings.e0cd0c6d16() != 0.0)) {
            Logging.f(c.edf, String.valueOf(recognitionSettings.c0ad()));
            this.warnings.add("Setting areas for recognition manually will disable Skew, DetectAreas, AutoSkew and RecognizeSingleLine options");
        } else {
            if (recognitionSettings.e0cd0c6d16() != 0.0 && recognitionSettings.ac8a()) {
                Logging.f(c.e0cd0c6d18, "");
                this.warnings.add("Setting skew value will disable AutoSkew");
            }
            if (recognitionSettings.e0cd0c6d17()) {
                Logging.f(c.e0cd0c6d19, "");
                this.warnings.add("Setting single line recognition will disable DetectAreas and AutoSkew");
            }
        }
        this.f(recognitionSettings);
    }

    void f(RecognitionSettings recognitionSettings) {
        if ((recognitionSettings.e0cd0c6d33() == DetectAreasMode.PHOTO || recognitionSettings.e0cd0c6d33() == DetectAreasMode.TABLE) && recognitionSettings.e0cd0c6d18() == Language.Chi) {
            Logging.f(c.ac8a, "");
            this.warnings.add("PHOTO and TABLE area recognition mode is not adapted to Chinese language. Use DOCUMENT mode better");
        }
    }

    void f(boolean bl) {
        if (bl) {
            Logging.f(c.e0cd0c6d16, String.valueOf(20));
            this.warnings.add("Only 20 images will be processed by text recognition");
        }
    }

    static void f(String string, Format format, ArrayList<RecognitionResult> arrayList) {
        try {
            switch (format) {
                case Docx: {
                    e0cd0c6d15.ac8a(arrayList, string);
                    break;
                }
                case Pdf: {
                    e0cd0c6d15.e0cd0c6d16(arrayList, string);
                    break;
                }
                case Xlsx: {
                    e0cd0c6d15.e0cd0c6d17(arrayList, string);
                    break;
                }
                case Xml: {
                    e0cd0c6d15.edf(arrayList, string);
                    break;
                }
                case Json: {
                    e0cd0c6d15.c0ad(arrayList, string);
                    break;
                }
                case Html: {
                    e0cd0c6d15.e0cd0c6d19(arrayList, string);
                    break;
                }
                case Epub: {
                    e0cd0c6d15.e0cd0c6d11(arrayList, string);
                    break;
                }
                case Rtf: {
                    e0cd0c6d15.e0cd0c6d18(arrayList, string);
                    break;
                }
                default: {
                    e0cd0c6d15.f(arrayList, string);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't create document");
        }
    }

    public RecognitionResult add(RecognitionResult recognitionResult) {
        this.recognitionAreasRectangles.addAll(recognitionResult.recognitionAreasRectangles);
        this.recognitionAreasText.addAll(recognitionResult.recognitionAreasText);
        this.recognitionCharactersList.addAll(recognitionResult.recognitionCharactersList);
        this.recognitionLinesResult.addAll(recognitionResult.recognitionLinesResult);
        this.recognitionText = this.recognitionText + recognitionResult.recognitionText;
        this.skew = recognitionResult.skew;
        this.warnings = recognitionResult.warnings;
        this.f = recognitionResult.f;
        this.c0ad = recognitionResult.c0ad;
        return this;
    }

    public class LinesResult {
        public String textInLine;
        public Rectangle line;
        Rectangle f;
    }
}

