/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import com.aspose.ocr.AreasType;
import com.aspose.ocr.CarPlateRecognitionSettings;
import com.aspose.ocr.DocumentRecognitionSettings;
import com.aspose.ocr.Format;
import com.aspose.ocr.IDCardRecognitionSettings;
import com.aspose.ocr.InvoiceRecognitionSettings;
import com.aspose.ocr.License;
import com.aspose.ocr.Logging;
import com.aspose.ocr.PassportRecognitionSettings;
import com.aspose.ocr.PreprocessingFilter;
import com.aspose.ocr.ReceiptRecognitionSettings;
import com.aspose.ocr.RecognitionResult;
import com.aspose.ocr.RecognitionSettings;
import com.aspose.ocr.SpellCheck.SpellCheckLanguage;
import com.aspose.ocr.a;
import com.aspose.ocr.al;
import com.aspose.ocr.an;
import com.aspose.ocr.b;
import com.aspose.ocr.e0cd0c5d77;
import com.aspose.ocr.e0cd0c6d16;
import com.aspose.ocr.i;
import com.aspose.ocr.metered.MeteredHelper;
import com.aspose.ocr.o;
import com.aspose.ocr.p;
import com.aspose.ocr.pdf.AsposeOCRPdf;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class AsposeOCR {
    public AsposeOCR() {
    }

    public AsposeOCR(String string) {
        i.c0ad = string + e0cd0c6d16.c0ad;
    }

    public double CalcSkewImage(String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        return this.CalcSkewImage(bufferedImage);
    }

    public double CalcSkewImage(BufferedImage bufferedImage) throws IOException {
        i i2 = new i();
        bufferedImage = i2.f(bufferedImage, new RecognitionSettings());
        return e0cd0c5d77.edf(bufferedImage, 0);
    }

    public double CalcSkewImageFromUri(String string) throws IOException {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        return this.CalcSkewImage(bufferedImage);
    }

    public BufferedImage PreprocessImage(String string, PreprocessingFilter preprocessingFilter) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(string));
        }
        catch (IOException iOException) {
            Logging.f(b.c0ad);
            iOException.printStackTrace();
        }
        Logging.c0ad(a.edf);
        for (PreprocessingFilter preprocessingFilter2 : preprocessingFilter.f) {
            bufferedImage = preprocessingFilter2.f(bufferedImage);
        }
        Logging.edf(a.edf);
        MeteredHelper.count(bufferedImage);
        return bufferedImage;
    }

    public BufferedImage PreprocessImage(BufferedImage bufferedImage, PreprocessingFilter preprocessingFilter) {
        BufferedImage bufferedImage2 = e0cd0c5d77.f(bufferedImage);
        Logging.c0ad(a.edf);
        for (PreprocessingFilter preprocessingFilter2 : preprocessingFilter.f) {
            bufferedImage2 = preprocessingFilter2.f(bufferedImage2);
        }
        Logging.edf(a.edf);
        MeteredHelper.count(bufferedImage2);
        return bufferedImage2;
    }

    public ArrayList<RecognitionResult> RecognizeTiff(String string, DocumentRecognitionSettings documentRecognitionSettings) throws Exception {
        ArrayList<RecognitionResult> arrayList = new ArrayList<RecognitionResult>();
        RecognitionSettings recognitionSettings = new RecognitionSettings(documentRecognitionSettings);
        Logging.c0ad(a.c0ad);
        ArrayList<BufferedImage> arrayList2 = al.f(string, documentRecognitionSettings.getStartPage(), documentRecognitionSettings.getPagesNumber());
        Logging.edf(a.c0ad);
        try {
            boolean bl = false;
            for (BufferedImage bufferedImage : arrayList2) {
                arrayList.add(this.RecognizePage(bufferedImage, recognitionSettings));
            }
        }
        catch (Exception exception) {
            Logging.f(b.edf);
            throw new Exception("Error loading TIFF image. Visit our forum to leave a comment https://forum.aspose.com/c/ocr/16");
        }
        return arrayList;
    }

    public ArrayList<RecognitionResult> RecognizePdf(String string, DocumentRecognitionSettings documentRecognitionSettings) {
        AsposeOCRPdf asposeOCRPdf = new AsposeOCRPdf();
        ArrayList<RecognitionResult> arrayList = asposeOCRPdf.RecognizePdf(string, documentRecognitionSettings);
        if (arrayList == null) {
            Logging.f(b.ac8a);
        }
        return arrayList;
    }

    public String RecognizePageFast(String string) throws IOException {
        i i2 = new i();
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        i2.f(bufferedImage, (RecognitionSettings)null);
        String string2 = i2.c0ad();
        if (string2 != null && !string2.isEmpty()) {
            MeteredHelper.count(bufferedImage);
        }
        i2.edf();
        return string2;
    }

    public String RecognizePage(String string) throws IOException {
        return this.RecognizePage(string, true);
    }

    public String RecognizePage(String string, boolean bl) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        return this.RecognizePage(bufferedImage, bl);
    }

    public String RecognizePage(String string, ArrayList<Rectangle> arrayList) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        return this.RecognizePage(bufferedImage, arrayList);
    }

    public RecognitionResult RecognizePage(String string, RecognitionSettings recognitionSettings) throws IOException {
        i i2 = new i();
        i2.ac8a(recognitionSettings);
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        i2.f(bufferedImage, recognitionSettings);
        RecognitionResult recognitionResult = i2.f(recognitionSettings);
        recognitionResult.f(recognitionSettings, false);
        i2.edf();
        if (recognitionResult != null && !recognitionResult.recognitionText.isEmpty()) {
            MeteredHelper.count(bufferedImage);
        }
        recognitionResult.f = bufferedImage;
        return recognitionResult;
    }

    public RecognitionResult RecognizeReceipt(String string, ReceiptRecognitionSettings receiptRecognitionSettings) throws IOException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(receiptRecognitionSettings);
        RecognitionResult recognitionResult = this.RecognizePage(string, recognitionSettings);
        recognitionResult.recognitionLinesResult = i.f(recognitionResult.recognitionLinesResult);
        recognitionResult.recognitionText = "";
        recognitionResult.recognitionAreasRectangles.clear();
        recognitionResult.recognitionAreasText.clear();
        for (RecognitionResult.LinesResult linesResult : recognitionResult.recognitionLinesResult) {
            recognitionResult.recognitionText = recognitionResult.recognitionText + linesResult.textInLine + "\n";
            recognitionResult.recognitionAreasRectangles.add(linesResult.line);
            recognitionResult.recognitionAreasText.add(linesResult.textInLine);
        }
        if (!License.isValid()) {
            an.f(recognitionResult);
        }
        return recognitionResult;
    }

    public RecognitionResult RecognizeInvoice(String string, InvoiceRecognitionSettings invoiceRecognitionSettings) throws IOException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(invoiceRecognitionSettings);
        RecognitionResult recognitionResult = this.RecognizePage(string, recognitionSettings);
        recognitionResult.recognitionLinesResult = i.f(recognitionResult.recognitionLinesResult);
        recognitionResult.recognitionText = "";
        recognitionResult.recognitionAreasRectangles.clear();
        recognitionResult.recognitionAreasText.clear();
        for (RecognitionResult.LinesResult linesResult : recognitionResult.recognitionLinesResult) {
            recognitionResult.recognitionText = recognitionResult.recognitionText + linesResult.textInLine + "\n";
            recognitionResult.recognitionAreasRectangles.add(linesResult.line);
            recognitionResult.recognitionAreasText.add(linesResult.textInLine);
        }
        if (!License.isValid()) {
            an.f(recognitionResult);
        }
        return recognitionResult;
    }

    public RecognitionResult RecognizeIDCard(String string, IDCardRecognitionSettings iDCardRecognitionSettings) throws IOException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(iDCardRecognitionSettings);
        PreprocessingFilter preprocessingFilter = new PreprocessingFilter();
        preprocessingFilter.add(PreprocessingFilter.Scale(2.0f));
        recognitionSettings.setPreprocessingFilters(preprocessingFilter);
        RecognitionResult recognitionResult = this.RecognizePage(string, recognitionSettings);
        return recognitionResult;
    }

    public RecognitionResult RecognizeCarPlate(String string, CarPlateRecognitionSettings carPlateRecognitionSettings) throws IOException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(carPlateRecognitionSettings);
        i i2 = new i();
        i2.ac8a(recognitionSettings);
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        i2.f(bufferedImage, recognitionSettings);
        RecognitionResult recognitionResult = i2.c0ad(recognitionSettings);
        recognitionResult.f(recognitionSettings, false);
        i2.edf();
        if (recognitionResult != null && !recognitionResult.recognitionText.isEmpty()) {
            MeteredHelper.count(bufferedImage);
        }
        recognitionResult.f = bufferedImage;
        return recognitionResult;
    }

    public RecognitionResult RecognizePassport(String string, PassportRecognitionSettings passportRecognitionSettings) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        RecognitionSettings recognitionSettings = new RecognitionSettings(passportRecognitionSettings);
        PreprocessingFilter preprocessingFilter = new PreprocessingFilter();
        preprocessingFilter.add(PreprocessingFilter.Scale(2.0f));
        recognitionSettings.setPreprocessingFilters(preprocessingFilter);
        RecognitionResult recognitionResult = this.RecognizePage(bufferedImage, recognitionSettings);
        return recognitionResult;
    }

    public String RecognizeLine(String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        return this.RecognizeLine(bufferedImage);
    }

    public String RecognizePage(BufferedImage bufferedImage) throws IOException {
        return this.RecognizePage(bufferedImage, true);
    }

    public String RecognizePage(BufferedImage bufferedImage, boolean bl) throws IOException {
        RecognitionSettings recognitionSettings = new RecognitionSettings();
        recognitionSettings.setAutoSkew(bl);
        return this.RecognizePage((BufferedImage)bufferedImage, (RecognitionSettings)recognitionSettings).recognitionText;
    }

    public String RecognizePage(BufferedImage bufferedImage, ArrayList<Rectangle> arrayList) throws IOException {
        i i2 = new i();
        RecognitionSettings recognitionSettings = new RecognitionSettings();
        recognitionSettings.setRecognitionAreas(arrayList);
        i2.f(bufferedImage, new RecognitionSettings());
        RecognitionResult recognitionResult = i2.f(recognitionSettings);
        i2.edf();
        if (recognitionResult != null) {
            if (!recognitionResult.recognitionText.isEmpty()) {
                MeteredHelper.count(bufferedImage);
            }
            return recognitionResult.recognitionText;
        }
        return "";
    }

    public RecognitionResult RecognizePage(BufferedImage bufferedImage, RecognitionSettings recognitionSettings) throws IOException {
        i i2 = new i();
        i2.ac8a(recognitionSettings);
        i2.f(bufferedImage, recognitionSettings);
        RecognitionResult recognitionResult = i2.f(recognitionSettings);
        recognitionResult.f(recognitionSettings, false);
        i2.edf();
        if (recognitionResult != null && !recognitionResult.recognitionText.isEmpty()) {
            MeteredHelper.count(bufferedImage);
        }
        recognitionResult.f = bufferedImage;
        return recognitionResult;
    }

    public RecognitionResult RecognizeCarPlate(BufferedImage bufferedImage, CarPlateRecognitionSettings carPlateRecognitionSettings) throws IOException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(carPlateRecognitionSettings);
        i i2 = new i();
        i2.ac8a(recognitionSettings);
        i2.f(bufferedImage, recognitionSettings);
        RecognitionResult recognitionResult = i2.c0ad(recognitionSettings);
        recognitionResult.f(recognitionSettings, false);
        i2.edf();
        if (recognitionResult != null && !recognitionResult.recognitionText.isEmpty()) {
            MeteredHelper.count(bufferedImage);
        }
        recognitionResult.f = bufferedImage;
        return recognitionResult;
    }

    public RecognitionResult RecognizeIDCard(BufferedImage bufferedImage, IDCardRecognitionSettings iDCardRecognitionSettings) throws IOException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(iDCardRecognitionSettings);
        PreprocessingFilter preprocessingFilter = new PreprocessingFilter();
        preprocessingFilter.add(PreprocessingFilter.Scale(2.0f));
        preprocessingFilter.add(PreprocessingFilter.ContrastCorrection());
        recognitionSettings.setPreprocessingFilters(preprocessingFilter);
        RecognitionResult recognitionResult = this.RecognizePage(bufferedImage, recognitionSettings);
        return recognitionResult;
    }

    public RecognitionResult RecognizeInvoice(BufferedImage bufferedImage, InvoiceRecognitionSettings invoiceRecognitionSettings) throws IOException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(invoiceRecognitionSettings);
        RecognitionResult recognitionResult = this.RecognizePage(bufferedImage, recognitionSettings);
        recognitionResult.recognitionLinesResult = i.f(recognitionResult.recognitionLinesResult);
        recognitionResult.recognitionText = "";
        recognitionResult.recognitionAreasRectangles.clear();
        recognitionResult.recognitionAreasText.clear();
        for (RecognitionResult.LinesResult linesResult : recognitionResult.recognitionLinesResult) {
            recognitionResult.recognitionText = recognitionResult.recognitionText + linesResult.textInLine + "\n";
            recognitionResult.recognitionAreasRectangles.add(linesResult.line);
            recognitionResult.recognitionAreasText.add(linesResult.textInLine);
        }
        if (!License.isValid()) {
            an.f(recognitionResult);
        }
        return recognitionResult;
    }

    public RecognitionResult RecognizePassport(BufferedImage bufferedImage, PassportRecognitionSettings passportRecognitionSettings) throws IOException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(passportRecognitionSettings);
        PreprocessingFilter preprocessingFilter = new PreprocessingFilter();
        preprocessingFilter.add(PreprocessingFilter.Scale(2.0f));
        preprocessingFilter.add(PreprocessingFilter.ContrastCorrection());
        recognitionSettings.setPreprocessingFilters(preprocessingFilter);
        RecognitionResult recognitionResult = this.RecognizePage(bufferedImage, recognitionSettings);
        return recognitionResult;
    }

    public RecognitionResult RecognizeReceipt(BufferedImage bufferedImage, ReceiptRecognitionSettings receiptRecognitionSettings) throws IOException {
        RecognitionSettings recognitionSettings = new RecognitionSettings(receiptRecognitionSettings);
        RecognitionResult recognitionResult = this.RecognizePage(bufferedImage, recognitionSettings);
        recognitionResult.recognitionLinesResult = i.f(recognitionResult.recognitionLinesResult);
        recognitionResult.recognitionText = "";
        recognitionResult.recognitionAreasRectangles.clear();
        recognitionResult.recognitionAreasText.clear();
        for (RecognitionResult.LinesResult linesResult : recognitionResult.recognitionLinesResult) {
            recognitionResult.recognitionText = recognitionResult.recognitionText + linesResult.textInLine + "\n";
            recognitionResult.recognitionAreasRectangles.add(linesResult.line);
            recognitionResult.recognitionAreasText.add(linesResult.textInLine);
        }
        if (!License.isValid()) {
            an.f(recognitionResult);
        }
        return recognitionResult;
    }

    public ArrayList<RecognitionResult> RecognizeTiff(InputStream inputStream, DocumentRecognitionSettings documentRecognitionSettings) throws Exception {
        ArrayList<RecognitionResult> arrayList = new ArrayList<RecognitionResult>();
        RecognitionSettings recognitionSettings = new RecognitionSettings(documentRecognitionSettings);
        ArrayList<BufferedImage> arrayList2 = al.f(inputStream, documentRecognitionSettings.getStartPage(), documentRecognitionSettings.getPagesNumber());
        try {
            boolean bl = false;
            for (BufferedImage bufferedImage : arrayList2) {
                arrayList.add(this.RecognizePage(bufferedImage, recognitionSettings));
            }
        }
        catch (Exception exception) {
            Logging.f(b.edf);
            throw new Exception("Error loading TIFF image. Visit our forum to leave a comment https://forum.aspose.com/c/ocr/16");
        }
        return arrayList;
    }

    public ArrayList<RecognitionResult> RecognizePdf(InputStream inputStream, DocumentRecognitionSettings documentRecognitionSettings) {
        AsposeOCRPdf asposeOCRPdf = new AsposeOCRPdf();
        return asposeOCRPdf.RecognizePdf(inputStream, documentRecognitionSettings);
    }

    public String RecognizeLine(BufferedImage bufferedImage) {
        RecognitionSettings recognitionSettings = new RecognitionSettings();
        recognitionSettings.setRecognizeSingleLine(true);
        try {
            return this.RecognizePage((BufferedImage)bufferedImage, (RecognitionSettings)recognitionSettings).recognitionText;
        }
        catch (IOException iOException) {
            Logging.f(b.ac8a);
            return null;
        }
    }

    public ArrayList<RecognitionResult> RecognizeMultiplePages(String string, RecognitionSettings recognitionSettings) throws IOException {
        ArrayList<RecognitionResult> arrayList;
        File file = new File(string);
        if (string.endsWith(".zip")) {
            arrayList = new ArrayList<RecognitionResult>();
            int n2 = 0;
            boolean bl = false;
            try (ZipFile zipFile = new ZipFile(string);){
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (zipEntry.isDirectory()) continue;
                    if (n2 == 20) {
                        bl = true;
                        break;
                    }
                    BufferedImage object = ImageIO.read(zipFile.getInputStream(zipEntry));
                    RecognitionResult recognitionResult = this.RecognizePage(object, recognitionSettings);
                    recognitionResult.f = object;
                    arrayList.add(recognitionResult);
                    ++n2;
                }
                for (RecognitionResult recognitionResult : arrayList) {
                    recognitionResult.f(bl);
                }
            }
        } else if (file.isDirectory()) {
            File file2 = new File(string);
            File[] fileArray = file2.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                throw new FileNotFoundException();
            }
            arrayList = new ArrayList();
            for (int i2 = 0; i2 < fileArray.length && i2 < 20; ++i2) {
                if (!fileArray[i2].isFile()) continue;
                arrayList.add(this.RecognizePage(fileArray[i2].getCanonicalPath(), recognitionSettings));
            }
            for (RecognitionResult recognitionResult : arrayList) {
                recognitionResult.f(fileArray.length <= 20);
            }
        } else {
            Logging.f(b.e0cd0c6d13);
            throw new RuntimeException("Not correct path. The path must end with the name of the .zip archive or folder with images. Subfolders and nested archives are not supported");
        }
        return arrayList;
    }

    public ArrayList<RecognitionResult> RecognizeMultiplePages(ArrayList<String> arrayList, RecognitionSettings recognitionSettings) throws IOException {
        ArrayList<RecognitionResult> arrayList2 = new ArrayList<RecognitionResult>(arrayList.size());
        for (int i2 = 0; i2 < arrayList.size() && i2 < 20; ++i2) {
            File object = new File(arrayList.get(i2));
            if (!object.isFile()) continue;
            arrayList2.add(this.RecognizePage(object.getCanonicalPath(), recognitionSettings));
        }
        for (RecognitionResult recognitionResult : arrayList2) {
            recognitionResult.f(arrayList.size() >= 20);
        }
        return arrayList2;
    }

    public String RecognizePageFromUri(String string) throws IOException {
        return this.RecognizePageFromUri((String)string, (RecognitionSettings)new RecognitionSettings()).recognitionText;
    }

    public RecognitionResult RecognizePageFromUri(String string, RecognitionSettings recognitionSettings) throws IOException {
        Object object;
        i i2 = new i();
        i2.ac8a(recognitionSettings);
        BufferedImage bufferedImage = null;
        try {
            object = new URL(string);
            URLConnection uRLConnection = ((URL)object).openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (Exception exception) {
            Logging.f(b.edf);
            throw exception;
        }
        i2.f(bufferedImage, recognitionSettings);
        object = i2.f(recognitionSettings);
        ((RecognitionResult)object).f(recognitionSettings, false);
        i2.edf();
        if (object != null && !((RecognitionResult)object).recognitionText.isEmpty()) {
            MeteredHelper.count(bufferedImage);
        }
        ((RecognitionResult)object).f = bufferedImage;
        return object;
    }

    public RecognitionResult RecognizePage(int[] nArray, int n2, int n3, int n4, RecognitionSettings recognitionSettings) throws IOException {
        i i2 = new i();
        i2.ac8a(recognitionSettings);
        i2.f(nArray, n2, n3, n4, recognitionSettings);
        RecognitionResult recognitionResult = i2.f(recognitionSettings);
        recognitionResult.f(recognitionSettings, false);
        if (recognitionResult != null && !recognitionResult.recognitionText.isEmpty()) {
            MeteredHelper.count(i2.f());
        }
        recognitionResult.f = i2.f();
        i2.edf();
        return recognitionResult;
    }

    public boolean ImageHasText(String string, String string2, RecognitionSettings recognitionSettings, boolean bl) {
        i i2 = new i();
        String string3 = "";
        i2.ac8a(recognitionSettings);
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            i2.f(bufferedImage, recognitionSettings);
            RecognitionResult recognitionResult = i2.f(recognitionSettings);
            i2.edf();
            if (recognitionResult != null && !recognitionResult.recognitionText.isEmpty()) {
                MeteredHelper.count(bufferedImage);
            }
            string3 = bl ? recognitionResult.recognitionText.toLowerCase() : recognitionResult.recognitionText;
            string2 = bl ? string2.toLowerCase() : string2;
        }
        catch (IOException iOException) {
            Logging.f(b.ac8a);
            iOException.printStackTrace();
        }
        return string3.contains(string2);
    }

    public boolean ImageHasText(String string, String string2, RecognitionSettings recognitionSettings) {
        return this.ImageHasText(string, string2, recognitionSettings, true);
    }

    public boolean ImageHasText(String string, String string2) {
        return this.ImageHasText(string, string2, new RecognitionSettings(), true);
    }

    public boolean ImageHasText(String string, Pattern pattern, RecognitionSettings recognitionSettings) {
        Object object;
        i i2 = new i();
        String string2 = "";
        i2.ac8a(recognitionSettings);
        try {
            object = ImageIO.read(new File(string));
            i2.f((BufferedImage)object, recognitionSettings);
            RecognitionResult recognitionResult = i2.f(recognitionSettings);
            i2.edf();
            if (recognitionResult != null && !recognitionResult.recognitionText.isEmpty()) {
                MeteredHelper.count((BufferedImage)object);
            }
            string2 = recognitionResult.recognitionText;
        }
        catch (IOException iOException) {
            Logging.f(b.ac8a);
            iOException.printStackTrace();
        }
        object = pattern.matcher(string2);
        boolean bl = ((Matcher)object).find();
        return bl;
    }

    public boolean ImageHasText(String string, Pattern pattern) {
        return this.ImageHasText(string, pattern, new RecognitionSettings());
    }

    public boolean CompareImageTexts(String string, String string2, RecognitionSettings recognitionSettings, boolean bl) {
        float f2 = this.ImageTextDiff(string, string2, recognitionSettings, bl);
        return (double)f2 > 0.9;
    }

    public boolean CompareImageTexts(String string, String string2, RecognitionSettings recognitionSettings) {
        return this.CompareImageTexts(string, string2, recognitionSettings, true);
    }

    public boolean CompareImageTexts(String string, String string2) {
        return this.CompareImageTexts(string, string2, new RecognitionSettings(), true);
    }

    public float ImageTextDiff(String string, String string2, RecognitionSettings recognitionSettings, boolean bl) {
        i i2 = new i();
        String string3 = "";
        String string4 = "";
        i2.ac8a(recognitionSettings);
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            i2.f(bufferedImage, recognitionSettings);
            RecognitionResult recognitionResult = i2.f(recognitionSettings);
            i2.edf();
            string3 = bl ? recognitionResult.recognitionText.toLowerCase() : recognitionResult.recognitionText;
            bufferedImage = ImageIO.read(new File(string2));
            i2.f(bufferedImage, recognitionSettings);
            recognitionResult = i2.f(recognitionSettings);
            i2.edf();
            String string5 = string4 = bl ? recognitionResult.recognitionText.toLowerCase() : recognitionResult.recognitionText;
            if (recognitionResult != null && !recognitionResult.recognitionText.isEmpty()) {
                MeteredHelper.count(bufferedImage);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n2 = Math.max(string3.length(), string4.length());
        int n3 = p.f(string3, string4, n2);
        return 1.0f - (float)n3 / (float)n2;
    }

    public float ImageTextDiff(String string, String string2, RecognitionSettings recognitionSettings) {
        return this.ImageTextDiff(string, string2, recognitionSettings, true);
    }

    public float ImageTextDiff(String string, String string2) {
        return this.ImageTextDiff(string, string2, new RecognitionSettings(), true);
    }

    public ArrayList<Rectangle> getTextAreas(String string, AreasType areasType, boolean bl) throws IOException {
        i i2 = new i();
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        i2.f(bufferedImage, new RecognitionSettings());
        ArrayList<Rectangle> arrayList = i2.f(areasType, bl);
        if (arrayList != null && arrayList.size() != 0) {
            MeteredHelper.count(bufferedImage);
        }
        return arrayList;
    }

    public ArrayList<Rectangle> getTextAreas(BufferedImage bufferedImage, AreasType areasType, boolean bl) throws IOException {
        i i2 = new i();
        i2.f(bufferedImage, new RecognitionSettings());
        ArrayList<Rectangle> arrayList = i2.f(areasType, bl);
        if (arrayList != null && arrayList.size() != 0) {
            MeteredHelper.count(bufferedImage);
        }
        return arrayList;
    }

    public static void SaveMultipageDocument(String string, Format format, ArrayList<RecognitionResult> arrayList) {
        RecognitionResult.f(string, format, arrayList);
    }

    public String CorrectSpelling(String string, SpellCheckLanguage spellCheckLanguage) {
        return o.f(string, spellCheckLanguage);
    }

    public String CorrectSpelling(String string, SpellCheckLanguage spellCheckLanguage, String string2) {
        o.f(string2);
        return o.f(string, spellCheckLanguage);
    }
}

