/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import com.aspose.ocr.Format;
import com.aspose.ocr.RecognitionSettings;
import com.aspose.ocr.SpellCheck.SpellCheckError;
import com.aspose.ocr.SpellCheck.SpellCheckLanguage;
import com.aspose.ocr.e0cd0c4d77;
import com.aspose.ocr.e0cd0c6d13;
import com.aspose.ocr.e0cd0c6d17;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class RecognitionResult {
    public ArrayList<String> recognitionAreasText = new ArrayList();
    public ArrayList<LinesResult> recognitionLinesResult;
    public String recognitionText = "";
    public ArrayList<Rectangle> recognitionAreasRectangles = new ArrayList();
    public ArrayList<char[]> recognitionCharactersList;
    public double skew = 0.0;
    public ArrayList<String> warnings = new ArrayList();

    public String GetJson() {
        e0cd0c6d13 e0cd0c6d132 = e0cd0c6d13.f();
        try {
            e0cd0c6d132.f("skew").f(this.skew);
            for (int i2 = 0; i2 < this.recognitionAreasText.size(); ++i2) {
                String string = this.recognitionAreasText.get(i2);
                Rectangle rectangle = this.recognitionAreasRectangles.get(i2);
                e0cd0c6d13 e0cd0c6d133 = e0cd0c6d132.f("recognitionAreasData").f(i2);
                e0cd0c6d133.f("text").c0ad(string);
                e0cd0c6d133.f("rectangle").f("x").c0ad(rectangle.x);
                e0cd0c6d133.f("rectangle").f("y").c0ad(rectangle.y);
                e0cd0c6d133.f("rectangle").f("width").c0ad(rectangle.width);
                e0cd0c6d133.f("rectangle").f("height").c0ad(rectangle.height);
            }
            String string = e0cd0c6d132.c0ad();
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void save(String string) {
        this.f(this.recognitionText, string, Format.Text);
    }

    public void save(String string, Format format) {
        this.f(this.recognitionText, string, format);
    }

    public void saveSpellCheckCorrectedText(String string, Format format, SpellCheckLanguage spellCheckLanguage) {
        this.f(this.getSpellCheckCorrectedText(spellCheckLanguage), string, format);
    }

    public void saveSpellCheckCorrectedText(String string, Format format) {
        this.f(this.getSpellCheckCorrectedText(), string, format);
    }

    public String getSpellCheckCorrectedText(SpellCheckLanguage spellCheckLanguage) {
        return e0cd0c4d77.f(this.recognitionText, spellCheckLanguage);
    }

    public String getSpellCheckCorrectedText() {
        return e0cd0c4d77.f(this.recognitionText);
    }

    public List<SpellCheckError> getSpellCheckErrorList(SpellCheckLanguage spellCheckLanguage) {
        return e0cd0c4d77.c0ad(this.recognitionText, spellCheckLanguage);
    }

    public List<SpellCheckError> getSpellCheckErrorList() {
        return e0cd0c4d77.c0ad(this.recognitionText);
    }

    public RecognitionResult() {
        this.recognitionCharactersList = new ArrayList();
        this.recognitionLinesResult = new ArrayList();
    }

    void f(RecognitionSettings recognitionSettings, boolean bl) {
        if (recognitionSettings == null) {
            return;
        }
        if (bl && recognitionSettings.f() != null && recognitionSettings.f().size() != 0 || recognitionSettings.e0cd0c6d17() || recognitionSettings.e0cd0c6d16() != 0.0) {
            this.warnings.add("Only DetectAreas and AutoSkew options will aplly");
            return;
        }
        if (recognitionSettings.f() != null && recognitionSettings.f().size() != 0 && (recognitionSettings.c0ad() || recognitionSettings.ac8a() || recognitionSettings.e0cd0c6d17() || recognitionSettings.e0cd0c6d16() != 0.0)) {
            this.warnings.add("Setting areas for recognition manually will disable Skew, DetectAreas, AutoSkew and RecognizeSingleLine options");
        } else {
            if (recognitionSettings.e0cd0c6d16() != 0.0 && recognitionSettings.ac8a()) {
                this.warnings.add("Setting skew value will disable AutoSkew");
            }
            if (recognitionSettings.e0cd0c6d17()) {
                this.warnings.add("Setting single line recognition will disable DetectAreas and AutoSkew");
            }
        }
    }

    void f(boolean bl) {
        if (bl) {
            this.warnings.add("Only 20 images will be processed by text recognition");
        }
    }

    void f(String string, String string2, Format format) {
        try {
            switch (format) {
                case Docx: {
                    e0cd0c6d17.c0ad(string, string2);
                    break;
                }
                case Pdf: {
                    e0cd0c6d17.edf(string, string2);
                    break;
                }
                default: {
                    e0cd0c6d17.f(string, string2);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't create document");
        }
    }

    public RecognitionResult add(RecognitionResult recognitionResult) {
        this.recognitionAreasRectangles.addAll(recognitionResult.recognitionAreasRectangles);
        this.recognitionAreasText.addAll(recognitionResult.recognitionAreasText);
        this.recognitionCharactersList.addAll(recognitionResult.recognitionCharactersList);
        this.recognitionLinesResult.addAll(recognitionResult.recognitionLinesResult);
        this.recognitionText = this.recognitionText + recognitionResult.recognitionText;
        this.skew = recognitionResult.skew;
        this.warnings = recognitionResult.warnings;
        return this;
    }

    public class LinesResult {
        public String textInLine;
        public Rectangle line;
    }
}

