/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import com.aspose.ocr.AreasType;
import com.aspose.ocr.PreprocessingFilter;
import com.aspose.ocr.RecognitionResult;
import com.aspose.ocr.RecognitionSettings;
import com.aspose.ocr.SpellCheck.SpellCheckLanguage;
import com.aspose.ocr.c0ad;
import com.aspose.ocr.e0cd0c4d77;
import com.aspose.ocr.e0cd0c6d11;
import com.aspose.ocr.e0cd0c6d44;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class AsposeOCR {
    public AsposeOCR() {
    }

    public AsposeOCR(String string) {
        e0cd0c6d44.f = string + c0ad.c0ad;
    }

    public double CalcSkewImage(String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        return this.CalcSkewImage(bufferedImage);
    }

    public double CalcSkewImage(BufferedImage bufferedImage) throws IOException {
        e0cd0c6d44 e0cd0c6d442 = new e0cd0c6d44();
        bufferedImage = e0cd0c6d442.f(bufferedImage, new RecognitionSettings());
        return e0cd0c6d442.f(bufferedImage, 0);
    }

    public double CalcSkewImageFromUri(String string) throws IOException {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        return this.CalcSkewImage(bufferedImage);
    }

    public BufferedImage PreprocessImage(String string, PreprocessingFilter preprocessingFilter) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        for (PreprocessingFilter preprocessingFilter2 : preprocessingFilter.f) {
            bufferedImage = preprocessingFilter2.f(bufferedImage);
        }
        return bufferedImage;
    }

    public BufferedImage PreprocessImage(BufferedImage bufferedImage, PreprocessingFilter preprocessingFilter) {
        BufferedImage bufferedImage2 = e0cd0c6d11.f(bufferedImage);
        for (PreprocessingFilter preprocessingFilter2 : preprocessingFilter.f) {
            bufferedImage2 = preprocessingFilter2.f(bufferedImage2);
        }
        return bufferedImage2;
    }

    public String RecognizePage(String string) throws IOException {
        return this.RecognizePage(string, true);
    }

    public String RecognizePage(String string, boolean bl) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        return this.RecognizePage(bufferedImage, bl);
    }

    public String RecognizePage(String string, ArrayList<Rectangle> arrayList) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        return this.RecognizePage(bufferedImage, arrayList);
    }

    public RecognitionResult RecognizePage(String string, RecognitionSettings recognitionSettings) throws IOException {
        e0cd0c6d44 e0cd0c6d442 = new e0cd0c6d44();
        e0cd0c6d442.c0ad(recognitionSettings);
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        e0cd0c6d442.f(bufferedImage, recognitionSettings);
        RecognitionResult recognitionResult = e0cd0c6d442.f(recognitionSettings);
        recognitionResult.f(recognitionSettings, false);
        e0cd0c6d442.f();
        return recognitionResult;
    }

    public String RecognizeLine(String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        return this.RecognizeLine(bufferedImage);
    }

    public String RecognizePage(BufferedImage bufferedImage) throws IOException {
        return this.RecognizePage(bufferedImage, true);
    }

    public String RecognizePage(BufferedImage bufferedImage, boolean bl) throws IOException {
        RecognitionSettings recognitionSettings = new RecognitionSettings();
        recognitionSettings.setAutoSkew(bl);
        return this.RecognizePage((BufferedImage)bufferedImage, (RecognitionSettings)recognitionSettings).recognitionText;
    }

    public String RecognizePage(BufferedImage bufferedImage, ArrayList<Rectangle> arrayList) throws IOException {
        e0cd0c6d44 e0cd0c6d442 = new e0cd0c6d44();
        RecognitionSettings recognitionSettings = new RecognitionSettings();
        recognitionSettings.setRecognitionAreas(arrayList);
        e0cd0c6d442.f(bufferedImage, new RecognitionSettings());
        RecognitionResult recognitionResult = e0cd0c6d442.f(recognitionSettings);
        e0cd0c6d442.f();
        return recognitionResult.recognitionText;
    }

    public RecognitionResult RecognizePage(BufferedImage bufferedImage, RecognitionSettings recognitionSettings) throws IOException {
        e0cd0c6d44 e0cd0c6d442 = new e0cd0c6d44();
        e0cd0c6d442.c0ad(recognitionSettings);
        e0cd0c6d442.f(bufferedImage, recognitionSettings);
        RecognitionResult recognitionResult = e0cd0c6d442.f(recognitionSettings);
        recognitionResult.f(recognitionSettings, false);
        e0cd0c6d442.f();
        return recognitionResult;
    }

    public String RecognizeLine(BufferedImage bufferedImage) {
        RecognitionSettings recognitionSettings = new RecognitionSettings();
        recognitionSettings.setRecognizeSingleLine(true);
        try {
            return this.RecognizePage((BufferedImage)bufferedImage, (RecognitionSettings)recognitionSettings).recognitionText;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ArrayList<RecognitionResult> RecognizeMultiplePages(String string, RecognitionSettings recognitionSettings) throws IOException {
        ArrayList<RecognitionResult> arrayList;
        File file = new File(string);
        if (string.endsWith(".zip")) {
            arrayList = new ArrayList<RecognitionResult>();
            int n2 = 0;
            boolean bl = false;
            try (ZipFile zipFile = new ZipFile(string);){
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (zipEntry.isDirectory()) continue;
                    if (n2 == 20) {
                        bl = true;
                        break;
                    }
                    BufferedImage object = ImageIO.read(zipFile.getInputStream(zipEntry));
                    RecognitionResult recognitionResult = this.RecognizePage(object, recognitionSettings);
                    arrayList.add(recognitionResult);
                    ++n2;
                }
                for (RecognitionResult recognitionResult : arrayList) {
                    recognitionResult.f(bl);
                }
            }
        } else if (file.isDirectory()) {
            File file2 = new File(string);
            File[] fileArray = file2.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                throw new FileNotFoundException();
            }
            arrayList = new ArrayList();
            for (int i2 = 0; i2 < fileArray.length && i2 < 20; ++i2) {
                if (!fileArray[i2].isFile()) continue;
                arrayList.add(this.RecognizePage(fileArray[i2].getCanonicalPath(), recognitionSettings));
            }
            for (RecognitionResult recognitionResult : arrayList) {
                recognitionResult.f(fileArray.length <= 20);
            }
        } else {
            throw new RuntimeException("Not correct path. The path must end with the name of the .zip archive or folder with images. Subfolders and nested archives are not supported");
        }
        return arrayList;
    }

    public ArrayList<RecognitionResult> RecognizeMultiplePages(ArrayList<String> arrayList, RecognitionSettings recognitionSettings) throws IOException {
        ArrayList<RecognitionResult> arrayList2 = new ArrayList<RecognitionResult>(arrayList.size());
        for (int i2 = 0; i2 < arrayList.size() && i2 < 20; ++i2) {
            File object = new File(arrayList.get(i2));
            if (!object.isFile()) continue;
            arrayList2.add(this.RecognizePage(object.getCanonicalPath(), recognitionSettings));
        }
        for (RecognitionResult recognitionResult : arrayList2) {
            recognitionResult.f(arrayList.size() >= 20);
        }
        return arrayList2;
    }

    public String RecognizePageFromUri(String string) throws IOException {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        return this.RecognizePage(bufferedImage, true);
    }

    public RecognitionResult RecognizePageFromUri(String string, RecognitionSettings recognitionSettings) throws IOException {
        e0cd0c6d44 e0cd0c6d442 = new e0cd0c6d44();
        e0cd0c6d442.c0ad(recognitionSettings);
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        e0cd0c6d442.f(bufferedImage, recognitionSettings);
        RecognitionResult recognitionResult = e0cd0c6d442.f(recognitionSettings);
        recognitionResult.f(recognitionSettings, false);
        e0cd0c6d442.f();
        return recognitionResult;
    }

    public ArrayList<Rectangle> getTextAreas(String string, AreasType areasType, boolean bl) throws IOException {
        e0cd0c6d44 e0cd0c6d442 = new e0cd0c6d44();
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        e0cd0c6d442.f(bufferedImage, new RecognitionSettings());
        return e0cd0c6d442.f(areasType, false, bl);
    }

    public ArrayList<Rectangle> getTextAreas(BufferedImage bufferedImage, AreasType areasType, boolean bl) throws IOException {
        e0cd0c6d44 e0cd0c6d442 = new e0cd0c6d44();
        e0cd0c6d442.f(bufferedImage, new RecognitionSettings());
        return e0cd0c6d442.f(areasType, false, bl);
    }

    public String CorrectSpelling(String string, SpellCheckLanguage spellCheckLanguage) {
        return e0cd0c4d77.f(string, spellCheckLanguage);
    }
}

