/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.operator.jcajce;

import com.aspose.html.utils.ms.core.bc.asn1.cms.GenericHybridParameters;
import com.aspose.html.utils.ms.core.bc.asn1.cms.RsaKemParameters;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.crypto.util.DEROtherInfo;
import com.aspose.html.utils.ms.core.bc.jcajce.spec.KTSParameterSpec;
import com.aspose.html.utils.ms.core.bc.jcajce.util.DefaultJcaJceHelper;
import com.aspose.html.utils.ms.core.bc.jcajce.util.NamedJcaJceHelper;
import com.aspose.html.utils.ms.core.bc.jcajce.util.ProviderJcaJceHelper;
import com.aspose.html.utils.ms.core.bc.operator.AsymmetricKeyUnwrapper;
import com.aspose.html.utils.ms.core.bc.operator.GenericKey;
import com.aspose.html.utils.ms.core.bc.operator.OperatorException;
import com.aspose.html.utils.ms.core.bc.operator.jcajce.JceGenericKey;
import com.aspose.html.utils.ms.core.bc.operator.jcajce.OperatorHelper;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class JceKTSKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private Map extraMappings = new HashMap();
    private PrivateKey privKey;
    private byte[] partyUInfo;
    private byte[] partyVInfo;

    public JceKTSKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey, byte[] byArray, byte[] byArray2) {
        super(algorithmIdentifier);
        this.privKey = privateKey;
        this.partyUInfo = Arrays.clone(byArray);
        this.partyVInfo = Arrays.clone(byArray2);
    }

    public JceKTSKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKTSKeyUnwrapper setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws OperatorException {
        Key key;
        GenericHybridParameters genericHybridParameters = GenericHybridParameters.getInstance(this.getAlgorithmIdentifier().getParameters());
        Cipher cipher = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm(), this.extraMappings);
        String string = this.helper.getWrappingAlgorithmName(genericHybridParameters.getDem().getAlgorithm());
        RsaKemParameters rsaKemParameters = RsaKemParameters.getInstance(genericHybridParameters.getKem().getParameters());
        int n2 = rsaKemParameters.getKeyLength().intValue() * 8;
        try {
            DEROtherInfo dEROtherInfo = new DEROtherInfo.Builder(genericHybridParameters.getDem(), this.partyUInfo, this.partyVInfo).build();
            KTSParameterSpec kTSParameterSpec = new KTSParameterSpec.Builder(string, n2, dEROtherInfo.getEncoded()).withKdfAlgorithm(rsaKemParameters.getKeyDerivationFunction()).build();
            cipher.init(4, (Key)this.privKey, kTSParameterSpec);
            key = cipher.unwrap(byArray, this.helper.getKeyAlgorithmName(algorithmIdentifier.getAlgorithm()), 3);
        }
        catch (Exception exception) {
            throw new OperatorException("Unable to unwrap contents key: " + exception.getMessage(), exception);
        }
        return new JceGenericKey(algorithmIdentifier, key);
    }
}

