/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.operator;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.DERNull;
import com.aspose.html.utils.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.operator.PBKDFConfig;
import com.aspose.html.utils.ms.core.bc.util.Integers;
import java.util.HashMap;
import java.util.Map;

public class PBKDF2Config
extends PBKDFConfig {
    public static final AlgorithmIdentifier PRF_SHA1 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    public static final AlgorithmIdentifier PRF_SHA256 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA256, DERNull.INSTANCE);
    public static final AlgorithmIdentifier PRF_SHA512 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
    private static final Map PRFS_SALT = new HashMap();
    private final int iterationCount;
    private final int saltLength;
    private final AlgorithmIdentifier prf;

    static int getSaltSize(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (!PRFS_SALT.containsKey(aSN1ObjectIdentifier)) {
            throw new IllegalStateException("no salt size for algorithm: " + aSN1ObjectIdentifier);
        }
        return (Integer)PRFS_SALT.get(aSN1ObjectIdentifier);
    }

    private PBKDF2Config(Builder builder) {
        super(PKCSObjectIdentifiers.id_PBKDF2);
        this.iterationCount = builder.iterationCount;
        this.prf = builder.prf;
        this.saltLength = builder.saltLength < 0 ? PBKDF2Config.getSaltSize(this.prf.getAlgorithm()) : builder.saltLength;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public AlgorithmIdentifier getPRF() {
        return this.prf;
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    static {
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA1, Integers.valueOf(20));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA256, Integers.valueOf(32));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA512, Integers.valueOf(64));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA224, Integers.valueOf(28));
        PRFS_SALT.put(PKCSObjectIdentifiers.id_hmacWithSHA384, Integers.valueOf(48));
        PRFS_SALT.put(CryptoProObjectIdentifiers.gostR3411Hmac, Integers.valueOf(32));
    }

    public static class Builder {
        private int iterationCount = 1024;
        private int saltLength = -1;
        private AlgorithmIdentifier prf = PRF_SHA1;

        public Builder withIterationCount(int n2) {
            this.iterationCount = n2;
            return this;
        }

        public Builder withPRF(AlgorithmIdentifier algorithmIdentifier) {
            this.prf = algorithmIdentifier;
            return this;
        }

        public Builder withSaltLength(int n2) {
            this.saltLength = n2;
            return this;
        }

        public PBKDF2Config build() {
            return new PBKDF2Config(this);
        }
    }
}

