/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.spec;

import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsKDF;
import com.aspose.html.utils.ms.core.bc.jcajce.spec.PrfUtils;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;

public class KTSKeySpec
implements KeySpec {
    public static final FipsKDF.AgreementKDFParametersBuilder KDF2 = FipsKDF.X963;
    public static final FipsKDF.AgreementKDFParametersBuilder KDF3 = FipsKDF.CONCATENATION;
    private final String keyAlgorithmName;
    private final int keySize;
    private final String macAlgorithm;
    private final int macKeySizeInBits;
    private final AlgorithmParameterSpec parameterSpec;
    private final AlgorithmIdentifier kdfAlgorithm;
    private byte[] otherInfo;

    KTSKeySpec(String string, int n2, String string2, int n3, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.keyAlgorithmName = string;
        this.keySize = n2;
        this.macAlgorithm = string2;
        this.macKeySizeInBits = n3;
        this.parameterSpec = algorithmParameterSpec;
        this.kdfAlgorithm = algorithmIdentifier;
        this.otherInfo = byArray;
    }

    public String getKeyAlgorithmName() {
        return this.keyAlgorithmName;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getMacAlgorithmName() {
        return this.macAlgorithm;
    }

    public int getMacKeySize() {
        return this.macKeySizeInBits;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    public AlgorithmIdentifier getKdfAlgorithmId() {
        return this.kdfAlgorithm;
    }

    public byte[] getOtherInfo() {
        return Arrays.clone(this.otherInfo);
    }

    static AlgorithmIdentifier createAlgId(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder) {
        if (agreementKDFParametersBuilder.getAlgorithm().getName().startsWith(KDF2.getAlgorithm().getName())) {
            return new AlgorithmIdentifier(X9ObjectIdentifiers.id_kdf_kdf2, new AlgorithmIdentifier(PrfUtils.getObjectIdentifier(agreementKDFParametersBuilder.getPRF().getAlgorithm())));
        }
        if (agreementKDFParametersBuilder.getAlgorithm().getName().startsWith(KDF3.getAlgorithm().getName())) {
            return new AlgorithmIdentifier(X9ObjectIdentifiers.id_kdf_kdf3, new AlgorithmIdentifier(PrfUtils.getObjectIdentifier(agreementKDFParametersBuilder.getPRF().getAlgorithm())));
        }
        throw new IllegalArgumentException("kdfAlgorithm must be one of KDF2 or KDF3");
    }

    static byte[] copyOtherInfo(byte[] byArray) {
        return byArray == null ? new byte[]{} : Arrays.clone(byArray);
    }
}

