/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.provider;

import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricXDHPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricXDHPublicKey;
import com.aspose.html.utils.ms.core.bc.jcajce.interfaces.XDHKey;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.KeyUtil;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import javax.security.auth.Destroyable;

class ProvXDHPrivateKey
implements XDHKey,
PrivateKey,
Destroyable {
    static final long serialVersionUID = 1L;
    private transient AsymmetricXDHPrivateKey baseKey;

    ProvXDHPrivateKey(AsymmetricXDHPrivateKey asymmetricXDHPrivateKey) {
        this.baseKey = asymmetricXDHPrivateKey;
    }

    ProvXDHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.baseKey = new AsymmetricXDHPrivateKey(privateKeyInfo);
    }

    public String getAlgorithm() {
        return this.getBaseKey().getAlgorithm().getName();
    }

    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    public byte[] getPublicData() {
        return this.getBaseKey().getPublicData();
    }

    public byte[] getEncoded() {
        return this.getBaseKey().getEncoded();
    }

    public void destroy() {
        this.baseKey.destroy();
    }

    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public AsymmetricXDHPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("XDH");
        }
        AsymmetricXDHPublicKey asymmetricXDHPublicKey = new AsymmetricXDHPublicKey(this.baseKey.getAlgorithm(), this.baseKey.getPublicData());
        return KeyUtil.keyToString("Private Key", this.getAlgorithm(), asymmetricXDHPublicKey);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvXDHPrivateKey)) {
            return false;
        }
        ProvXDHPrivateKey provXDHPrivateKey = (ProvXDHPrivateKey)object;
        return Arrays.areEqual(provXDHPrivateKey.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricXDHPrivateKey(byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

