/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.provider;

import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.MACOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.OutputMACCalculator;
import com.aspose.html.utils.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.utils.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsMACOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.general.SecureHash;
import com.aspose.html.utils.ms.core.bc.jcajce.PKCS12Key;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.MacParametersCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.ProvPKCS12;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.Utils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseHMac
extends MacSpi {
    private static FipsMACOperatorFactory<FipsSHS.AuthParameters> fipsFactory = new FipsSHS.MACOperatorFactory();
    private static MACOperatorFactory<SecureHash.AuthParameters> generalFactory;
    private final Algorithm algorithm;
    private final MACOperatorFactory factory;
    private final MacParametersCreator parametersCreator;
    private OutputMACCalculator macCalculator;
    private UpdateOutputStream macStream;

    protected BaseHMac(FipsAlgorithm fipsAlgorithm, MacParametersCreator macParametersCreator) {
        this.algorithm = fipsAlgorithm;
        this.factory = fipsFactory;
        this.parametersCreator = macParametersCreator;
    }

    protected BaseHMac(GeneralAlgorithm generalAlgorithm, MacParametersCreator macParametersCreator) {
        this.algorithm = generalAlgorithm;
        this.factory = this.getGeneralMACFactory();
        this.parametersCreator = macParametersCreator;
    }

    private MACOperatorFactory<SecureHash.AuthParameters> getGeneralMACFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (generalFactory == null) {
            generalFactory = new SecureHash.MACOperatorFactory();
        }
        return generalFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object t2;
        if (algorithmParameterSpec instanceof PBEParameterSpec) {
            try {
                t2 = this.parametersCreator.createParameters(true, null, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
        } else {
            t2 = this.parametersCreator.createParameters(true, algorithmParameterSpec, null);
        }
        if (key instanceof PKCS12Key) {
            SecretKey secretKey;
            PBEParameterSpec pBEParameterSpec;
            int n2 = t2.getMACSizeInBits();
            if (algorithmParameterSpec != null) {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE algorithms can only take PBEParameterSpec");
                pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            } else {
                if (!(key instanceof PBEKey)) throw new InvalidKeyException("No algorithm parameters provided when required.");
                secretKey = (PBEKey)key;
                pBEParameterSpec = new PBEParameterSpec(secretKey.getSalt(), secretKey.getIterationCount());
            }
            try {
                secretKey = (SecretKey)key;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("PBE schemes requires a SecretKey/PBEKey");
            }
            if (!(key instanceof PKCS12Key)) throw new InvalidKeyException("Unable to use passed in key for PBE");
            key = new SecretKeySpec(ProvPKCS12.getSecretKey(secretKey, Utils.getUnderlyingDigestAlgorithm(this.algorithm), pBEParameterSpec, PasswordBasedDeriver.KeyType.MAC, n2), this.algorithm.getName());
        }
        this.macCalculator = this.factory.createOutputMACCalculator(Utils.convertKey(this.algorithm, key), t2);
        this.macStream = this.macCalculator.getMACStream();
    }

    @Override
    protected int engineGetMacLength() {
        return (this.parametersCreator.getBaseParameters().getMACSizeInBits() + 7) / 8;
    }

    @Override
    protected void engineReset() {
        if (this.macCalculator != null) {
            this.macCalculator.reset();
        }
    }

    @Override
    protected void engineUpdate(byte by2) {
        this.macStream.update(by2);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.macStream.update(byArray, n2, n3);
    }

    @Override
    protected byte[] engineDoFinal() {
        return this.macCalculator.getMAC();
    }
}

