/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.general.Gost3410KeyGenerationParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.Gost3410Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.Gost3410PrivateKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.Gost3410PublicKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.AsymmetricCipherKeyPair;
import com.aspose.html.utils.ms.core.bc.crypto.internal.AsymmetricCipherKeyPairGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.internal.KeyGenerationParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

class Gost3410KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private Gost3410KeyGenerationParameters param;

    Gost3410KeyPairGenerator() {
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (Gost3410KeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        Gost3410Parameters gost3410Parameters = this.param.getParameters();
        SecureRandom secureRandom = this.param.getRandom();
        BigInteger bigInteger2 = gost3410Parameters.getQ();
        BigInteger bigInteger3 = gost3410Parameters.getP();
        BigInteger bigInteger4 = gost3410Parameters.getA();
        while ((bigInteger = new BigInteger(256, secureRandom)).equals(ZERO) || bigInteger.compareTo(bigInteger2) >= 0) {
        }
        BigInteger bigInteger5 = bigInteger4.modPow(bigInteger, bigInteger3);
        return new AsymmetricCipherKeyPair(new Gost3410PublicKeyParameters(bigInteger5, gost3410Parameters), new Gost3410PrivateKeyParameters(bigInteger, gost3410Parameters));
    }
}

