/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.internal.params.AsymmetricKeyParameter;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import com.aspose.html.utils.ms.core.bc.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class Ed448PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 57;
    private final byte[] data = new byte[57];

    public Ed448PublicKeyParameters(byte[] byArray, int n2) {
        super(false);
        System.arraycopy(byArray, n2, this.data, 0, 57);
    }

    public Ed448PublicKeyParameters(InputStream inputStream) throws IOException {
        super(false);
        if (57 != Streams.readFully(inputStream, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed448 public key");
        }
    }

    public void encode(byte[] byArray, int n2) {
        System.arraycopy(this.data, 0, byArray, n2, 57);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }
}

