/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsSecureRandom;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.utils.ms.core.bc.crypto.fips.SHA256Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.ValidatedSymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.AEADParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameter;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithIV;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.utils.ms.core.bc.math.ec.ECCurve;
import com.aspose.html.utils.ms.core.bc.util.Pack;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.util.concurrent.atomic.AtomicLong;

class Utils {
    static final SecureRandom testRandom = new TestSecureRandom();

    Utils() {
    }

    static void validateRandom(SecureRandom secureRandom, String string) {
        if (!(secureRandom instanceof FipsSecureRandom) && !(secureRandom.getProvider() instanceof BouncyCastleFipsProvider)) {
            throw new FipsUnapprovedOperationError(string);
        }
    }

    static void validateRandom(SecureRandom secureRandom, FipsAlgorithm fipsAlgorithm, String string) {
        if (!(secureRandom instanceof FipsSecureRandom) && !(secureRandom.getProvider() instanceof BouncyCastleFipsProvider)) {
            throw new FipsUnapprovedOperationError(string, fipsAlgorithm);
        }
    }

    static void validateRandom(SecureRandom secureRandom, int n2, FipsAlgorithm fipsAlgorithm, String string) {
        if (secureRandom instanceof FipsSecureRandom) {
            if (((FipsSecureRandom)secureRandom).getSecurityStrength() < n2) {
                throw new FipsUnapprovedOperationError("FIPS SecureRandom security strength not as high as required for operation", fipsAlgorithm);
            }
        } else if (secureRandom.getProvider() instanceof BouncyCastleFipsProvider) {
            if (((BouncyCastleFipsProvider)secureRandom.getProvider()).getDefaultRandomSecurityStrength() < n2) {
                throw new FipsUnapprovedOperationError("FIPS SecureRandom security strength not as high as required for operation", fipsAlgorithm);
            }
        } else {
            throw new FipsUnapprovedOperationError(string, fipsAlgorithm);
        }
    }

    static void validateKeyGenRandom(SecureRandom secureRandom, int n2, FipsAlgorithm fipsAlgorithm) {
        Utils.validateRandom(secureRandom, n2, fipsAlgorithm, "Attempt to create key with unapproved RNG");
    }

    static void validateKeyPairGenRandom(SecureRandom secureRandom, int n2, FipsAlgorithm fipsAlgorithm) {
        Utils.validateRandom(secureRandom, n2, fipsAlgorithm, "Attempt to create key pair with unapproved RNG");
    }

    static void checkPermission(final Permission permission) {
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    securityManager.checkPermission(permission);
                    return null;
                }
            });
        }
    }

    static void approvedModeCheck(boolean bl2, FipsAlgorithm fipsAlgorithm) {
        if (bl2 != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            if (bl2) {
                throw new FipsUnapprovedOperationError("Attempt to use approved implementation in unapproved thread", fipsAlgorithm);
            }
            throw new FipsUnapprovedOperationError("Attempt to use unapproved implementation in approved thread", fipsAlgorithm);
        }
    }

    static int getDefaultMacSize(Algorithm algorithm, int n2) {
        if (algorithm.getName().endsWith("GMAC") || algorithm.getName().endsWith("CMAC") || algorithm.getName().endsWith("GCM")) {
            return n2;
        }
        return n2 / 2;
    }

    static KeyParameter getKeyParameter(ValidatedSymmetricKey validatedSymmetricKey) {
        return new KeyParameterImpl(validatedSymmetricKey.getKeyBytes());
    }

    static ParametersWithIV getParametersWithIV(ValidatedSymmetricKey validatedSymmetricKey, byte[] byArray) {
        return new ParametersWithIV(new KeyParameterImpl(validatedSymmetricKey.getKeyBytes()), byArray);
    }

    static AEADParameters getAEADParameters(ValidatedSymmetricKey validatedSymmetricKey, byte[] byArray, int n2) {
        return new AEADParameters(new KeyParameterImpl(validatedSymmetricKey.getKeyBytes()), n2, byArray);
    }

    public static int getAsymmetricSecurityStrength(int n2) {
        if (n2 >= 15360) {
            return 256;
        }
        if (n2 >= 7680) {
            return 192;
        }
        if (n2 >= 3072) {
            return 128;
        }
        if (n2 >= 2048) {
            return 112;
        }
        if (n2 >= 1024) {
            return 80;
        }
        throw new FipsUnapprovedOperationError("Requested security strength unknown");
    }

    public static int getECCurveSecurityStrength(ECCurve eCCurve) {
        int n2 = eCCurve.getFieldSize();
        if (n2 >= 512) {
            return 256;
        }
        if (n2 >= 384) {
            return 192;
        }
        if (n2 >= 256) {
            return 128;
        }
        if (n2 >= 224) {
            return 112;
        }
        if (n2 >= 160) {
            return 80;
        }
        throw new FipsUnapprovedOperationError("Requested security strength unknown");
    }

    static class TestSecureRandom
    extends SecureRandom {
        public TestSecureRandom() {
            super(new RandomSpi(), new RandomProvider());
        }

        static class RandomProvider
        extends Provider {
            RandomProvider() {
                super("BCFIPS_TEST_RNG", 1.0, "BCFIPS Test Secure Random Provider");
            }
        }

        static class RandomSpi
        extends SecureRandomSpi {
            private final AtomicLong counter = new AtomicLong(System.currentTimeMillis());

            private RandomSpi() {
            }

            protected void engineSetSeed(byte[] byArray) {
            }

            protected void engineNextBytes(byte[] byArray) {
                SHA256Digest sHA256Digest = new SHA256Digest();
                byte[] byArray2 = new byte[sHA256Digest.getDigestSize()];
                byte[] byArray3 = new byte[8];
                int n2 = 0;
                for (int i2 = byArray.length; i2 > 0; i2 -= byArray2.length) {
                    Pack.longToBigEndian(this.counter.getAndIncrement(), byArray3, 0);
                    sHA256Digest.update(byArray3, 0, byArray3.length);
                    sHA256Digest.doFinal(byArray2, 0);
                    if (i2 > byArray2.length) {
                        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                    } else {
                        System.arraycopy(byArray2, 0, byArray, n2, i2);
                    }
                    n2 += byArray2.length;
                }
            }

            protected byte[] engineGenerateSeed(int n2) {
                byte[] byArray = new byte[n2];
                this.engineNextBytes(byArray);
                return byArray;
            }
        }
    }
}

