/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.fips.KeccakDigest;

class SHA3Digest
extends KeccakDigest {
    private static int checkBitLength(int n2) {
        switch (n2) {
            case 224: 
            case 256: 
            case 384: 
            case 512: {
                return n2;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + n2 + " not supported for SHA-3");
    }

    public SHA3Digest(int n2) {
        super(SHA3Digest.checkBitLength(n2));
    }

    public SHA3Digest(SHA3Digest sHA3Digest) {
        super(sHA3Digest);
    }

    public String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    public int doFinal(byte[] byArray, int n2) {
        this.absorb(new byte[]{2}, 0, 2L);
        return super.doFinal(byArray, n2);
    }

    protected int doFinal(byte[] byArray, int n2, byte by2, int n3) {
        if (n3 < 0 || n3 > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int n4 = by2 & (1 << n3) - 1 | 2 << n3;
        int n5 = n3 + 2;
        if (n5 >= 8) {
            this.oneByte[0] = (byte)n4;
            this.absorb(this.oneByte, 0, 8L);
            n5 -= 8;
            n4 >>>= 8;
        }
        return super.doFinal(byArray, n2, (byte)n4, n5);
    }
}

