/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.cert.dane;

import com.aspose.html.utils.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.utils.ms.core.bc.cert.dane.DANEEntry;
import com.aspose.html.utils.ms.core.bc.cert.dane.DANEEntrySelector;
import com.aspose.html.utils.ms.core.bc.cert.dane.DANEEntrySelectorFactory;
import com.aspose.html.utils.ms.core.bc.cert.dane.DANEException;
import com.aspose.html.utils.ms.core.bc.operator.DigestCalculator;

public class DANEEntryFactory {
    private final DANEEntrySelectorFactory selectorFactory;

    public DANEEntryFactory(DigestCalculator digestCalculator) {
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public DANEEntry createEntry(String string, X509CertificateHolder x509CertificateHolder) throws DANEException {
        return this.createEntry(string, 3, x509CertificateHolder);
    }

    public DANEEntry createEntry(String string, int n2, X509CertificateHolder x509CertificateHolder) throws DANEException {
        if (n2 < 0 || n2 > 3) {
            throw new DANEException("unknown certificate usage: " + n2);
        }
        DANEEntrySelector dANEEntrySelector = this.selectorFactory.createSelector(string);
        byte[] byArray = new byte[]{(byte)n2, 0, 0};
        return new DANEEntry(dANEEntrySelector.getDomainName(), byArray, x509CertificateHolder);
    }
}

