/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Security.Cryptography;

import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.BitConverter;
import com.aspose.html.utils.ms.System.Buffer;
import com.aspose.html.utils.ms.System.OverflowException;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSA;
import com.aspose.html.utils.ms.System.Security.Cryptography.RandomNumberGenerator;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA256;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA384;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA512;
import com.aspose.html.utils.ms.System.msArray;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;

public final class s {
    private static byte[] a = new byte[]{-38, 57, -93, -18, 94, 107, 75, 13, 50, 85, -65, -17, -107, 96, 24, -112, -81, -40, 7, 9};
    private static byte[] b = new byte[]{-29, -80, -60, 66, -104, -4, 28, 20, -102, -5, -12, -56, -103, 111, -71, 36, 39, -82, 65, -28, 100, -101, -109, 76, -92, -107, -103, 27, 120, 82, -72, 85};
    private static byte[] c = new byte[]{56, -80, 96, -89, 81, -84, -106, 56, 76, -39, 50, 126, -79, -79, -29, 106, 33, -3, -73, 17, 20, -66, 7, 67, 76, 12, -57, -65, 99, -10, -31, -38, 39, 78, -34, -65, -25, 111, 101, -5, -43, 26, -46, -15, 72, -104, -71, 91};
    private static byte[] d = new byte[]{-49, -125, -31, 53, 126, -17, -72, -67, -15, 84, 40, 80, -42, 109, -128, 7, -42, 32, -28, 5, 11, 87, 21, -36, -125, -12, -87, 33, -45, 108, -23, -50, 71, -48, -47, 60, 93, -123, -14, -80, -1, -125, 24, -46, -121, 126, -20, 47, 99, -71, 49, -67, 71, 65, 122, -127, -91, 56, 50, 122, -7, 39, -38, 62};

    private s() {
    }

    private static boolean a(byte[] byArray, byte[] byArray2) {
        boolean bl2;
        boolean bl3 = bl2 = byArray.length == byArray2.length;
        if (bl2) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return false;
            }
        }
        return bl2;
    }

    private static byte[] b(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray3.length; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] & 0xFF ^ byArray2[i2] & 0xFF);
        }
        return byArray3;
    }

    private static byte[] a(HashAlgorithm hashAlgorithm) {
        if (hashAlgorithm instanceof SHA1) {
            return a;
        }
        if (hashAlgorithm instanceof SHA256) {
            return b;
        }
        if (hashAlgorithm instanceof SHA384) {
            return c;
        }
        if (hashAlgorithm instanceof SHA512) {
            return d;
        }
        return hashAlgorithm.computeHash((byte[])null);
    }

    public static byte[] a(int n2, int n3) {
        byte[] byArray = BitConverter.getBytesInt32(n2);
        msArray.reverse(byArray, 0, byArray.length);
        return s.a(byArray, n3);
    }

    public static byte[] a(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray2), byArray2.length - byArray.length, byArray.length);
        return byArray2;
    }

    public static byte[] a(byte[] byArray) {
        int n2 = 0;
        while (byArray[n2++] == 0 && n2 < byArray.length) {
        }
        if (--n2 > 0) {
            byte[] byArray2 = new byte[byArray.length - n2];
            Buffer.blockCopy(Array.boxing(byArray), n2, Array.boxing(byArray2), 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static byte[] a(RSA rSA, byte[] byArray) {
        return rSA.encryptValue(byArray);
    }

    public static byte[] b(RSA rSA, byte[] byArray) {
        return rSA.decryptValue(byArray);
    }

    public static byte[] c(RSA rSA, byte[] byArray) {
        return rSA.decryptValue(byArray);
    }

    public static byte[] d(RSA rSA, byte[] byArray) {
        return rSA.encryptValue(byArray);
    }

    public static byte[] a(RSA rSA, HashAlgorithm hashAlgorithm, RandomNumberGenerator randomNumberGenerator, byte[] byArray) {
        int n2;
        int n3 = rSA.getKeySize() / 8;
        if (byArray.length > n3 - 2 * (n2 = hashAlgorithm.getHashSize() / 8) - 2) {
            throw new CryptographicException("message too long");
        }
        byte[] byArray2 = s.a(hashAlgorithm);
        int n4 = n3 - byArray.length - 2 * n2 - 2;
        byte[] byArray3 = new byte[byArray2.length + n4 + 1 + byArray.length];
        Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray3), 0, byArray2.length);
        byArray3[byArray2.length + n4] = 1;
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray3), byArray3.length - byArray.length, byArray.length);
        byte[] byArray4 = new byte[n2];
        randomNumberGenerator.getBytes(byArray4);
        byte[] byArray5 = s.b(hashAlgorithm, byArray4, n3 - n2 - 1);
        byte[] byArray6 = s.b(byArray3, byArray5);
        byte[] byArray7 = s.b(hashAlgorithm, byArray6, n2);
        byte[] byArray8 = s.b(byArray4, byArray7);
        byte[] byArray9 = new byte[byArray8.length + byArray6.length + 1];
        Buffer.blockCopy(Array.boxing(byArray8), 0, Array.boxing(byArray9), 1, byArray8.length);
        Buffer.blockCopy(Array.boxing(byArray6), 0, Array.boxing(byArray9), byArray8.length + 1, byArray6.length);
        byte[] byArray10 = s.a(byArray9);
        byte[] byArray11 = s.a(rSA, byArray10);
        return s.a(byArray11, n3);
    }

    public static byte[] a(RSA rSA, HashAlgorithm hashAlgorithm, byte[] byArray) {
        int n2;
        int n3 = rSA.getKeySize() / 8;
        if (n3 < 2 * (n2 = hashAlgorithm.getHashSize() / 8) + 2 || byArray.length != n3) {
            throw new CryptographicException("decryption error");
        }
        byte[] byArray2 = s.a(byArray);
        byte[] byArray3 = s.b(rSA, byArray2);
        byte[] byArray4 = s.a(byArray3, n3);
        byte[] byArray5 = new byte[n2];
        Buffer.blockCopy(Array.boxing(byArray4), 1, Array.boxing(byArray5), 0, byArray5.length);
        byte[] byArray6 = new byte[n3 - n2 - 1];
        Buffer.blockCopy(Array.boxing(byArray4), byArray4.length - byArray6.length, Array.boxing(byArray6), 0, byArray6.length);
        byte[] byArray7 = s.b(hashAlgorithm, byArray6, n2);
        byte[] byArray8 = s.b(byArray5, byArray7);
        byte[] byArray9 = s.b(hashAlgorithm, byArray8, n3 - n2 - 1);
        byte[] byArray10 = s.b(byArray6, byArray9);
        byte[] byArray11 = s.a(hashAlgorithm);
        byte[] byArray12 = new byte[byArray11.length];
        Buffer.blockCopy(Array.boxing(byArray10), 0, Array.boxing(byArray12), 0, byArray12.length);
        boolean bl2 = s.a(byArray11, byArray12);
        int n4 = byArray11.length;
        while (byArray10[n4] == 0) {
            ++n4;
        }
        int n5 = byArray10.length - n4 - 1;
        byte[] byArray13 = new byte[n5];
        Buffer.blockCopy(Array.boxing(byArray10), n4 + 1, Array.boxing(byArray13), 0, n5);
        if (byArray4[0] != 0 || !bl2 || byArray10[n4] != 1) {
            return null;
        }
        return byArray13;
    }

    public static byte[] a(RSA rSA, RandomNumberGenerator randomNumberGenerator, byte[] byArray) {
        int n2 = rSA.getKeySize() / 8;
        if (byArray.length > n2 - 11) {
            throw new CryptographicException("message too long");
        }
        int n3 = Math.max(8, n2 - byArray.length - 3);
        byte[] byArray2 = new byte[n3];
        randomNumberGenerator.getNonZeroBytes(byArray2);
        byte[] byArray3 = new byte[n2];
        byArray3[1] = 2;
        Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray3), 2, n3);
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray3), n2 - byArray.length, byArray.length);
        byte[] byArray4 = s.a(byArray3);
        byte[] byArray5 = s.a(rSA, byArray4);
        byte[] byArray6 = s.a(byArray5, n2);
        return byArray6;
    }

    public static byte[] e(RSA rSA, byte[] byArray) {
        int n2;
        int n3 = rSA.getKeySize() >> 3;
        if (n3 < 11 || byArray.length > n3) {
            throw new CryptographicException("decryption error");
        }
        byte[] byArray2 = s.a(byArray);
        byte[] byArray3 = s.b(rSA, byArray2);
        byte[] byArray4 = s.a(byArray3, n3);
        if (byArray4[0] != 0 || byArray4[1] != 2) {
            return null;
        }
        for (n2 = 10; byArray4[n2] != 0 && n2 < byArray4.length; ++n2) {
        }
        if (byArray4[n2] != 0) {
            return null;
        }
        byte[] byArray5 = new byte[byArray4.length - ++n2];
        Buffer.blockCopy(Array.boxing(byArray4), n2, Array.boxing(byArray5), 0, byArray5.length);
        return byArray5;
    }

    public static byte[] b(RSA rSA, HashAlgorithm hashAlgorithm, byte[] byArray) {
        int n2 = rSA.getKeySize() >> 3;
        byte[] byArray2 = s.a(hashAlgorithm, byArray, n2);
        byte[] byArray3 = s.a(byArray2);
        byte[] byArray4 = s.c(rSA, byArray3);
        byte[] byArray5 = s.a(byArray4, n2);
        return byArray5;
    }

    public static boolean a(RSA rSA, HashAlgorithm hashAlgorithm, byte[] byArray, byte[] byArray2) {
        return s.a(rSA, hashAlgorithm, byArray, byArray2, false);
    }

    public static boolean a(RSA rSA, HashAlgorithm hashAlgorithm, byte[] byArray, byte[] byArray2, boolean bl2) {
        int n2;
        int n3 = rSA.getKeySize() >> 3;
        byte[] byArray3 = s.a(byArray2);
        byte[] byArray4 = s.d(rSA, byArray3);
        byte[] byArray5 = s.a(byArray4, n3);
        byte[] byArray6 = s.a(hashAlgorithm, byArray, n3);
        boolean bl3 = s.a(byArray6, byArray5);
        if (bl3 || !bl2) {
            return bl3;
        }
        if (byArray5[0] != 0 || byArray5[1] != 1) {
            return false;
        }
        for (n2 = 2; n2 < byArray5.length - byArray.length - 1; ++n2) {
            if ((byArray5[n2] & 0xFF) == 255) continue;
            return false;
        }
        if (byArray5[n2++] != 0) {
            return false;
        }
        byte[] byArray7 = new byte[byArray.length];
        Buffer.blockCopy(Array.boxing(byArray5), n2, Array.boxing(byArray7), 0, byArray7.length);
        return s.a(byArray7, byArray);
    }

    public static byte[] a(HashAlgorithm hashAlgorithm, byte[] byArray, int n2) {
        Object object;
        if (byArray.length != hashAlgorithm.getHashSize() >> 3) {
            throw new CryptographicException("bad hash length for " + hashAlgorithm.toString());
        }
        byte[] byArray2 = null;
        String string = CryptoConfig.mapNameToOID(hashAlgorithm.toString());
        if (string != null) {
            ASN1 aSN1 = new ASN1(48);
            aSN1.add(new ASN1(CryptoConfig.encodeOID(string)));
            aSN1.add(new ASN1(5));
            object = new ASN1(4, byArray);
            ASN1 aSN12 = new ASN1(48);
            aSN12.add(aSN1);
            aSN12.add((ASN1)object);
            byArray2 = aSN12.getBytes();
        } else {
            byArray2 = byArray;
        }
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray2), byArray2.length - byArray.length, byArray.length);
        int n3 = Math.max(8, n2 - byArray2.length - 3);
        object = new byte[n3 + byArray2.length + 3];
        object[1] = true;
        for (int i2 = 2; i2 < n3 + 2; ++i2) {
            object[i2] = -1;
        }
        Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(object), n3 + 3, byArray2.length);
        return object;
    }

    public static byte[] b(HashAlgorithm hashAlgorithm, byte[] byArray, int n2) {
        if (n2 < 0) {
            throw new OverflowException();
        }
        int n3 = byArray.length;
        int n4 = hashAlgorithm.getHashSize() >> 3;
        int n5 = n2 / n4;
        if (n2 % n4 != 0) {
            ++n5;
        }
        byte[] byArray2 = new byte[n5 * n4];
        byte[] byArray3 = new byte[n3 + 4];
        int n6 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            byte[] byArray4 = s.a(i2, 4);
            Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray3), 0, n3);
            Buffer.blockCopy(Array.boxing(byArray4), 0, Array.boxing(byArray3), n3, 4);
            byte[] byArray5 = hashAlgorithm.computeHash(byArray3);
            Buffer.blockCopy(Array.boxing(byArray5), 0, Array.boxing(byArray2), n6, n4);
            n6 += n3;
        }
        byte[] byArray6 = new byte[n2];
        Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray6), 0, n2);
        return byArray6;
    }
}

