/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSingle;

public class PngChunkBKGD
extends PngChunkSingle {
    public static final String ID = "bKGD";
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;

    public PngChunkBKGD(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = null;
        if (this.imgInfo.greyscale) {
            chunkRaw = this.createEmptyChunk(2, true);
            PngHelperInternal.writeInt2tobytes(this.a, chunkRaw.data, 0);
        } else if (this.imgInfo.indexed) {
            chunkRaw = this.createEmptyChunk(1, true);
            chunkRaw.data[0] = (byte)this.e;
        } else {
            chunkRaw = this.createEmptyChunk(6, true);
            PngHelperInternal.writeInt2tobytes(this.b, chunkRaw.data, 0);
            PngHelperInternal.writeInt2tobytes(this.c, chunkRaw.data, 0);
            PngHelperInternal.writeInt2tobytes(this.d, chunkRaw.data, 0);
        }
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (this.imgInfo.greyscale) {
            this.a = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 0);
        } else if (this.imgInfo.indexed) {
            this.e = chunkRaw.data[0] & 0xFF;
        } else if (chunkRaw.data.length >= 6) {
            this.b = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 0);
            this.c = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 2);
            this.d = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 4);
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkBKGD pngChunkBKGD = (PngChunkBKGD)pngChunk;
        this.a = pngChunkBKGD.a;
        this.b = pngChunkBKGD.b;
        this.c = pngChunkBKGD.b;
        this.d = pngChunkBKGD.b;
        this.e = pngChunkBKGD.e;
    }

    public void setGray(int n2) {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only gray images support this");
        }
        this.a = n2;
    }

    public int getGray() {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only gray images support this");
        }
        return this.a;
    }

    public void setPaletteIndex(int n2) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed (pallete) images support this");
        }
        this.e = n2;
    }

    public int getPaletteIndex() {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed (pallete) images support this");
        }
        return this.e;
    }

    public void setRGB(int n2, int n3, int n4) {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.b = n2;
        this.c = n3;
        this.d = n4;
    }

    public int[] getRGB() {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return new int[]{this.b, this.c, this.d};
    }
}

