/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.core.System.Drawing.Imaging.c;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.AwtUtils;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ResolutionSetting;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.PngImage;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.imageoptions.PngOptions;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class AsposePngImageWriter
extends ImageWriter {
    private Stream a = null;
    private int b;
    private int c;
    private float d;
    private float e;

    public AsposePngImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    @Override
    public void setOutput(Object object) {
        if (object instanceof Stream) {
            this.a = (Stream)object;
        } else if (object != null) {
            throw new IllegalArgumentException("Illegal output type!");
        }
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        Object object;
        if (this.a == null) {
            throw new InvalidOperationException("output == null!");
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        BufferedImage bufferedImage = (BufferedImage)iIOImage.getRenderedImage();
        this.c = (Integer)(bufferedImage.getProperty("bitspPixel").equals(BufferedImage.UndefinedProperty) ? Integer.valueOf(bufferedImage.getColorModel().getPixelSize()) : bufferedImage.getProperty("bitspPixel"));
        this.b = (Integer)(bufferedImage.getProperty("pixelFormat").equals(BufferedImage.UndefinedProperty) ? Integer.valueOf(139273) : bufferedImage.getProperty("pixelFormat"));
        Object object2 = bufferedImage.getProperty("dpiX");
        if (object2 != BufferedImage.UndefinedProperty) {
            this.d = ((Float)object2).floatValue();
        }
        if ((object = bufferedImage.getProperty("dpiY")) != BufferedImage.UndefinedProperty) {
            this.e = ((Float)object).floatValue();
        }
        if (this.c == 48 || this.c == 64) {
            this.a(iIOMetadata, iIOImage, imageWriteParam);
            return;
        }
        bufferedImage = this.a(bufferedImage);
        this.a(bufferedImage, iIOImage.getMetadata());
    }

    private void a(BufferedImage bufferedImage, IIOMetadata iIOMetadata) {
        PngImage pngImage = new PngImage(bufferedImage.getWidth(), bufferedImage.getHeight());
        PngOptions pngOptions = this.b(bufferedImage, iIOMetadata);
        pngImage.setPalette(pngOptions.getPalette());
        pngImage.setTransparentColor(bufferedImage.getColorModel().hasAlpha());
        Rectangle rectangle = pngImage.getBounds();
        try {
            pngImage.saveArgb32Pixels(rectangle, AwtUtils.getColors(bufferedImage));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            int n2 = rectangle.getHeight() / 4;
            int n3 = 0;
            while (n3 < rectangle.getHeight()) {
                Rectangle rectangle2 = new Rectangle(0, n3, rectangle.getWidth(), n2);
                pngImage.saveArgb32Pixels(rectangle2, AwtUtils.getColors(bufferedImage, rectangle2));
                if ((n3 += n2) + n2 <= rectangle.getHeight()) continue;
                n2 = rectangle.getHeight() - n3;
            }
        }
        PngImage.savePng(this.a, pngImage, pngOptions);
    }

    private PngOptions b(BufferedImage bufferedImage, IIOMetadata iIOMetadata) {
        Object object;
        PngOptions pngOptions = new PngOptions();
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            pngOptions.setColorType(3);
            pngOptions.setBitDepth((byte)bufferedImage.getColorModel().getPixelSize());
            object = (IndexColorModel)bufferedImage.getColorModel();
            int[] nArray = new int[((IndexColorModel)object).getMapSize()];
            ((IndexColorModel)object).getRGBs(nArray);
            pngOptions.setPalette(new ColorPalette(nArray));
        } else if (!bufferedImage.getColorModel().hasAlpha()) {
            pngOptions.setColorType(2);
            pngOptions.setBitDepth((byte)bufferedImage.getColorModel().getComponentSize(0));
        } else {
            pngOptions.setColorType(6);
            pngOptions.setBitDepth((byte)bufferedImage.getColorModel().getComponentSize(0));
        }
        object = new ResolutionSetting();
        ((ResolutionSetting)object).setHorizontalResolution(this.d);
        ((ResolutionSetting)object).setVerticalResolution(this.e);
        if (((ResolutionSetting)object).getHorizontalResolution() != 0.0 || ((ResolutionSetting)object).getVerticalResolution() != 0.0) {
            pngOptions.setResolutionSettings((ResolutionSetting)object);
        }
        return pngOptions;
    }

    private BufferedImage a(BufferedImage bufferedImage) {
        if (this.b(bufferedImage)) {
            return com.aspose.html.utils.ms.core.System.Drawing.Imaging.c.c(bufferedImage);
        }
        return bufferedImage;
    }

    private boolean b(BufferedImage bufferedImage) {
        return this.c == 16 || this.c == 32 && bufferedImage.getColorModel().getNumColorComponents() == 3 && this.b == 139273 || this.b == 8207;
    }

    private void a(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(this.a.toOutputStream());
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("PNG").next();
        imageWriter.setOutput(memoryCacheImageOutputStream);
        imageWriter.write(iIOMetadata, iIOImage, imageWriteParam);
        memoryCacheImageOutputStream.flush();
    }
}

