/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataType;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffCommonArrayType;
import com.aspose.html.utils.ms.lang.Operators;

public final class TiffSByteType
extends TiffCommonArrayType {
    private byte[] a;

    public TiffSByteType(int n2) {
        super(n2);
    }

    public byte[] getValues() {
        return this.a;
    }

    public void setValues(byte[] byArray) {
        this.a = byArray;
    }

    @Override
    public Array getValuesContainer() {
        return Array.boxing(this.a);
    }

    @Override
    public long getElementSize() {
        return 1L;
    }

    @Override
    public int getTagType() {
        return 6;
    }

    @Override
    public Object getValue() {
        return this.a;
    }

    @Override
    public void setValue(Object object) {
        if (object != null && !Operators.is(object, byte[].class)) {
            throw new ArgumentException("Only signed byte array is supported.");
        }
        this.a = Operators.as(object, byte[].class);
    }

    @Override
    public long writeAdditionalData(TiffStream tiffStream) {
        if (tiffStream == null) {
            throw new ArgumentNullException("dataStream");
        }
        long l2 = 0L;
        if (this.a != null && this.a.length > 4) {
            tiffStream.writeSByteArray(this.a);
            l2 = Operators.castToUInt32(this.a.length, 9);
        }
        return l2;
    }

    @Override
    public void readData(TiffStream tiffStream, long l2) {
        if (Operators.castToUInt32(l2, 10) <= 4L) {
            this.a = tiffStream.readSByteArrayUInt32(l2);
        } else {
            long l3 = tiffStream.readULong();
            tiffStream.seek(Operators.castToInt64(l3, 10), 0);
            this.a = tiffStream.readSByteArrayUInt32(l2);
        }
    }

    @Override
    public TiffDataType createInstance() {
        return new TiffSByteType(this.getTagId());
    }

    @Override
    public void copyInstanceData(TiffDataType tiffDataType) {
        ((TiffSByteType)tiffDataType).a = ArrayHelper.copySByte(this.a);
        super.copyInstanceData(tiffDataType);
    }

    @Override
    protected void writeTagValue(TiffStream tiffStream) {
        tiffStream.writeSByteArray(this.a);
        tiffStream.write(new byte[4 - this.a.length]);
    }
}

