/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.UInt32Extensions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.MathHelpers;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exceptions.ImageSaveException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.TiffImageException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffDataTypes;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffTags;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.instancefactory.TiffTagFactory;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffUnknownType;
import com.aspose.html.utils.ms.lang.Operators;

public abstract class TiffDataType
implements Comparable {
    private int a;

    public TiffDataType(int n2) {
        this.a = n2;
    }

    public abstract long getCount();

    public int getId() {
        return this.a;
    }

    public int getTagId() {
        return Operators.castToInt32(this.a, 8);
    }

    public abstract int getTagType();

    public long getAlignedDataSize() {
        return MathHelpers.ensureWordBoundary(this.getDataSize());
    }

    public abstract long getDataSize();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public boolean isValid() {
        return Operators.castToUInt32(this.getCount(), 10) > 0L;
    }

    boolean isPrivate() {
        return Operators.castToUInt16(this.a, 8) > 32768;
    }

    public static TiffDataType readTag(TiffStream tiffStream) {
        TiffDataType tiffDataType;
        if (tiffStream == null) {
            throw new ArgumentNullException("dataStream");
        }
        TiffStream tiffStream2 = tiffStream;
        int n2 = 0;
        try {
            n2 = tiffStream2.readUShort();
            int n3 = tiffStream2.readUShort();
            long l2 = tiffStream2.readULong();
            tiffDataType = TiffTagFactory.createInstance(n3, n2);
            if (tiffDataType == null) {
                long l3 = tiffStream2.readULong();
                tiffDataType = new TiffUnknownType(tiffStream, n3, n2, l2, l3);
            }
            tiffDataType.a = n2;
            if (!Operators.is(tiffDataType, TiffUnknownType.class)) {
                tiffDataType.readData(tiffStream, l2);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new FrameworkException(StringExtensions.concat("Unable to read values for ", Int32Extensions.toString(Operators.castToInt32(n2, 8)), " tag. Message : ", runtimeException.getMessage()));
        }
        return tiffDataType;
    }

    public int compareTo(Object object) {
        if (!Operators.is(object, TiffDataType.class)) {
            throw new TiffImageException("Expected TiffDataType type.");
        }
        TiffDataType tiffDataType = (TiffDataType)object;
        return Operators.castToInt32(this.a, 8) - Operators.castToInt32(tiffDataType.a, 8);
    }

    public TiffDataType deepClone() {
        TiffDataType tiffDataType = this.createInstance();
        this.copyInstanceData(tiffDataType);
        return tiffDataType;
    }

    public void writeTag(TiffStream tiffStream, long l2) {
        if (tiffStream == null) {
            throw new ArgumentNullException("dataStream");
        }
        try {
            tiffStream.writeUShort(this.a);
            tiffStream.writeUShort(this.getTagType());
            long l3 = this.getCount();
            tiffStream.writeULong(l3);
            this.writeTagValueOrOffset(tiffStream, l2);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException(StringExtensions.concat("Unable to Write values for ", Enum.getName(TiffDataTypes.class, this.getTagType()), " Message : ", runtimeException.getMessage()));
        }
    }

    public abstract long writeAdditionalData(TiffStream var1);

    public String toString() {
        String string = null;
        Object object = this.getValue();
        if (Operators.is(object, Array.class)) {
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            msStringBuilder2.append('{');
            Array array = Operators.as(object, Array.class);
            for (int i2 = 0; i2 < array.getLength(); ++i2) {
                if (i2 < array.getLength() - 1) {
                    msStringBuilder2.appendFormat("{0}, ", array.getValue(i2));
                    continue;
                }
                msStringBuilder2.append(array.getValue(i2));
                msStringBuilder2.append('}');
            }
            string = msStringBuilder2.toString();
        } else if (this.getValue() != null) {
            string = this.getValue().toString();
        }
        return StringExtensions.concat("Tag: ", Enum.getName(TiffTags.class, this.getTagId()), " Type: ", Enum.getName(TiffDataTypes.class, this.getTagType()), " Count: ", UInt32Extensions.toString(this.getCount()), " Value: ", string);
    }

    protected abstract void readData(TiffStream var1, long var2);

    protected abstract void writeTagValueOrOffset(TiffStream var1, long var2);

    public void copyInstanceData(TiffDataType tiffDataType) {
        tiffDataType.a = this.a;
    }

    protected abstract TiffDataType createInstance();
}

