/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.IO.MemoryStream;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.RasterCachedImage;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.RasterImagePixelLoader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.TransparentColorRenderProcessor;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.JpegException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exif.JpegExifData;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.internal.CacheImage;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.AdobeApp14Segment;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.IccSegment;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JFIFData;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegDataWriter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegSaver;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.encodingcontrollers.JpegEncodingController;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffRational;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffBigEndianStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.imageoptions.JpegOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.sources.StreamSource;
import com.aspose.html.utils.ms.lang.Operators;
import java.awt.image.RenderedImage;

public final class JpegImage
extends RasterCachedImage {
    private int a;
    private JpegOptions b;
    private int c;
    private boolean d;
    private StreamSource e;
    private StreamSource f;

    public JpegImage(int n2, int n3, RenderedImage renderedImage) {
        this(n2, n3);
        CacheImage cacheImage = new CacheImage(this.getWidth(), this.getHeight(), renderedImage);
        cacheImage.setPalette(this.getPalette());
        this.replaceDataReader(cacheImage);
    }

    public JpegImage(int n2, int n3) {
        this(new JpegOptions(), n2, n3);
    }

    public JpegImage(JpegOptions jpegOptions, int n2, int n3) {
        this.b = jpegOptions;
        this.c = n2;
        this.a = n3;
    }

    public JpegImage(int n2, int n3, int n4, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        this.a(iRasterImageArgb32PixelLoader, n2, n3);
        switch (n4) {
            case 0: {
                this.b.setColorType(0);
                break;
            }
            case 1: {
                this.b.setColorType(4);
                break;
            }
            case 3: {
                this.b.setColorType(1);
                break;
            }
            case 4: {
                this.b.setColorType(2);
                break;
            }
            case 5: {
                this.b.setColorType(3);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("pixelFormat");
            }
        }
    }

    public JpegOptions getJpegOptions() {
        return this.b;
    }

    @Override
    public int getBitsPerPixel() {
        return 8 * this.getRawDataFormat().getChannelsCount();
    }

    public String getComment() {
        return this.b.getComment();
    }

    public void setComment(String string) {
        this.b.setComment(string);
    }

    public JpegExifData getExifData() {
        return this.b.getExifData();
    }

    public void setExifData(JpegExifData jpegExifData) {
        this.b.setExifData(jpegExifData);
    }

    @Override
    public int getHeight() {
        return this.a;
    }

    @Override
    public double getHorizontalResolution() {
        if (this.getExifData() != null && this.getExifData().getXResolution() != null && this.getExifData().getYResolution() != null) {
            return this.getExifData().getXResolution().getValueD();
        }
        return this.getJfif() != null ? (double)this.getJfif().getXDensity() : 0.0;
    }

    @Override
    public void setHorizontalResolution(double d2) {
        throw new InvalidOperationException("JpegException: Use Jfif or ExifData for storing resolution.");
    }

    public JFIFData getJfif() {
        return this.b.getJfif();
    }

    public void setJfif(JFIFData jFIFData) {
        this.b.setJfif(jFIFData);
    }

    @Override
    public PixelDataFormat getRawDataFormat() {
        return JpegImage.getPixelDataFormat(this.b.getColorType());
    }

    @Override
    public double getVerticalResolution() {
        if (this.getExifData() != null && this.getExifData().getXResolution() != null && this.getExifData().getYResolution() != null) {
            return this.getExifData().getYResolution().getValueD();
        }
        return this.getJfif() != null ? (double)this.getJfif().getYDensity() : 0.0;
    }

    @Override
    public void setVerticalResolution(double d2) {
        throw new InvalidOperationException("FrameworkException: Use Jfif or ExifData for storing resolution.");
    }

    @Override
    public int getWidth() {
        return this.c;
    }

    public StreamSource getRGBColorProfile() {
        return this.e;
    }

    public void setRGBColorProfile(StreamSource streamSource) {
        this.e = streamSource;
    }

    public StreamSource getCMYKColorProfile() {
        return this.f;
    }

    public void setCMYKColorProfile(StreamSource streamSource) {
        this.f = streamSource;
    }

    public StreamSource getDestinationRGBColorProfile() {
        return this.b.getRGBColorProfile();
    }

    public void setDestinationRGBColorProfile(StreamSource streamSource) {
        this.b.setRGBColorProfile(streamSource);
    }

    public StreamSource getDestinationCMYKColorProfile() {
        return this.b.getCMYKColorProfile();
    }

    public void setDestinationCMYKColorProfile(StreamSource streamSource) {
        this.b.setCMYKColorProfile(streamSource);
    }

    public boolean getIgnoreEmbeddedColorProfile() {
        return this.d;
    }

    public void setIgnoreEmbeddedColorProfile(boolean bl2) {
        this.d = bl2;
    }

    public void autoRotate() {
        if (this.getExifData() != null) {
            switch (this.getExifData().getOrientation()) {
                case 1: {
                    break;
                }
                case 2: {
                    this.rotateFlip(4);
                    break;
                }
                case 3: {
                    this.rotateFlip(12);
                    break;
                }
                case 4: {
                    this.rotateFlip(8);
                    break;
                }
                case 5: {
                    this.rotateFlip(5);
                    break;
                }
                case 6: {
                    this.rotateFlip(1);
                    break;
                }
                case 7: {
                    this.rotateFlip(9);
                    break;
                }
                case 8: {
                    this.rotateFlip(13);
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException();
                }
            }
            this.getExifData().setOrientation(1);
        }
    }

    static byte[] app1Data(JpegExifData jpegExifData) {
        byte[] byArray = jpegExifData.serializeExifData();
        if (byArray.length > 65528) {
            throw new JpegException("Exif segment is excessively big to be stored in jpeg file. Consider JpegExifData.SerializeExifData() method for result data size estimation.");
        }
        TiffBigEndianStream tiffBigEndianStream = new TiffBigEndianStream(new MemoryStream());
        tiffBigEndianStream.writeByte((byte)-1);
        tiffBigEndianStream.writeByte((byte)-31);
        tiffBigEndianStream.writeUShort(Operators.castToUInt16(byArray.length + 8, 9));
        byte[] byArray2 = new byte[]{69, 120, 105, 102, 0, 0};
        tiffBigEndianStream.write(byArray2);
        tiffBigEndianStream.write(byArray);
        byte[] byArray3 = tiffBigEndianStream.toBytes();
        return byArray3;
    }

    public static void saveJpeg(RasterImage rasterImage, Stream stream, JFIFData jFIFData, JpegExifData jpegExifData, JpegOptions jpegOptions) {
        Object object;
        Object object2;
        JpegStream jpegStream = new JpegStream(stream);
        JpegImage.saveJpegHeader(jpegStream);
        if (jpegOptions.getResolutionSettings() != null) {
            if (jpegExifData != null) {
                jpegExifData.setXResolution(new TiffRational(Operators.castToUInt32(jpegOptions.getResolutionSettings().getHorizontalResolution(), 14), 1L));
                jpegExifData.setYResolution(new TiffRational(Operators.castToUInt32(jpegOptions.getResolutionSettings().getVerticalResolution(), 14), 1L));
                jpegExifData.setResolutionUnit(2);
            } else {
                if (jFIFData == null) {
                    jFIFData = new JFIFData();
                }
                jFIFData.setXDensity(Operators.castToInt16(jpegOptions.getResolutionSettings().getHorizontalResolution(), 14));
                jFIFData.setYDensity(Operators.castToInt16(jpegOptions.getResolutionSettings().getVerticalResolution(), 14));
            }
        }
        if (jFIFData != null) {
            JFIFData.write(jFIFData, jpegStream);
        }
        JpegImage.saveExif(jpegStream, jpegExifData);
        if (jpegOptions.getColorType() == 3) {
            object2 = jpegOptions.getCMYKColorProfile() != null ? jpegOptions.getCMYKColorProfile().getStream() : IccProfileHelper.getDefaultCmykProfile().getStream();
            IccSegment.iccSegments((Stream)object2, stream);
            object = new AdobeApp14Segment();
            ((AdobeApp14Segment)object).setVersion(100);
            ((AdobeApp14Segment)object).setFlags0(0);
            ((AdobeApp14Segment)object).setFlags1(0);
            ((AdobeApp14Segment)object).setTransform((byte)2);
            AdobeApp14Segment.write(stream, (AdobeApp14Segment)object);
            jpegOptions.setCMYKColorProfile(new StreamSource((Stream)object2));
            if (jpegOptions.getRGBColorProfile() == null) {
                jpegOptions.setRGBColorProfile(IccProfileHelper.getDefaultRGBProfile());
            }
        }
        if (jpegOptions.getColorType() == 4) {
            object2 = new AdobeApp14Segment();
            ((AdobeApp14Segment)object2).setVersion(100);
            ((AdobeApp14Segment)object2).setFlags0(0);
            ((AdobeApp14Segment)object2).setFlags1(0);
            ((AdobeApp14Segment)object2).setTransform((byte)0);
            AdobeApp14Segment.write(stream, (AdobeApp14Segment)object2);
        }
        object2 = new RawDataSettings();
        object = JpegImage.getPixelDataFormat(jpegOptions.getColorType());
        JpegEncodingController jpegEncodingController = new JpegEncodingController(rasterImage.getBounds().Clone(), jpegOptions, jpegStream, (PixelDataFormat)object);
        JpegSaver jpegSaver = new JpegSaver(jpegStream, jpegOptions, rasterImage, (PixelDataFormat)object, jpegEncodingController);
        ((RawDataSettings)object2).setPixelDataFormat((PixelDataFormat)object);
        JpegDataWriter jpegDataWriter = JpegDataWriter.getWriter(jpegSaver, jpegOptions);
        if (rasterImage.isRawDataAvailable() && rasterImage.getDitheringSettings() == null && jpegOptions.getColorType() != 3) {
            ((RawDataSettings)object2).setColorPalette(null);
            ((RawDataSettings)object2).setCustomColorConverter(rasterImage.getRawCustomColorConverter());
            ((RawDataSettings)object2).setDitheringMethod(rasterImage.getRawDitheringMethod());
            ((RawDataSettings)object2).setFallbackIndex(rasterImage.getRawFallbackIndex());
            ((RawDataSettings)object2).setIndexedColorConverter(rasterImage.getRawIndexedColorConverter());
            ((RawDataSettings)object2).setLineSize(rasterImage.getWidth() * ((RawDataSettings)object2).getPixelDataFormat().getChannelsCount());
            rasterImage.loadRawData(rasterImage.getBounds().Clone(), (RawDataSettings)object2, jpegSaver);
        } else if (rasterImage.hasTransparentColor()) {
            TransparentColorRenderProcessor transparentColorRenderProcessor = new TransparentColorRenderProcessor(rasterImage.getTransparentColor(), rasterImage.getBackgroundColor(), jpegDataWriter);
            rasterImage.loadPartialArgb32Pixels(rasterImage.getBounds().Clone(), transparentColorRenderProcessor);
        } else {
            rasterImage.loadPartialArgb32Pixels(rasterImage.getBounds().Clone(), jpegDataWriter);
        }
        JpegImage.writeImageTail(jpegStream);
    }

    public static PixelDataFormat getPixelDataFormat(int n2) {
        PixelDataFormat pixelDataFormat;
        switch (n2) {
            case 0: {
                pixelDataFormat = PixelDataFormat.getGrayscale();
                break;
            }
            case 1: {
                pixelDataFormat = PixelDataFormat.getYCbCr();
                break;
            }
            case 2: {
                pixelDataFormat = PixelDataFormat.getCMYK();
                break;
            }
            case 4: {
                pixelDataFormat = PixelDataFormat.getRgb24Bpp();
                break;
            }
            case 3: {
                pixelDataFormat = PixelDataFormat.getYcck();
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("colorType");
            }
        }
        return pixelDataFormat;
    }

    @Override
    public void saveData(Stream stream) {
        JpegImage.saveJpeg(this, stream, this.getJfif(), this.getExifData(), this.b);
    }

    @Override
    public void updateDimensions(int n2, int n3) {
        this.c = n2;
        this.a = n3;
    }

    public static void saveExif(StreamContainer streamContainer, JpegExifData jpegExifData) {
        if (jpegExifData == null) {
            return;
        }
        byte[] byArray = JpegImage.app1Data(jpegExifData);
        streamContainer.write(byArray, 0, byArray.length);
    }

    public static void saveJpegHeader(StreamContainer streamContainer) {
        streamContainer.writeByte((byte)-1);
        streamContainer.writeByte((byte)-40);
    }

    public static void writeImageTail(JpegStream jpegStream) {
        jpegStream.writeByte((byte)-1);
        jpegStream.writeByte((byte)-39);
    }

    private void a(RasterImagePixelLoader rasterImagePixelLoader) {
        this.a(rasterImagePixelLoader, rasterImagePixelLoader.getRasterImage().getWidth(), rasterImagePixelLoader.getRasterImage().getHeight());
    }

    private void a(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n2, int n3) {
        this.setDataLoader(iRasterImageArgb32PixelLoader);
        this.c = n2;
        this.a = n3;
        this.b = new JpegOptions();
    }

    public static void printMemoryStatus(String string) {
    }
}

