/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IIndexedColorConverter;
import com.aspose.html.utils.ms.lang.Operators;

public abstract class ColorConverter {
    public final Rectangle DesiredRectangle = new Rectangle();
    public final int DestinationEndBit;
    public final int DestinationEndByte;
    public final PixelDataFormat DestinationFormat;
    public final int DestinationLineSize;
    public final int DestinationPixelSize;
    public final int DestinationStartBit;
    public final int DestinationStartByte;
    public final int Height;
    public final int LineSize;
    public final int RightmostDestinationByte;
    public final PixelDataFormat SourceFormat;
    public final int SourcePixelSize;
    public final int Width;
    private final int a;

    protected ColorConverter(int n2, int n3, int n4, PixelDataFormat pixelDataFormat, Rectangle rectangle, PixelDataFormat pixelDataFormat2, int n5) {
        this.Width = n2;
        this.Height = n3;
        this.LineSize = n4;
        this.SourceFormat = pixelDataFormat;
        rectangle.CloneTo(this.DesiredRectangle);
        this.DestinationLineSize = n5;
        this.DestinationFormat = pixelDataFormat2;
        this.DestinationPixelSize = pixelDataFormat2.getBitsPerPixel();
        this.DestinationStartBit = this.DesiredRectangle.getLeft() * this.DestinationPixelSize;
        this.DestinationEndBit = this.DesiredRectangle.getRight() * this.DestinationPixelSize - 1;
        this.DestinationStartByte = this.DestinationStartBit / 8;
        this.DestinationEndByte = this.DestinationEndBit / 8;
        int n6 = this.DestinationEndByte - this.DestinationStartByte + 1;
        if (n5 < n6) {
            throw new ArgumentOutOfRangeException("destinationLineSize", StringExtensions.concat("Expected at least ", Int32Extensions.toString(n6), " bytes for the line size, otherwise the destination data does not fit."));
        }
        this.SourcePixelSize = pixelDataFormat.getBitsPerPixel();
        int n7 = (this.SourcePixelSize * this.Width + 7) / 8;
        if (n4 < n7) {
            throw new ArgumentOutOfRangeException("lineSize", StringExtensions.concat("Expected at least ", Int32Extensions.toString(n7), " bytes for the line size, otherwise the source data does not fit."));
        }
        this.RightmostDestinationByte = (n2 * this.DestinationPixelSize - 1) / 8;
        this.a = (this.DesiredRectangle.getRight() * this.SourcePixelSize - 1) / 8;
    }

    public int convert(Rectangle rectangle, byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (byArray == null) {
            throw new ArgumentNullException("data");
        }
        if (byArray.length - n2 <= 0 || byArray.length - n2 > byArray.length) {
            throw new ArgumentOutOfRangeException("dataOffset", "Incorrect data offset.");
        }
        if (byArray2 == null) {
            throw new ArgumentNullException("outputData");
        }
        if (byArray2.length - n3 < 0 || byArray2.length - n3 > byArray2.length) {
            throw new ArgumentOutOfRangeException("outputDataOffset", "Incorrect output data offset.");
        }
        int n4 = 0;
        Rectangle rectangle2 = Rectangle.intersect(this.DesiredRectangle.Clone(), rectangle.Clone()).Clone();
        int n5 = rectangle2.getWidth();
        int n6 = rectangle2.getHeight();
        int n7 = rectangle2.getLeft();
        int n8 = rectangle.getLeft();
        if (n5 > 0 && n6 > 0) {
            int n9 = n7 * this.SourcePixelSize;
            int n10 = (rectangle2.getTop() - rectangle.getTop()) * this.LineSize;
            int n11 = n9 / 8 - n8 * this.SourcePixelSize / 8;
            int n12 = n11 + n10 + n2;
            int n13 = this.getDestinationLineBytesCount(n9, n5, n6);
            n4 = n13 * n6;
            if (byArray2.length - n3 < n4) {
                String string = StringExtensions.format("Not enough data to convert to, expected {0} bytes but got only {1} free bytes", Operators.boxing(n4), Operators.boxing(byArray2.length - n3));
                throw new ArgumentOutOfRangeException("outputData", string);
            }
            this.convert(byArray, n12, n9, n5, n6, byArray2, n3, n13);
        }
        return n4;
    }

    protected static IColorPalette correctPaletteEntries(IColorPalette iColorPalette, int n2) {
        int n3 = (int)msMath.pow(2.0, n2);
        IColorPalette iColorPalette2 = iColorPalette;
        if (iColorPalette.getEntriesCount() < n3) {
            int[] nArray = iColorPalette.getArgb32Entries();
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            iColorPalette2 = new ColorPalette(nArray2);
        }
        return iColorPalette2;
    }

    protected static byte[] getConversionMap(IIndexedColorConverter iIndexedColorConverter, PixelDataFormat pixelDataFormat, PixelDataFormat pixelDataFormat2, int n2, int n3) {
        if (iIndexedColorConverter == null) {
            throw new ArgumentNullException("indexedConverter");
        }
        byte[] byArray = new byte[n2];
        iIndexedColorConverter.fillIndexedtoIndexedMap(byArray, pixelDataFormat, pixelDataFormat2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((byArray[i2] & 0xFF) < n3) continue;
            throw new ArgumentOutOfRangeException("indexedConverter", StringExtensions.concat("The converted value at map index ", Int32Extensions.toString(i2), " is not valid since it goes out of destination entries range."));
        }
        return byArray;
    }

    protected abstract void convert(byte[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8);

    protected int getDestinationLineBytesCount(int n2, int n3, int n4) {
        int n5 = n2 / this.SourcePixelSize * this.DestinationPixelSize;
        int n6 = n5 / 8;
        int n7 = (n5 + n3 * this.DestinationPixelSize - 1) / 8;
        int n8 = n7 - n6 + 1;
        if (n6 == 0 && n7 == this.RightmostDestinationByte && n4 > 1) {
            n8 = this.DestinationLineSize;
        } else {
            int n9;
            int n10;
            int n11 = this.SourcePixelSize / this.DestinationPixelSize;
            if (n11 > 1 && (n10 = (n9 = n2 + n3 * this.SourcePixelSize - 1) / 8) % n11 < n11 - 1 && n10 != this.a) {
                --n8;
            }
        }
        return n8;
    }
}

