/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.PointF;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.SizeF;
import com.aspose.html.utils.ms.lang.Struct;

public class RectangleF
extends Struct<RectangleF> {
    private static final RectangleF a = new RectangleF();
    private float b;
    private float c;
    private float d;
    private float e;

    public RectangleF() {
    }

    public RectangleF(float f2, float f3, float f4, float f5) {
        this.d = f2;
        this.e = f3;
        this.c = f4;
        this.b = f5;
    }

    public RectangleF(PointF pointF, SizeF sizeF) {
        this.d = pointF.getX();
        this.e = pointF.getY();
        this.c = sizeF.getWidth();
        this.b = sizeF.getHeight();
    }

    public static RectangleF getEmpty() {
        return a;
    }

    public PointF getLocation() {
        return new PointF(this.getX(), this.getY());
    }

    public void setLocation(PointF pointF) {
        this.setX(pointF.getX());
        this.setY(pointF.getY());
    }

    public SizeF getSize() {
        return new SizeF(this.getWidth(), this.getHeight());
    }

    public void setSize(SizeF sizeF) {
        this.setWidth(sizeF.getWidth());
        this.setHeight(sizeF.getHeight());
    }

    public float getX() {
        return this.d;
    }

    public void setX(float f2) {
        this.d = f2;
    }

    public float getY() {
        return this.e;
    }

    public void setY(float f2) {
        this.e = f2;
    }

    public float getWidth() {
        return this.c;
    }

    public void setWidth(float f2) {
        this.c = f2;
    }

    public float getHeight() {
        return this.b;
    }

    public void setHeight(float f2) {
        this.b = f2;
    }

    public float getLeft() {
        return this.getX();
    }

    public void setLeft(float f2) {
        float f3 = f2 - this.d;
        this.d = f2;
        this.c -= f3;
    }

    public float getTop() {
        return this.getY();
    }

    public void setTop(float f2) {
        float f3 = f2 - this.e;
        this.e = f2;
        this.b -= f3;
    }

    public float getRight() {
        return this.getX() + this.getWidth();
    }

    public void setRight(float f2) {
        float f3 = f2 - this.getRight();
        this.c += f3;
    }

    public float getBottom() {
        return this.getY() + this.getHeight();
    }

    public void setBottom(float f2) {
        float f3 = f2 - this.getBottom();
        this.b += f3;
    }

    public boolean isEmpty() {
        if (this.getWidth() > 0.0f) {
            return this.getHeight() <= 0.0f;
        }
        return true;
    }

    public static RectangleF fromPoints(PointF pointF, PointF pointF2) {
        float f2 = msMath.min(pointF.getX(), pointF2.getX());
        float f3 = msMath.max(pointF.getX(), pointF2.getX());
        float f4 = msMath.min(pointF.getY(), pointF2.getY());
        float f5 = msMath.max(pointF.getY(), pointF2.getY());
        return RectangleF.fromLeftTopRightBottom(f2, f4, f3, f5);
    }

    public static RectangleF inflate(RectangleF rectangleF, float f2, float f3) {
        RectangleF rectangleF2 = rectangleF.Clone();
        rectangleF2.inflate(f2, f3);
        return rectangleF2;
    }

    public static RectangleF intersect(RectangleF rectangleF, RectangleF rectangleF2) {
        float f2 = msMath.max(rectangleF.getX(), rectangleF2.getX());
        float f3 = msMath.min(rectangleF.getX() + rectangleF.getWidth(), rectangleF2.getX() + rectangleF2.getWidth());
        float f4 = msMath.max(rectangleF.getY(), rectangleF2.getY());
        float f5 = msMath.min(rectangleF.getY() + rectangleF.getHeight(), rectangleF2.getY() + rectangleF2.getHeight());
        if (f3 >= f2 && f5 >= f4) {
            return new RectangleF(f2, f4, f3 - f2, f5 - f4);
        }
        return a;
    }

    public static RectangleF union(RectangleF rectangleF, RectangleF rectangleF2) {
        float f2 = msMath.min(rectangleF.getX(), rectangleF2.getX());
        float f3 = msMath.max(rectangleF.getX() + rectangleF.getWidth(), rectangleF2.getX() + rectangleF2.getWidth());
        float f4 = msMath.min(rectangleF.getY(), rectangleF2.getY());
        float f5 = msMath.max(rectangleF.getY() + rectangleF.getHeight(), rectangleF2.getY() + rectangleF2.getHeight());
        return new RectangleF(f2, f4, f3 - f2, f5 - f4);
    }

    public static boolean op_Equality(RectangleF rectangleF, RectangleF rectangleF2) {
        return rectangleF.getX() == rectangleF2.getX() && rectangleF.getY() == rectangleF2.getY() && rectangleF.getWidth() == rectangleF2.getWidth() && rectangleF.getHeight() == rectangleF2.getHeight();
    }

    public static boolean op_Inequality(RectangleF rectangleF, RectangleF rectangleF2) {
        return !RectangleF.op_Equality(rectangleF, rectangleF2);
    }

    public static RectangleF to_RectangleF(Rectangle rectangle) {
        return new RectangleF(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public static RectangleF fromLeftTopRightBottom(float f2, float f3, float f4, float f5) {
        return new RectangleF(f2, f3, f4 - f2, f5 - f3);
    }

    public void normalize() {
        if (this.c < 0.0f) {
            this.d += this.c;
            this.c = -this.c;
        }
        if (this.b < 0.0f) {
            this.e += this.b;
            this.b = -this.b;
        }
    }

    public boolean contains(float f2, float f3) {
        return this.getX() <= f2 && f2 < this.getX() + this.getWidth() && this.getY() <= f3 && f3 < this.getY() + this.getHeight();
    }

    public boolean contains(PointF pointF) {
        return this.contains(pointF.getX(), pointF.getY());
    }

    public boolean contains(RectangleF rectangleF) {
        return this.getX() <= rectangleF.getX() && rectangleF.getX() + rectangleF.getWidth() <= this.getX() + this.getWidth() && this.getY() <= rectangleF.getY() && rectangleF.getY() + rectangleF.getHeight() <= this.getY() + this.getHeight();
    }

    public void inflate(float f2, float f3) {
        this.setX(this.getX() - f2);
        this.setY(this.getY() - f3);
        this.setWidth(this.getWidth() + 2.0f * f2);
        this.setHeight(this.getHeight() + 2.0f * f3);
    }

    public void inflate(SizeF sizeF) {
        this.inflate(sizeF.getWidth(), sizeF.getHeight());
    }

    public void intersect(RectangleF rectangleF) {
        RectangleF rectangleF2 = RectangleF.intersect(rectangleF.Clone(), this.Clone()).Clone();
        this.setX(rectangleF2.getX());
        this.setY(rectangleF2.getY());
        this.setWidth(rectangleF2.getWidth());
        this.setHeight(rectangleF2.getHeight());
    }

    public boolean intersectsWith(RectangleF rectangleF) {
        return rectangleF.getX() < this.getX() + this.getWidth() && this.getX() < rectangleF.getX() + rectangleF.getWidth() && rectangleF.getY() < this.getY() + this.getHeight() && this.getY() < rectangleF.getY() + rectangleF.getHeight();
    }

    public void offset(PointF pointF) {
        this.offset(pointF.getX(), pointF.getY());
    }

    public void offset(float f2, float f3) {
        this.setX(this.getX() + f2);
        this.setY(this.getY() + f3);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RectangleF)) {
            return false;
        }
        RectangleF rectangleF = ((RectangleF)object).Clone();
        return rectangleF.getX() == this.getX() && rectangleF.getY() == this.getY() && rectangleF.getWidth() == this.getWidth() && rectangleF.getHeight() == this.getHeight();
    }

    public int hashCode() {
        return (int)((long)this.getX() ^ ((long)this.getY() << 13 & 0xFFFFFFFFL | (long)this.getY() >> 19) ^ ((long)this.getWidth() << 26 & 0xFFFFFFFFL | (long)this.getWidth() >> 6) ^ ((long)this.getHeight() << 7 & 0xFFFFFFFFL | (long)this.getHeight() >> 25));
    }

    public String toString() {
        return StringExtensions.format(CultureInfo.getCurrentCulture(), "{{X={0}, Y={1}, Width={2}, Height={3}}}", Float.valueOf(this.d), Float.valueOf(this.e), Float.valueOf(this.c), Float.valueOf(this.b));
    }

    @Override
    public void CloneTo(RectangleF rectangleF) {
        rectangleF.b = this.b;
        rectangleF.c = this.c;
        rectangleF.d = this.d;
        rectangleF.e = this.e;
    }

    @Override
    public RectangleF Clone() {
        RectangleF rectangleF = new RectangleF();
        this.CloneTo(rectangleF);
        return rectangleF;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(RectangleF rectangleF, RectangleF rectangleF2) {
        return rectangleF.equals(rectangleF2);
    }
}

