/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Drawing.Color;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.ColorPaletteCacherUsingAlpha;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorPaletteCacher;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;

public final class ColorPalette
implements IColorPalette {
    private int[] a;
    private ColorPaletteCacher b;
    private boolean c;

    public ColorPalette(int[] nArray, boolean bl2) {
        this.a(nArray, bl2);
    }

    public ColorPalette(int[] nArray) {
        this(nArray, false);
    }

    public ColorPalette(Color[] colorArray) {
        int[] nArray = new int[colorArray.length];
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            nArray[i2] = colorArray[i2].toArgb();
        }
        this.a(nArray, false);
    }

    private void a(int[] nArray, boolean bl2) {
        boolean bl3 = true;
        for (int n2 : nArray) {
            int n3 = n2 >> 24 & 0xFF;
            if (n3 == 255) continue;
            bl3 = false;
            break;
        }
        this.b = bl3 ? new ColorPaletteCacher(nArray) : new ColorPaletteCacherUsingAlpha(nArray);
        this.a = nArray;
        this.c = bl2;
    }

    @Override
    public int getEntriesCount() {
        return this.a.length;
    }

    @Override
    public int[] getArgb32Entries() {
        int[] nArray = ArrayHelper.getColors(this.a.length);
        System.arraycopy(this.a, 0, nArray, 0, this.a.length);
        return nArray;
    }

    @Override
    public Color[] getEntries() {
        Color[] colorArray = new Color[this.a.length];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            colorArray[i2] = Color.fromArgb(this.a[i2]);
        }
        return colorArray;
    }

    @Override
    public boolean isCompactPalette() {
        return this.c;
    }

    public static ColorPalette copyPalette(IColorPalette iColorPalette, boolean bl2) {
        ColorPalette colorPalette = null;
        if (iColorPalette != null) {
            int[] nArray = ArrayHelper.getColors(iColorPalette.getEntriesCount());
            Array.boxing(iColorPalette.getArgb32Entries()).copyTo(Array.boxing(nArray), 0);
            colorPalette = new ColorPalette(nArray, bl2);
        }
        return colorPalette;
    }

    public static ColorPalette copyPalette(IColorPalette iColorPalette) {
        return ColorPalette.copyPalette(iColorPalette, iColorPalette != null ? iColorPalette.isCompactPalette() : false);
    }

    @Override
    public int getNearestColorIndex(int n2) {
        return this.b.getNearestColorIndex(n2);
    }

    @Override
    public int getNearestColorIndex(Color color) {
        return this.getNearestColorIndex(color.toArgb());
    }

    @Override
    public int getArgb32Color(int n2) {
        if (n2 >= this.a.length || n2 < 0) {
            throw new ArgumentOutOfRangeException("index", "The specified index lies out of the entries length.");
        }
        return this.a[n2];
    }

    @Override
    public Color getColor(int n2) {
        return Color.fromArgb(this.getArgb32Color(n2));
    }
}

