/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.utils.ms.System.Collections.ArrayList;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.Xml.Pattern;
import com.aspose.html.utils.ms.System.Xml.UnionPattern;
import com.aspose.html.utils.ms.System.Xml.XPathNavigator;
import com.aspose.html.utils.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.utils.ms.System.Xml.XslTemplate;
import com.aspose.html.utils.ms.System.Xml.XslTransformProcessor;

class XslModedTemplateTable {
    private ArrayList a = new ArrayList();
    private XmlQualifiedName b;
    private boolean c = false;

    public XslModedTemplateTable(XmlQualifiedName xmlQualifiedName) {
        if (xmlQualifiedName == null) {
            throw new InvalidOperationException();
        }
        this.b = xmlQualifiedName;
    }

    public XmlQualifiedName getMode() {
        return this.b;
    }

    public void add(XslTemplate xslTemplate) {
        if (!Double.isNaN(xslTemplate.getPriority())) {
            this.a.addItem(new TemplateWithPriority(xslTemplate, xslTemplate.getPriority()));
        } else {
            this.add(xslTemplate, xslTemplate.getMatch());
        }
    }

    public void add(XslTemplate xslTemplate, Pattern pattern) {
        if (pattern instanceof UnionPattern) {
            this.add(xslTemplate, ((UnionPattern)pattern).p0);
            this.add(xslTemplate, ((UnionPattern)pattern).p1);
            return;
        }
        this.a.addItem(new TemplateWithPriority(xslTemplate, pattern));
    }

    public XslTemplate findMatch(XPathNavigator xPathNavigator, XslTransformProcessor xslTransformProcessor) {
        if (!this.c) {
            this.a.sort();
            this.a.reverse();
            this.c = true;
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            TemplateWithPriority templateWithPriority = (TemplateWithPriority)this.a.get_Item(i2);
            if (!templateWithPriority.matches(xPathNavigator, xslTransformProcessor)) continue;
            return templateWithPriority.Template;
        }
        return null;
    }

    static class TemplateWithPriority
    implements Comparable {
        public double Priority;
        public XslTemplate Template;
        public Pattern Pattern;
        public int TemplateID;

        public TemplateWithPriority(XslTemplate xslTemplate, Pattern pattern) {
            this.Template = xslTemplate;
            this.Pattern = pattern;
            this.Priority = pattern.getDefaultPriority();
            this.TemplateID = xslTemplate.Id;
        }

        public TemplateWithPriority(XslTemplate xslTemplate, double d2) {
            this.Template = xslTemplate;
            this.Pattern = xslTemplate.getMatch();
            this.Priority = d2;
            this.TemplateID = xslTemplate.Id;
        }

        public int compareTo(Object object) {
            TemplateWithPriority templateWithPriority = this;
            TemplateWithPriority templateWithPriority2 = (TemplateWithPriority)object;
            int n2 = Double.compare(templateWithPriority.Priority, templateWithPriority2.Priority);
            if (n2 != 0) {
                return n2;
            }
            int n3 = Int32Extensions.compareTo(templateWithPriority.TemplateID, templateWithPriority2.TemplateID);
            return n3;
        }

        public boolean matches(XPathNavigator xPathNavigator, XslTransformProcessor xslTransformProcessor) {
            return xslTransformProcessor.matches(this.Pattern, xPathNavigator);
        }
    }
}

