/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Collections.ArrayList;
import com.aspose.html.utils.ms.System.Collections.Hashtable;
import com.aspose.html.utils.ms.System.Collections.IDictionaryEnumerator;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.System.Security.XmlSyntaxException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.core.System.Security.b;

public final class SecurityElement {
    private String a;
    private String b;
    private ArrayList c;
    private ArrayList d;
    private static final char[] e = new char[]{' ', '<', '>'};
    private static final char[] f = new char[]{'<', '>'};
    private static final char[] g = new char[]{' ', '<', '>'};
    private static final char[] h = new char[]{'\"', '<', '>'};
    private static final char[] i = new char[]{'<', '>', '\"', '\'', '&'};

    public SecurityElement(String string) {
        this(string, null);
    }

    public SecurityElement(String string, String string2) {
        if (string == null) {
            throw new ArgumentNullException("tag");
        }
        if (!SecurityElement.isValidTag(string)) {
            throw new ArgumentException("Invalid XML string: " + string);
        }
        this.b = string;
        this.setText(string2);
    }

    SecurityElement(SecurityElement securityElement) {
        this.setTag(securityElement.getTag());
        this.setText(securityElement.getText());
        if (securityElement.c != null) {
            for (Object object : securityElement.c) {
                this.addAttribute(((SecurityAttribute)object).a(), ((SecurityAttribute)object).b());
            }
        }
        if (securityElement.d != null) {
            for (Object object : securityElement.d) {
                this.addChild((SecurityElement)object);
            }
        }
    }

    public Hashtable getAttributes() {
        if (this.c == null) {
            return null;
        }
        Hashtable hashtable = new Hashtable(this.c.size());
        for (SecurityAttribute securityAttribute : this.c) {
            hashtable.addItem(securityAttribute.a(), securityAttribute.b());
        }
        return hashtable;
    }

    public void setAttributes(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            this.c.clear();
            return;
        }
        if (this.c == null) {
            this.c = new ArrayList();
        } else {
            this.c.clear();
        }
        IDictionaryEnumerator iDictionaryEnumerator = hashtable.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.c.addItem(new SecurityAttribute((String)iDictionaryEnumerator.getKey(), (String)iDictionaryEnumerator.getValue()));
        }
    }

    public ArrayList getChildren() {
        return this.d;
    }

    public void setChildren(ArrayList arrayList) {
        if (arrayList != null) {
            for (Object e2 : arrayList) {
                if (e2 != null) continue;
                throw new ArgumentNullException();
            }
        }
        this.d = arrayList;
    }

    public String getTag() {
        return this.b;
    }

    public void setTag(String string) {
        if (string == null) {
            throw new ArgumentNullException("Tag");
        }
        if (!SecurityElement.isValidTag(string)) {
            throw new ArgumentException("Invalid XML string: " + string);
        }
        this.b = string;
    }

    public String getText() {
        return this.a;
    }

    public void setText(String string) {
        if (string != null && !SecurityElement.isValidText(string)) {
            throw new ArgumentException("Invalid XML string: " + string);
        }
        this.a = SecurityElement.c(string);
    }

    public void addAttribute(String string, String string2) {
        if (string == null) {
            throw new ArgumentNullException("name");
        }
        if (string2 == null) {
            throw new ArgumentNullException("value");
        }
        if (this.a(string) != null) {
            throw new ArgumentException(StringExtensions.concat("Duplicate attribute : ", string));
        }
        if (this.c == null) {
            this.c = new ArrayList();
        }
        this.c.addItem(new SecurityAttribute(string, string2));
    }

    public void addChild(SecurityElement securityElement) {
        if (securityElement == null) {
            throw new ArgumentNullException("child");
        }
        if (this.d == null) {
            this.d = new ArrayList();
        }
        this.d.addItem(securityElement);
    }

    public String attribute(String string) {
        if (string == null) {
            throw new ArgumentNullException("name");
        }
        SecurityAttribute securityAttribute = this.a(string);
        return securityAttribute == null ? null : securityAttribute.b();
    }

    public SecurityElement copy() {
        return new SecurityElement(this);
    }

    public boolean equal(SecurityElement securityElement) {
        if (securityElement == null) {
            return false;
        }
        if (this == securityElement) {
            return true;
        }
        if (!StringExtensions.equals(this.a, securityElement.a)) {
            return false;
        }
        if (!StringExtensions.equals(this.b, securityElement.b)) {
            return false;
        }
        if (this.c == null && securityElement.c != null && securityElement.c.size() != 0) {
            return false;
        }
        if (securityElement.c == null && this.c != null && this.c.size() != 0) {
            return false;
        }
        if (this.c != null && securityElement.c != null) {
            if (this.c.size() != securityElement.c.size()) {
                return false;
            }
            for (SecurityAttribute securityAttribute : this.c) {
                SecurityAttribute securityAttribute2 = securityElement.a(securityAttribute.a());
                if (securityAttribute2 != null && StringExtensions.equals(securityAttribute.b(), securityAttribute2.b())) continue;
                return false;
            }
        }
        if (this.d == null && securityElement.d != null && securityElement.d.size() != 0) {
            return false;
        }
        if (securityElement.d == null && this.d != null && this.d.size() != 0) {
            return false;
        }
        if (this.d != null && securityElement.d != null) {
            if (this.d.size() != securityElement.d.size()) {
                return false;
            }
            for (int i2 = 0; i2 < this.d.size(); ++i2) {
                if (((SecurityElement)this.d.get_Item(i2)).equal((SecurityElement)securityElement.d.get_Item(i2))) continue;
                return false;
            }
        }
        return true;
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        if (StringExtensions.indexOfAny(string, i) == -1) {
            return string;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        int n2 = string.length();
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '<': {
                    msStringBuilder2.append("&lt;");
                    continue block7;
                }
                case '>': {
                    msStringBuilder2.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    msStringBuilder2.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    msStringBuilder2.append("&apos;");
                    continue block7;
                }
                case '&': {
                    msStringBuilder2.append("&amp;");
                    continue block7;
                }
                default: {
                    msStringBuilder2.append(c2);
                }
            }
        }
        return msStringBuilder2.toString();
    }

    private static String c(String string) {
        if (string == null) {
            return null;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder(string);
        msStringBuilder2.replace("&lt;", "<");
        msStringBuilder2.replace("&gt;", ">");
        msStringBuilder2.replace("&amp;", "&");
        msStringBuilder2.replace("&quot;", "\"");
        msStringBuilder2.replace("&apos;", "'");
        return msStringBuilder2.toString();
    }

    public static SecurityElement fromString(String string) {
        if (string == null) {
            throw new ArgumentNullException("xml");
        }
        if (string.length() == 0) {
            throw new XmlSyntaxException("Empty string.");
        }
        try {
            b b2 = new b();
            b2.d(string);
            return b2.a();
        }
        catch (Exception exception) {
            String string2 = "Invalid XML.";
            throw new XmlSyntaxException(string2, exception);
        }
    }

    public static boolean isValidAttributeName(String string) {
        return string != null && StringExtensions.indexOfAny(string, g) == -1;
    }

    public static boolean isValidAttributeValue(String string) {
        return string != null && StringExtensions.indexOfAny(string, h) == -1;
    }

    public static boolean isValidTag(String string) {
        return string != null && StringExtensions.indexOfAny(string, e) == -1;
    }

    public static boolean isValidText(String string) {
        return string != null && StringExtensions.indexOfAny(string, f) == -1;
    }

    public SecurityElement searchForChildByTag(String string) {
        if (string == null) {
            throw new ArgumentNullException("tag");
        }
        if (this.d == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.d.size(); ++i2) {
            SecurityElement securityElement = (SecurityElement)this.d.get_Item(i2);
            if (!StringExtensions.equals(securityElement.b, string)) continue;
            return securityElement;
        }
        return null;
    }

    public String searchForTextOfTag(String string) {
        if (string == null) {
            throw new ArgumentNullException("tag");
        }
        if (StringExtensions.equals(this.b, string)) {
            return this.a;
        }
        if (this.d == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.d.size(); ++i2) {
            String string2 = ((SecurityElement)this.d.get_Item(i2)).searchForTextOfTag(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder[] msStringBuilderArray = new msStringBuilder[]{msStringBuilder2};
        this.a(msStringBuilderArray, 0);
        msStringBuilder2 = msStringBuilderArray[0];
        return msStringBuilder2.toString();
    }

    private void a(msStringBuilder[] msStringBuilderArray, int n2) {
        msStringBuilderArray[0].append("<");
        msStringBuilderArray[0].append(this.b);
        if (this.c != null) {
            msStringBuilderArray[0].append(" ");
            for (int i2 = 0; i2 < this.c.size(); ++i2) {
                Object object = (SecurityAttribute)this.c.get_Item(i2);
                msStringBuilderArray[0].append(((SecurityAttribute)object).a()).append("=\"").append(SecurityElement.escape(((SecurityAttribute)object).b())).append("\"");
                if (i2 == this.c.size() - 1) continue;
                msStringBuilderArray[0].append(Environment.NewLine);
            }
        }
        if (!(this.a != null && !StringExtensions.equals(this.a, StringExtensions.Empty) || this.d != null && this.d.size() != 0)) {
            msStringBuilderArray[0].append("/>").append(Environment.NewLine);
        } else {
            msStringBuilderArray[0].append(">").append(SecurityElement.escape(this.a));
            if (this.d != null) {
                msStringBuilderArray[0].append(Environment.NewLine);
                for (Object object : this.d) {
                    super.a(msStringBuilderArray, n2 + 1);
                }
            }
            msStringBuilderArray[0].append("</").append(this.b).append(">").append(Environment.NewLine);
        }
    }

    SecurityAttribute a(String string) {
        if (this.c != null) {
            for (SecurityAttribute securityAttribute : this.c) {
                if (!StringExtensions.equals(securityAttribute.a(), string)) continue;
                return securityAttribute;
            }
        }
        return null;
    }

    static class SecurityAttribute {
        private String a;
        private String b;

        public SecurityAttribute(String string, String string2) {
            if (!SecurityElement.isValidAttributeName(string)) {
                throw new ArgumentException("Invalid XML attribute name: " + string);
            }
            if (!SecurityElement.isValidAttributeValue(string2)) {
                throw new ArgumentException("Invalid XML attribute value: " + string2);
            }
            this.a = string;
            this.b = SecurityElement.c(string2);
        }

        public String a() {
            return this.a;
        }

        public String b() {
            return this.b;
        }
    }
}

