/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs;

import com.aspose.html.utils.acs;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.Oid;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.Pkcs9AttributeObject;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.lang.Operators;

public final class Pkcs9SigningTime
extends Pkcs9AttributeObject {
    public static final String oid = "1.2.840.113549.1.9.5";
    public static final String friendlyName = "Signing Time";
    private acs a = new acs();

    public Pkcs9SigningTime() {
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
        acs.aqT().x(this.a);
        this.setRawData(this.encode());
    }

    public Pkcs9SigningTime(acs acs2) {
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
        acs2.x(this.a);
        this.setRawData(this.encode());
    }

    public Pkcs9SigningTime(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("encodedSigningTime");
        }
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
        this.setRawData(byArray);
        this.decode(byArray);
    }

    public acs getSigningTime() {
        return this.a;
    }

    @Override
    public void copyFrom(AsnEncodedData asnEncodedData) {
        if (asnEncodedData == null) {
            throw new ArgumentNullException("asnEncodedData");
        }
        this.decode(asnEncodedData.getRawData());
        this.setOid(asnEncodedData.getOid());
        this.setRawData(asnEncodedData.getRawData());
    }

    public void decode(byte[] byArray) {
        if (Operators.castToInt32(byArray[0], 6) != 23) {
            throw new CryptographicException("Only UTCTIME is supported.");
        }
        ASN1 aSN1 = new ASN1(byArray);
        byte[] byArray2 = aSN1.getValue();
        String string = Encoding.getASCII().getString(byArray2, 0, byArray2.length - 1);
        acs.a(string, "yyMMddHHmmss", null).x(this.a);
    }

    public byte[] encode() {
        if (this.a.getYear() <= 1600) {
            throw new ArgumentOutOfRangeException("<= 1600");
        }
        if (this.a.getYear() < 1950 || this.a.getYear() >= 2050) {
            throw new CryptographicException("[1950,2049]");
        }
        String string = StringExtensions.concat(this.a.toString("yyMMddHHmmss", CultureInfo.getInvariantCulture()), "Z");
        ASN1 aSN1 = new ASN1(23, Encoding.getASCII().getBytes(string));
        return aSN1.getBytes();
    }
}

